/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;

public class LiteCoordinateSequenceFactory
implements CoordinateSequenceFactory {
    public CoordinateSequence create(Coordinate[] coordinates) {
        return new LiteCoordinateSequence(coordinates);
    }

    public CoordinateSequence create(CoordinateSequence coordSeq) {
        if (coordSeq instanceof LiteCoordinateSequence) {
            LiteCoordinateSequence sequence = (LiteCoordinateSequence)coordSeq;
            return new LiteCoordinateSequence(sequence);
        }
        return new LiteCoordinateSequence(coordSeq.toCoordinateArray());
    }

    public CoordinateSequence create(int size, int dimension) {
        return new LiteCoordinateSequence(size, dimension);
    }

    public CoordinateSequence create(double[] points) {
        return new LiteCoordinateSequence(points);
    }

    public CoordinateSequence create(double[] points, int dimension) {
        return new LiteCoordinateSequence(points, dimension);
    }

    public CoordinateSequence create(int size, int dimension, int measures) {
        return new LiteCoordinateSequence(size, dimension, measures);
    }

    public static LiteCoordinateSequence lite(CoordinateSequence cs) {
        if (cs instanceof LiteCoordinateSequence) {
            LiteCoordinateSequence sequence = (LiteCoordinateSequence)cs;
            return sequence;
        }
        if (cs == null) {
            return null;
        }
        return new LiteCoordinateSequence(cs.toCoordinateArray());
    }
}

