/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ConstantExpression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;

public class AnchorPointImpl
implements AnchorPoint,
Cloneable {
    static final FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    static final AnchorPoint DEFAULT = new AnchorPointImpl(ff, (Expression)ConstantExpression.constant(0.5), (Expression)ConstantExpression.constant(0.5)){

        private void cannotModifyConstant() {
            throw new UnsupportedOperationException("Constant Stroke may not be modified");
        }

        @Override
        public void accept(StyleVisitor visitor) {
            visitor.visit((AnchorPoint)this);
        }

        @Override
        public Object accept(TraversingStyleVisitor visitor, Object data) {
            this.cannotModifyConstant();
            return null;
        }

        @Override
        public Expression getAnchorPointX() {
            return ConstantExpression.constant(0.5);
        }

        @Override
        public void setAnchorPointX(Expression x) {
            this.cannotModifyConstant();
        }

        @Override
        public Expression getAnchorPointY() {
            return ConstantExpression.constant(0.5);
        }

        @Override
        public void setAnchorPointY(Expression y) {
            this.cannotModifyConstant();
        }
    };
    private static final Logger LOGGER = Logging.getLogger(AnchorPointImpl.class);
    private final FilterFactory filterFactory;
    private Expression anchorPointX = null;
    private Expression anchorPointY = null;

    public AnchorPointImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public AnchorPointImpl(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
        try {
            this.anchorPointX = filterFactory.literal(0.0);
            this.anchorPointY = filterFactory.literal(0.5);
        }
        catch (IllegalFilterException ife) {
            LOGGER.severe("Failed to build defaultAnchorPoint: " + String.valueOf(ife));
        }
    }

    public AnchorPointImpl(FilterFactory filterFactory, Expression x, Expression y) {
        this.filterFactory = filterFactory;
        this.anchorPointX = x;
        this.anchorPointY = y;
    }

    static AnchorPointImpl cast(AnchorPoint anchor) {
        if (anchor == null) {
            return null;
        }
        if (anchor instanceof AnchorPointImpl) {
            AnchorPointImpl impl = (AnchorPointImpl)anchor;
            return impl;
        }
        AnchorPointImpl copy = new AnchorPointImpl();
        copy.setAnchorPointX(anchor.getAnchorPointX());
        copy.setAnchorPointY(anchor.getAnchorPointY());
        return copy;
    }

    public Expression getAnchorPointX() {
        return this.anchorPointX;
    }

    public void setAnchorPointX(Expression anchorPointX) {
        this.anchorPointX = anchorPointX;
    }

    public Expression getAnchorPointY() {
        return this.anchorPointY;
    }

    public void setAnchorPointY(Expression anchorPointY) {
        this.anchorPointY = anchorPointY;
    }

    public void getAnchorPointY(double x) {
        this.anchorPointY = this.filterFactory.literal(x);
    }

    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit((AnchorPoint)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((AnchorPoint)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Never happen");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AnchorPointImpl) {
            AnchorPointImpl other = (AnchorPointImpl)obj;
            return Utilities.equals((Object)this.anchorPointX, (Object)other.anchorPointX) && Utilities.equals((Object)this.anchorPointY, (Object)other.anchorPointY);
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 17;
        if (this.anchorPointX != null) {
            result = result * 37 + this.anchorPointX.hashCode();
        }
        if (this.anchorPointY != null) {
            result = result * 37 + this.anchorPointY.hashCode();
        }
        return result;
    }
}

