/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.Font;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.Utilities;

public class FontImpl
implements Font,
Cloneable {
    private final List<Expression> fontFamily = new ArrayList<Expression>();
    private Expression fontSize = null;
    private Expression fontStyle = null;
    private Expression fontWeight = null;

    protected FontImpl() {
    }

    public List<Expression> getFamily() {
        return this.fontFamily;
    }

    public Expression getSize() {
        return this.fontSize;
    }

    public void setSize(Expression size) {
        this.fontSize = size;
    }

    public Expression getStyle() {
        return this.fontStyle;
    }

    public void setStyle(Expression style) {
        this.fontStyle = style;
    }

    public Expression getWeight() {
        return this.fontWeight;
    }

    public void setWeight(Expression weight) {
        this.fontWeight = weight;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This should not happen", e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fontFamily != null) {
            result = 1000003 * result + this.fontFamily.hashCode();
        }
        if (this.fontSize != null) {
            result = 1000003 * result + this.fontSize.hashCode();
        }
        if (this.fontStyle != null) {
            result = 1000003 * result + this.fontStyle.hashCode();
        }
        if (this.fontWeight != null) {
            result = 1000003 * result + this.fontWeight.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth instanceof FontImpl) {
            FontImpl other = (FontImpl)oth;
            return Utilities.equals(this.fontFamily, other.fontFamily) && Utilities.equals((Object)this.fontSize, (Object)other.fontSize) && Utilities.equals((Object)this.fontStyle, (Object)other.fontStyle) && Utilities.equals((Object)this.fontWeight, (Object)other.fontWeight);
        }
        return false;
    }

    static Font createDefault(FilterFactory filterFactory) {
        FontImpl font = new FontImpl();
        try {
            font.setSize((Expression)filterFactory.literal((Object)10));
            font.setStyle((Expression)filterFactory.literal((Object)"normal"));
            font.setWeight((Expression)filterFactory.literal((Object)"normal"));
            font.getFamily().add(filterFactory.literal((Object)"Serif"));
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating default", ife);
        }
        return font;
    }

    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit((Font)this, data);
    }

    static FontImpl cast(Font font) {
        if (font == null) {
            return null;
        }
        if (font instanceof FontImpl) {
            FontImpl impl = (FontImpl)font;
            return impl;
        }
        FontImpl copy = new FontImpl();
        copy.getFamily().addAll(font.getFamily());
        copy.setSize(font.getSize());
        copy.setStyle(font.getStyle());
        copy.setWeight(font.getWeight());
        return copy;
    }
}

