/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicFill;
import org.geotools.api.style.GraphicLegend;
import org.geotools.api.style.GraphicStroke;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Mark;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.Symbol;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ConstantExpression;
import org.geotools.styling.AnchorPointImpl;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.ExternalGraphicImpl;
import org.geotools.styling.MarkImpl;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;

public class GraphicImpl
implements GraphicLegend,
Graphic,
GraphicFill,
GraphicStroke,
Cloneable {
    public static final Graphic DEFAULT = new ConstantGraphic(){

        @Override
        public List<GraphicalSymbol> graphicalSymbols() {
            return Collections.emptyList();
        }

        public Expression getOpacity() {
            return ConstantExpression.ONE;
        }

        public Expression getSize() {
            return Expression.NIL;
        }

        public Displacement getDisplacement() {
            return DisplacementImpl.DEFAULT;
        }

        public Expression getRotation() {
            return ConstantExpression.ZERO;
        }
    };
    public static final Graphic NULL = new ConstantGraphic(){

        @Override
        public List<GraphicalSymbol> graphicalSymbols() {
            return Collections.emptyList();
        }

        public Expression getOpacity() {
            return ConstantExpression.NULL;
        }

        public Expression getSize() {
            return ConstantExpression.NULL;
        }

        public Displacement getDisplacement() {
            return DisplacementImpl.NULL;
        }

        public Expression getRotation() {
            return ConstantExpression.NULL;
        }
    };
    private final List<GraphicalSymbol> graphics = new ArrayList<GraphicalSymbol>();
    private AnchorPointImpl anchor;
    private Expression gap;
    private Expression initialGap;
    private Expression rotation = null;
    private Expression size = null;
    private DisplacementImpl displacement = null;
    private Expression opacity = null;

    protected GraphicImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public GraphicImpl(FilterFactory factory) {
        this(factory, null, null, null);
    }

    public GraphicImpl(FilterFactory factory, AnchorPoint anchor, Expression gap, Expression initialGap) {
        this.anchor = AnchorPointImpl.cast(anchor);
        this.gap = gap == null ? ConstantExpression.constant(0) : gap;
        this.initialGap = initialGap == null ? ConstantExpression.constant(0) : initialGap;
    }

    public List<GraphicalSymbol> graphicalSymbols() {
        return this.graphics;
    }

    public AnchorPoint getAnchorPoint() {
        return this.anchor;
    }

    public void setAnchorPoint(AnchorPoint anchor) {
        this.anchor = AnchorPointImpl.cast(anchor);
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    public Expression getRotation() {
        return this.rotation;
    }

    public Expression getSize() {
        return this.size;
    }

    public Displacement getDisplacement() {
        return this.displacement;
    }

    public Expression getInitialGap() {
        return this.initialGap;
    }

    public void setInitialGap(Expression initialGap) {
        this.initialGap = initialGap;
    }

    public Expression getGap() {
        return this.gap;
    }

    public void setGap(Expression gap) {
        this.gap = gap;
    }

    public void setDisplacement(Displacement offset) {
        this.displacement = DisplacementImpl.cast(offset);
    }

    public void setOpacity(Expression opacity) {
        this.opacity = opacity;
    }

    public void setRotation(Expression rotation) {
        this.rotation = rotation;
    }

    public void setSize(Expression size) {
        this.size = size;
    }

    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit((GraphicStroke)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Graphic)this);
    }

    public Object clone() {
        GraphicImpl clone;
        try {
            clone = (GraphicImpl)super.clone();
            clone.graphics.clear();
            clone.graphics.addAll(this.graphics);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.graphics != null) {
            result = 1000003 * result + this.graphics.hashCode();
        }
        if (this.rotation != null) {
            result = 1000003 * result + this.rotation.hashCode();
        }
        if (this.size != null) {
            result = 1000003 * result + this.size.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof GraphicImpl) {
            GraphicImpl other = (GraphicImpl)oth;
            return Utilities.equals((Object)this.size, (Object)other.size) && Utilities.equals((Object)this.rotation, (Object)other.rotation) && Utilities.equals((Object)this.opacity, (Object)other.opacity) && Objects.equals(this.graphicalSymbols(), other.graphicalSymbols());
        }
        return false;
    }

    static GraphicImpl cast(Graphic graphic) {
        if (graphic == null) {
            return null;
        }
        if (graphic instanceof GraphicImpl) {
            GraphicImpl impl = (GraphicImpl)graphic;
            return impl;
        }
        GraphicImpl copy = new GraphicImpl();
        copy.setAnchorPoint(graphic.getAnchorPoint());
        copy.setDisplacement(graphic.getDisplacement());
        if (graphic.graphicalSymbols() != null) {
            for (GraphicalSymbol item : graphic.graphicalSymbols()) {
                if (item instanceof ExternalGraphic) {
                    copy.graphicalSymbols().add(ExternalGraphicImpl.cast(item));
                    continue;
                }
                if (!(item instanceof Mark)) continue;
                copy.graphicalSymbols().add((GraphicalSymbol)MarkImpl.cast(item));
            }
        }
        return copy;
    }

    public static abstract class ConstantGraphic
    implements Graphic,
    GraphicStroke,
    GraphicFill {
        private void cannotModifyConstant() {
            throw new UnsupportedOperationException("Constant Graphic may not be modified");
        }

        public void setDisplacement(Displacement offset) {
            this.cannotModifyConstant();
        }

        public void setExternalGraphics(ExternalGraphic ... externalGraphics) {
            this.cannotModifyConstant();
        }

        public void addExternalGraphic(ExternalGraphic externalGraphic) {
            this.cannotModifyConstant();
        }

        public void setMarks(Mark ... marks) {
            this.cannotModifyConstant();
        }

        public void addMark(Mark mark) {
            this.cannotModifyConstant();
        }

        public void setGap(Expression gap) {
            this.cannotModifyConstant();
        }

        public void setInitialGap(Expression initialGap) {
            this.cannotModifyConstant();
        }

        public void setSymbols(Symbol ... symbols) {
            this.cannotModifyConstant();
        }

        public void addSymbol(Symbol symbol) {
            this.cannotModifyConstant();
        }

        public void setOpacity(Expression opacity) {
            this.cannotModifyConstant();
        }

        public void setSize(Expression size) {
            this.cannotModifyConstant();
        }

        public void setRotation(Expression rotation) {
            this.cannotModifyConstant();
        }

        public void setAnchorPoint(AnchorPoint anchor) {
            this.cannotModifyConstant();
        }

        public Object accept(TraversingStyleVisitor visitor, Object data) {
            return visitor.visit((GraphicStroke)this, data);
        }

        public void accept(StyleVisitor visitor) {
            visitor.visit((Graphic)this);
        }

        public List<GraphicalSymbol> graphicalSymbols() {
            return Collections.emptyList();
        }

        public AnchorPoint getAnchorPoint() {
            return AnchorPointImpl.DEFAULT;
        }

        public Expression getGap() {
            return ConstantExpression.constant(0);
        }

        public Expression getInitialGap() {
            return ConstantExpression.constant(0);
        }
    }
}

