/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.awt.Color;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import org.geotools.api.data.DataStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Halo;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.api.style.SemanticType;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.api.style.UserLayer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.Filters;
import org.geotools.styling.FillImpl;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class SLD {
    private static StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    private static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    public static final int NOTFOUND = -1;
    public static final double ALIGN_LEFT = 1.0;
    public static final double ALIGN_CENTER = 0.5;
    public static final double ALIGN_RIGHT = 0.0;
    public static final double ALIGN_BOTTOM = 1.0;
    public static final double ALIGN_MIDDLE = 0.5;
    public static final double ALIGN_TOP = 0.0;

    public static Color lineColor(LineSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Stroke stroke = symbolizer.getStroke();
        return SLD.color(stroke);
    }

    public static Color color(Stroke stroke) {
        if (stroke == null) {
            return null;
        }
        return SLD.color(stroke.getColor());
    }

    public static Color color(Fill fill) {
        if (fill == null) {
            return null;
        }
        return SLD.color(fill.getColor());
    }

    public static void setLineColour(Style style, final Color colour) {
        if (style == null) {
            return;
        }
        for (FeatureTypeStyle featureTypeStyle : style.featureTypeStyles()) {
            for (int i = 0; i < featureTypeStyle.rules().size(); ++i) {
                Rule rule = (Rule)featureTypeStyle.rules().get(i);
                DuplicatingStyleVisitor update = new DuplicatingStyleVisitor(){

                    @Override
                    public void visit(LineSymbolizer line) {
                        String name = line.getGeometryPropertyName();
                        Stroke stroke = this.update(line.getStroke());
                        LineSymbolizer copy = this.sf.createLineSymbolizer(stroke, name);
                        this.pages.push(copy);
                    }

                    Stroke update(Stroke stroke) {
                        Literal color = this.ff.literal((Object)colour);
                        Expression width = this.copy(stroke.getWidth());
                        Expression opacity = this.copy(stroke.getOpacity());
                        Expression lineJoin = this.copy(stroke.getLineJoin());
                        Expression lineCap = this.copy(stroke.getLineCap());
                        float[] dashArray = this.copy(stroke.getDashArray());
                        Expression dashOffset = this.copy(stroke.getDashOffset());
                        Graphic graphicStroke = this.copy(stroke.getGraphicStroke());
                        Graphic graphicFill = this.copy(stroke.getGraphicFill());
                        return this.sf.createStroke((Expression)color, width, opacity, lineJoin, lineCap, dashArray, dashOffset, graphicFill, graphicStroke);
                    }
                };
                rule.accept((StyleVisitor)update);
                Rule updatedRule = (Rule)update.getCopy();
                featureTypeStyle.rules().set(i, updatedRule);
            }
        }
    }

    public static void setLineColour(LineSymbolizer symbolizer, Color colour) {
        if (symbolizer == null || colour == null) {
            return;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            stroke = sf.createStroke((Expression)ff.literal((Object)colour), StrokeImpl.DEFAULT.getWidth());
            symbolizer.setStroke(stroke);
        } else {
            stroke.setColor((Expression)ff.literal((Object)colour));
        }
    }

    public static Color color(LineSymbolizer symbolizer) {
        return SLD.lineColor(symbolizer);
    }

    public static int lineWidth(LineSymbolizer symbolizer) {
        if (symbolizer == null) {
            return -1;
        }
        Stroke stroke = symbolizer.getStroke();
        return SLD.width(stroke);
    }

    public static int width(Stroke stroke) {
        if (stroke == null) {
            return -1;
        }
        return Filters.asInt(stroke.getWidth());
    }

    public static int size(Mark mark) {
        return -1;
    }

    public static int width(LineSymbolizer symbolizer) {
        return SLD.lineWidth(symbolizer);
    }

    public static double lineOpacity(LineSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        Stroke stroke = symbolizer.getStroke();
        return SLD.opacity(stroke);
    }

    public static double opacity(Stroke stroke) {
        if (stroke == null) {
            return Double.NaN;
        }
        return SLD.opacity(stroke.getOpacity());
    }

    public static double opacity(RasterSymbolizer rasterSymbolizer) {
        if (rasterSymbolizer == null) {
            return 1.0;
        }
        return SLD.opacity(rasterSymbolizer.getOpacity());
    }

    private static double opacity(Expression opacity) {
        if (opacity == null) {
            return 1.0;
        }
        double value = Filters.asDouble(opacity);
        return Double.isNaN(value) ? 1.0 : value;
    }

    public static String lineLinejoin(LineSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            return null;
        }
        Expression linejoinExp = stroke.getLineJoin();
        return linejoinExp.toString();
    }

    public static String lineLinecap(LineSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            return null;
        }
        Expression linecapExp = stroke.getLineCap();
        return linecapExp.toString();
    }

    public static float[] lineDash(LineSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            return null;
        }
        float[] linedash = stroke.getDashArray();
        return linedash;
    }

    public static URL pointGraphic(Style style) {
        PointSymbolizer point = SLD.pointSymbolizer(style);
        if (point == null) {
            return null;
        }
        Graphic graphic = point.getGraphic();
        if (graphic == null) {
            return null;
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            if (gs == null || !(gs instanceof ExternalGraphic)) continue;
            ExternalGraphic externalGraphic = (ExternalGraphic)gs;
            try {
                URL location = externalGraphic.getLocation();
                if (location == null) continue;
                return location;
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return null;
    }

    public static Mark pointMark(Style style) {
        if (style == null) {
            return null;
        }
        return SLD.mark(SLD.pointSymbolizer(style));
    }

    public static Mark mark(PointSymbolizer sym) {
        return SLD.mark(SLD.graphic(sym));
    }

    public static Mark mark(Graphic graphic) {
        if (graphic == null) {
            return null;
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            if (gs == null || !(gs instanceof Mark)) continue;
            Mark mark = (Mark)gs;
            return mark;
        }
        return null;
    }

    public static Graphic graphic(PointSymbolizer sym) {
        if (sym == null) {
            return null;
        }
        return sym.getGraphic();
    }

    public static int pointSize(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return -1;
        }
        Graphic g = symbolizer.getGraphic();
        if (g == null) {
            return -1;
        }
        Expression exp = g.getSize();
        return Filters.asInt(exp);
    }

    public static String pointWellKnownName(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return null;
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            Mark mark;
            String s;
            if (gs == null || !(gs instanceof Mark) || (s = SLD.wellKnownName(mark = (Mark)gs)) == null) continue;
            return s;
        }
        return null;
    }

    public static String wellKnownName(Mark mark) {
        if (mark == null) {
            return null;
        }
        Expression exp = mark.getWellKnownName();
        if (exp == null) {
            return null;
        }
        return Filters.asString(exp);
    }

    public static Color pointColor(PointSymbolizer symbolizer) {
        return SLD.color(symbolizer);
    }

    public static void setPointColour(Style style, Color colour) {
        if (style == null) {
            return;
        }
        SLD.setPointColour(SLD.pointSymbolizer(style), colour);
    }

    public static void setPointColour(PointSymbolizer symbolizer, Color colour) {
        if (symbolizer == null || colour == null) {
            return;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            graphic = sf.createDefaultGraphic();
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            Fill fill;
            if (gs == null || !(gs instanceof Mark)) continue;
            Mark mark = (Mark)gs;
            Stroke stroke = mark.getStroke();
            if (stroke == null) {
                stroke = sf.createStroke((Expression)ff.literal((Object)Color.BLACK), StrokeImpl.DEFAULT.getWidth());
                mark.setStroke(stroke);
            }
            if ((fill = mark.getFill()) == null) continue;
            fill.setColor((Expression)ff.literal((Object)colour));
        }
    }

    public static Color color(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return null;
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            Color colour;
            Mark mark;
            Stroke stroke;
            if (gs == null || !(gs instanceof Mark) || (stroke = (mark = (Mark)gs).getStroke()) == null || (colour = SLD.color(stroke)) == null) continue;
            return colour;
        }
        return null;
    }

    public static int pointWidth(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return -1;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return -1;
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            int width;
            Expression exp;
            Mark mark;
            Stroke stroke;
            if (gs == null || !(gs instanceof Mark) || (stroke = (mark = (Mark)gs).getStroke()) == null || (exp = stroke.getWidth()) == null || (width = Filters.asInt(exp)) == -1) continue;
            return width;
        }
        return -1;
    }

    public static double pointBorderOpacity(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return Double.NaN;
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            Mark mark;
            Stroke stroke;
            if (gs == null || !(gs instanceof Mark) || (stroke = (mark = (Mark)gs).getStroke()) == null) continue;
            Expression exp = stroke.getOpacity();
            return Filters.asDouble(exp);
        }
        return Double.NaN;
    }

    public static double pointOpacity(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return Double.NaN;
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            Expression expr;
            Mark mark;
            Fill fill;
            if (gs == null || !(gs instanceof Mark) || (fill = (mark = (Mark)gs).getFill()) == null || (expr = fill.getOpacity()) == null) continue;
            return SLD.opacity(expr);
        }
        return Double.NaN;
    }

    public static Color pointFill(PointSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Graphic graphic = symbolizer.getGraphic();
        if (graphic == null) {
            return null;
        }
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            Color colour;
            Mark mark;
            Fill fill;
            if (gs == null || !(gs instanceof Mark) || (fill = (mark = (Mark)gs).getFill()) == null || (colour = SLD.color(fill.getColor())) == null) continue;
            return colour;
        }
        return null;
    }

    public static int polyWidth(PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return -1;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke != null) {
            return Filters.asInt(stroke.getWidth());
        }
        return -1;
    }

    public static Color polyColor(PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            return null;
        }
        Color colour = SLD.color(stroke.getColor());
        if (colour != null) {
            return colour;
        }
        return null;
    }

    public static void setRasterOpacity(Style style, final double opacity) {
        if (style == null) {
            return;
        }
        for (FeatureTypeStyle featureTypeStyle : style.featureTypeStyles()) {
            for (int i = 0; i < featureTypeStyle.rules().size(); ++i) {
                Rule rule = (Rule)featureTypeStyle.rules().get(i);
                DuplicatingStyleVisitor update = new DuplicatingStyleVisitor(){

                    @Override
                    public void visit(RasterSymbolizer raster) {
                        ChannelSelection channelSelection = this.copy(raster.getChannelSelection());
                        ColorMap colorMap = this.copy(raster.getColorMap());
                        ContrastEnhancement ce = this.copy(raster.getContrastEnhancement());
                        String geometryProperty = raster.getGeometryPropertyName();
                        Symbolizer outline = this.copy(raster.getImageOutline());
                        Expression overlap = this.copy(raster.getOverlap());
                        ShadedRelief shadedRelief = this.copy(raster.getShadedRelief());
                        Literal newOpacity = this.ff.literal(opacity);
                        RasterSymbolizer copy = this.sf.createRasterSymbolizer(geometryProperty, (Expression)newOpacity, channelSelection, overlap, colorMap, ce, shadedRelief, outline);
                        if (this.STRICT && !copy.equals(raster)) {
                            throw new IllegalStateException("Was unable to duplicate provided raster:" + String.valueOf(raster));
                        }
                        this.pages.push(copy);
                    }
                };
                rule.accept((StyleVisitor)update);
                Rule updatedRule = (Rule)update.getCopy();
                featureTypeStyle.rules().set(i, updatedRule);
            }
        }
    }

    public static void setChannelSelection(Style style, final SelectedChannelType[] rgb, final SelectedChannelType gray) {
        if (style == null) {
            return;
        }
        for (FeatureTypeStyle featureTypeStyle : style.featureTypeStyles()) {
            for (int i = 0; i < featureTypeStyle.rules().size(); ++i) {
                Rule rule = (Rule)featureTypeStyle.rules().get(i);
                DuplicatingStyleVisitor update = new DuplicatingStyleVisitor(){

                    @Override
                    public void visit(RasterSymbolizer raster) {
                        ChannelSelection channelSelection = this.createChannelSelection();
                        ColorMap colorMap = this.copy(raster.getColorMap());
                        ContrastEnhancement ce = this.copy(raster.getContrastEnhancement());
                        String geometryProperty = raster.getGeometryPropertyName();
                        Symbolizer outline = this.copy(raster.getImageOutline());
                        Expression overlap = this.copy(raster.getOverlap());
                        ShadedRelief shadedRelief = this.copy(raster.getShadedRelief());
                        Expression opacity = this.copy(raster.getOpacity());
                        RasterSymbolizer copy = this.sf.createRasterSymbolizer(geometryProperty, opacity, channelSelection, overlap, colorMap, ce, shadedRelief, outline);
                        if (this.STRICT && !copy.equals(raster)) {
                            throw new IllegalStateException("Was unable to duplicate provided raster:" + String.valueOf(raster));
                        }
                        this.pages.push(copy);
                    }

                    private ChannelSelection createChannelSelection() {
                        if (rgb != null) {
                            return this.sf.createChannelSelection(rgb);
                        }
                        return this.sf.createChannelSelection(new SelectedChannelType[]{gray});
                    }
                };
                rule.accept((StyleVisitor)update);
                Rule updatedRule = (Rule)update.getCopy();
                featureTypeStyle.rules().set(i, updatedRule);
            }
        }
    }

    public static void setPolyColour(Style style, Color colour) {
        if (style == null) {
            return;
        }
        SLD.setPolyColour(SLD.polySymbolizer(style), colour);
    }

    public static void setPolyColour(PolygonSymbolizer symbolizer, Color colour) {
        if (symbolizer == null || colour == null) {
            return;
        }
        Literal colourExp = ff.literal((Object)colour);
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            stroke = sf.createStroke((Expression)colourExp, StrokeImpl.DEFAULT.getWidth());
            symbolizer.setStroke(stroke);
        } else {
            stroke.setColor((Expression)ff.literal((Object)colour));
        }
        Fill fill = symbolizer.getFill();
        if (fill != null) {
            fill.setColor((Expression)colourExp);
        }
    }

    public static Color polyFill(PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Fill fill = symbolizer.getFill();
        if (fill == null) {
            return null;
        }
        return SLD.color(fill.getColor());
    }

    public static double polyBorderOpacity(PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        Stroke stroke = symbolizer.getStroke();
        if (stroke == null) {
            return Double.NaN;
        }
        return SLD.opacity(stroke);
    }

    public static double polyFillOpacity(PolygonSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        Fill fill = symbolizer.getFill();
        return SLD.opacity(fill);
    }

    public static double opacity(Fill fill) {
        Expression opacityExp;
        if (fill == null) {
            fill = FillImpl.DEFAULT;
        }
        if ((opacityExp = fill.getOpacity()) == null) {
            opacityExp = FillImpl.DEFAULT.getOpacity();
        }
        return Filters.asDouble(opacityExp);
    }

    public static double rasterOpacity(RasterSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        return Filters.asDouble(symbolizer.getOpacity());
    }

    public static double rasterOpacity(Style style) {
        return SLD.rasterOpacity(SLD.rasterSymbolizer(style));
    }

    public static TextSymbolizer textSymbolizer(FeatureTypeStyle fts) {
        return (TextSymbolizer)SLD.symbolizer(fts, TextSymbolizer.class);
    }

    public static TextSymbolizer textSymbolizer(Style style) {
        return (TextSymbolizer)SLD.symbolizer(style, TextSymbolizer.class);
    }

    public static Font font(TextSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        return symbolizer.getFont();
    }

    public static Expression textLabel(TextSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Expression exp = symbolizer.getLabel();
        if (exp == null) {
            return null;
        }
        return exp;
    }

    public static String textLabelString(TextSymbolizer symbolizer) {
        Expression exp = SLD.textLabel(symbolizer);
        return exp == null ? null : exp.toString();
    }

    public static Color textFontFill(TextSymbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        Fill fill = symbolizer.getFill();
        if (fill == null) {
            return null;
        }
        return SLD.color(fill.getColor());
    }

    public static Color textHaloFill(TextSymbolizer symbolizer) {
        Halo halo = symbolizer.getHalo();
        if (halo == null) {
            return null;
        }
        Fill fill = halo.getFill();
        if (fill == null) {
            return null;
        }
        return SLD.color(fill.getColor());
    }

    public static int textHaloWidth(TextSymbolizer symbolizer) {
        Halo halo = symbolizer.getHalo();
        if (halo == null) {
            return 0;
        }
        Expression exp = halo.getRadius();
        if (exp == null) {
            return 0;
        }
        int width = (int)Float.parseFloat(exp.toString());
        if (width != 0) {
            return width;
        }
        return 0;
    }

    public static double textHaloOpacity(TextSymbolizer symbolizer) {
        if (symbolizer == null) {
            return Double.NaN;
        }
        Halo halo = symbolizer.getHalo();
        if (halo == null) {
            return Double.NaN;
        }
        Fill fill = halo.getFill();
        if (fill == null) {
            return Double.NaN;
        }
        Expression expr = fill.getOpacity();
        if (expr == null) {
            return Double.NaN;
        }
        return Filters.asDouble(expr);
    }

    public static Color color(Expression expr) {
        if (expr == null) {
            return null;
        }
        return (Color)expr.evaluate(null, Color.class);
    }

    public static RasterSymbolizer rasterSymbolizer(FeatureTypeStyle fts) {
        return (RasterSymbolizer)SLD.symbolizer(fts, RasterSymbolizer.class);
    }

    public static RasterSymbolizer rasterSymbolizer(Style style) {
        return (RasterSymbolizer)SLD.symbolizer(style, RasterSymbolizer.class);
    }

    public static LineSymbolizer lineSymbolizer(FeatureTypeStyle fts) {
        return (LineSymbolizer)SLD.symbolizer(fts, LineSymbolizer.class);
    }

    public static LineSymbolizer lineSymbolizer(Style style) {
        return (LineSymbolizer)SLD.symbolizer(style, LineSymbolizer.class);
    }

    public static Stroke stroke(LineSymbolizer sym) {
        if (sym == null) {
            return null;
        }
        return sym.getStroke();
    }

    public static Stroke stroke(PolygonSymbolizer sym) {
        if (sym == null) {
            return null;
        }
        return sym.getStroke();
    }

    public static Stroke stroke(PointSymbolizer sym) {
        Mark mark = SLD.mark(sym);
        return mark == null ? null : mark.getStroke();
    }

    public static Fill fill(PolygonSymbolizer sym) {
        if (sym == null) {
            return null;
        }
        return sym.getFill();
    }

    public static Fill fill(PointSymbolizer sym) {
        Mark mark = SLD.mark(sym);
        return mark == null ? null : mark.getFill();
    }

    public static PointSymbolizer pointSymbolizer(FeatureTypeStyle fts) {
        return (PointSymbolizer)SLD.symbolizer(fts, PointSymbolizer.class);
    }

    public static PointSymbolizer pointSymbolizer(Style style) {
        return (PointSymbolizer)SLD.symbolizer(style, PointSymbolizer.class);
    }

    public static PolygonSymbolizer polySymbolizer(FeatureTypeStyle fts) {
        return (PolygonSymbolizer)SLD.symbolizer(fts, PolygonSymbolizer.class);
    }

    public static PolygonSymbolizer polySymbolizer(Style style) {
        return (PolygonSymbolizer)SLD.symbolizer(style, PolygonSymbolizer.class);
    }

    public static FeatureTypeStyle featureTypeStyle(Style style, SimpleFeatureType type) {
        if (style == null) {
            return null;
        }
        if (type == null || type.getTypeName() == null) {
            return null;
        }
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            if (!type.getTypeName().equalsIgnoreCase(fts.getName())) continue;
            return fts;
        }
        return null;
    }

    public static Style matchingStyle(Style[] styles, SimpleFeatureType schema) {
        if (styles == null || styles.length == 0) {
            return null;
        }
        for (Style style : styles) {
            if (SLD.featureTypeStyle(style, schema) == null) continue;
            return style;
        }
        return null;
    }

    protected static Symbolizer symbolizer(Style style, Class SYMBOLIZER) {
        if (style == null) {
            return null;
        }
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            Symbolizer sym = SLD.symbolizer(fts, SYMBOLIZER);
            if (sym == null) continue;
            return sym;
        }
        return null;
    }

    protected static Symbolizer symbolizer(FeatureTypeStyle fts, Class SYMBOLIZER) {
        if (fts == null) {
            return null;
        }
        for (Rule rule : fts.rules()) {
            for (Symbolizer sym : rule.symbolizers()) {
                if (!SYMBOLIZER.isInstance(sym)) continue;
                return sym;
            }
        }
        return null;
    }

    public static String colorToHex(Color c) {
        return "#" + Integer.toHexString(c.getRGB() & 0xFFFFFF);
    }

    public static Style[] styles(StyledLayerDescriptor sld) {
        StyledLayer[] layers = sld.getStyledLayers();
        ArrayList styles = new ArrayList();
        for (StyledLayer styledLayer : layers) {
            if (styledLayer instanceof UserLayer) {
                UserLayer layer = (UserLayer)styledLayer;
                styles.addAll(layer.userStyles());
                continue;
            }
            if (!(styledLayer instanceof NamedLayer)) continue;
            NamedLayer layer = (NamedLayer)styledLayer;
            styles.addAll(layer.styles());
        }
        return styles.toArray(new Style[0]);
    }

    public static FeatureTypeStyle[] featureTypeStyles(StyledLayerDescriptor sld) {
        Style[] style = SLD.styles(sld);
        ArrayList fts = new ArrayList();
        for (Style value : style) {
            fts.addAll(value.featureTypeStyles());
        }
        return fts.toArray(new FeatureTypeStyle[0]);
    }

    public static FeatureTypeStyle featureTypeStyle(StyledLayerDescriptor sld, SimpleFeatureType type) {
        Style[] styles;
        for (Style style : styles = SLD.styles(sld)) {
            for (FeatureTypeStyle fts : style.featureTypeStyles()) {
                if (!type.getTypeName().equalsIgnoreCase(fts.getName())) continue;
                return fts;
            }
        }
        return null;
    }

    public static Style defaultStyle(StyledLayerDescriptor sld) {
        Style[] style;
        for (Style value : style = SLD.styles(sld)) {
            if (!value.isDefault()) continue;
            return value;
        }
        if (style.length == 0) {
            return null;
        }
        return style[0];
    }

    public static Filter[] filters(Rule ... rule) {
        Filter[] filter = new Filter[rule.length];
        for (int i = 0; i < rule.length; ++i) {
            filter[i] = rule[0].getFilter();
        }
        return filter;
    }

    public static Filter[] filters(Style style) {
        Rule[] rule = SLD.rules(style);
        return SLD.filters(rule);
    }

    public static Rule[] rules(Style style) {
        HashSet ruleSet = new HashSet();
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            ruleSet.addAll(fts.rules());
        }
        if (ruleSet.isEmpty()) {
            return new Rule[0];
        }
        return ruleSet.toArray(new Rule[0]);
    }

    public static Symbolizer[] symbolizers(Style style) {
        HashSet symbolizers = new HashSet();
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            for (Rule rule : fts.rules()) {
                symbolizers.addAll(rule.symbolizers());
            }
        }
        if (symbolizers.isEmpty()) {
            return new Symbolizer[0];
        }
        return symbolizers.toArray(new Symbolizer[0]);
    }

    public static Symbolizer[] symbolizers(Rule rule) {
        HashSet symbolizers = new HashSet();
        symbolizers.addAll(rule.symbolizers());
        if (symbolizers.isEmpty()) {
            return new Symbolizer[0];
        }
        return symbolizers.toArray(new Symbolizer[0]);
    }

    public static String[] colors(Style style) {
        HashSet<String> colorSet = new HashSet<String>();
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            for (Rule rule : fts.rules()) {
                String[] color;
                for (String s : color = SLD.colors(rule)) {
                    colorSet.add(s);
                }
            }
        }
        if (colorSet.isEmpty()) {
            return new String[0];
        }
        return colorSet.toArray(new String[0]);
    }

    public static String[] colors(Rule rule) {
        HashSet<String> colorSet = new HashSet<String>();
        Color color = null;
        for (Symbolizer sym : rule.symbolizers()) {
            if (sym instanceof PolygonSymbolizer) {
                PolygonSymbolizer symb = (PolygonSymbolizer)sym;
                color = SLD.polyFill(symb);
            } else if (sym instanceof LineSymbolizer) {
                LineSymbolizer symb = (LineSymbolizer)sym;
                color = SLD.color(symb);
            } else if (sym instanceof PointSymbolizer) {
                PointSymbolizer symb = (PointSymbolizer)sym;
                color = SLD.color(symb);
            }
            if (color == null) continue;
            colorSet.add(color.toString());
        }
        if (colorSet.isEmpty()) {
            return new String[0];
        }
        return colorSet.toArray(new String[0]);
    }

    public static String toHTMLColor(Color color) {
        if (color == null) {
            return null;
        }
        Object red = "0" + Integer.toHexString(color.getRed());
        red = ((String)red).substring(((String)red).length() - 2);
        Object grn = "0" + Integer.toHexString(color.getGreen());
        grn = ((String)grn).substring(((String)grn).length() - 2);
        Object blu = "0" + Integer.toHexString(color.getBlue());
        blu = ((String)blu).substring(((String)blu).length() - 2);
        return ("#" + (String)red + (String)grn + (String)blu).toUpperCase();
    }

    public static Color toColor(String htmlColor) {
        return new Color(Integer.parseInt(htmlColor.substring(1), 16));
    }

    public static boolean isSemanticTypeMatch(FeatureTypeStyle fts, String regex) {
        for (SemanticType id : fts.semanticTypeIdentifiers()) {
            if (!id.matches(regex)) continue;
            return true;
        }
        return false;
    }

    public static double minScale(FeatureTypeStyle fts) {
        if (fts == null || fts.rules().isEmpty()) {
            return 0.0;
        }
        return ((Rule)fts.rules().get(0)).getMinScaleDenominator();
    }

    public static double maxScale(FeatureTypeStyle fts) {
        if (fts == null || fts.rules().isEmpty()) {
            return Double.NaN;
        }
        return ((Rule)fts.rules().get(0)).getMaxScaleDenominator();
    }

    public static PointPlacement getPlacement(double horizAlign, double vertAlign, double rotation) {
        AnchorPoint anchorPoint = sf.createAnchorPoint((Expression)ff.literal(horizAlign), (Expression)ff.literal(vertAlign));
        return sf.createPointPlacement(anchorPoint, null, (Expression)ff.literal(rotation));
    }

    public static Style createSimpleStyle(DataStore store, String typeName, Color color) throws IOException {
        SimpleFeatureType type = store.getSchema(typeName);
        return SLD.createSimpleStyle((FeatureType)type, color);
    }

    public static Style createSimpleStyle(FeatureType type) {
        return SLD.createSimpleStyle(type, Color.BLACK);
    }

    public static Style createSimpleStyle(FeatureType type, Color color) {
        GeometryDescriptor desc = type.getGeometryDescriptor();
        Class clazz = desc.getType().getBinding();
        Color fillColor = null;
        if (Polygon.class.isAssignableFrom(clazz) || MultiPolygon.class.isAssignableFrom(clazz)) {
            fillColor = color.equals(Color.BLACK) ? null : color;
            return SLD.createPolygonStyle(color, fillColor, 0.5f);
        }
        if (LineString.class.isAssignableFrom(clazz) || MultiLineString.class.isAssignableFrom(clazz)) {
            return SLD.createLineStyle(color, 1.0f);
        }
        if (Point.class.isAssignableFrom(clazz) || MultiPoint.class.isAssignableFrom(clazz)) {
            fillColor = color.equals(Color.BLACK) ? null : color;
            return SLD.createPointStyle("Circle", color, fillColor, 0.5f, 3.0f);
        }
        throw new UnsupportedOperationException("No style method for " + clazz.getName());
    }

    public static Style createPolygonStyle(Color outlineColor, Color fillColor, float opacity) {
        Stroke stroke = sf.createStroke((Expression)ff.literal((Object)outlineColor), (Expression)ff.literal(1.0f));
        Fill fill = FillImpl.NULL;
        if (fillColor != null) {
            fill = sf.createFill((Expression)ff.literal((Object)fillColor), (Expression)ff.literal(opacity));
        }
        return SLD.wrapSymbolizers(new Symbolizer[]{sf.createPolygonSymbolizer(stroke, fill, null)});
    }

    public static Style createPolygonStyle(Color outlineColor, Color fillColor, float opacity, String labelField, Font labelFont) {
        Stroke stroke = sf.createStroke((Expression)ff.literal((Object)outlineColor), (Expression)ff.literal(1.0f));
        Fill fill = FillImpl.NULL;
        if (fillColor != null) {
            fill = sf.createFill((Expression)ff.literal((Object)fillColor), (Expression)ff.literal(opacity));
        }
        PolygonSymbolizer polySym = sf.createPolygonSymbolizer(stroke, fill, null);
        if (labelField == null) {
            return SLD.wrapSymbolizers(new Symbolizer[]{polySym});
        }
        Font font = labelFont == null ? sf.getDefaultFont() : labelFont;
        Fill labelFill = sf.createFill((Expression)ff.literal((Object)Color.BLACK));
        TextSymbolizer textSym = sf.createTextSymbolizer(labelFill, new Font[]{font}, null, (Expression)ff.property(labelField), null, null);
        return SLD.wrapSymbolizers(new Symbolizer[]{polySym, textSym});
    }

    public static Style createLineStyle(Color lineColor, float width) {
        Stroke stroke = sf.createStroke((Expression)ff.literal((Object)lineColor), (Expression)ff.literal(width));
        return SLD.wrapSymbolizers(new Symbolizer[]{sf.createLineSymbolizer(stroke, null)});
    }

    public static Style createLineStyle(Color lineColor, float width, String labelField, Font labelFont) {
        Stroke stroke = sf.createStroke((Expression)ff.literal((Object)lineColor), (Expression)ff.literal(width));
        LineSymbolizer lineSym = sf.createLineSymbolizer(stroke, null);
        if (labelField == null) {
            return SLD.wrapSymbolizers(new Symbolizer[]{lineSym});
        }
        Font font = labelFont == null ? sf.getDefaultFont() : labelFont;
        Fill labelFill = sf.createFill((Expression)ff.literal((Object)Color.BLACK));
        TextSymbolizer textSym = sf.createTextSymbolizer(labelFill, new Font[]{font}, null, (Expression)ff.property(labelField), null, null);
        return SLD.wrapSymbolizers(new Symbolizer[]{lineSym, textSym});
    }

    public static Style createPointStyle(String wellKnownName, Color lineColor, Color fillColor, float opacity, float size) {
        return SLD.createPointStyle(wellKnownName, lineColor, fillColor, opacity, size, null, null);
    }

    public static Style createPointStyle(String wellKnownName, Color lineColor, Color fillColor, float opacity, float size, String labelField, Font labelFont) {
        Stroke stroke = sf.createStroke((Expression)ff.literal((Object)lineColor), (Expression)ff.literal(1.0f));
        Fill fill = FillImpl.NULL;
        if (fillColor != null) {
            fill = sf.createFill((Expression)ff.literal((Object)fillColor), (Expression)ff.literal(opacity));
        }
        Mark mark = sf.createMark((Expression)ff.literal((Object)wellKnownName), stroke, fill, (Expression)ff.literal(size), (Expression)ff.literal(0));
        Graphic graphic = sf.createDefaultGraphic();
        graphic.graphicalSymbols().clear();
        graphic.graphicalSymbols().add(mark);
        graphic.setSize((Expression)ff.literal(size));
        PointSymbolizer pointSym = sf.createPointSymbolizer(graphic, null);
        if (labelField == null) {
            return SLD.wrapSymbolizers(new Symbolizer[]{pointSym});
        }
        Font font = labelFont == null ? sf.getDefaultFont() : labelFont;
        Fill labelFill = sf.createFill((Expression)ff.literal((Object)Color.BLACK));
        AnchorPoint anchor = sf.createAnchorPoint((Expression)ff.literal(0.5), (Expression)ff.literal(0.0));
        Displacement disp = sf.createDisplacement((Expression)ff.literal(0), (Expression)ff.literal(5));
        PointPlacement placement = sf.createPointPlacement(anchor, disp, (Expression)ff.literal(0));
        TextSymbolizer textSym = sf.createTextSymbolizer(labelFill, new Font[]{font}, null, (Expression)ff.property(labelField), (LabelPlacement)placement, null);
        return SLD.wrapSymbolizers(new Symbolizer[]{pointSym, textSym});
    }

    public static Style wrapSymbolizers(Symbolizer ... symbolizers) {
        if (symbolizers == null || symbolizers.length == 0) {
            return null;
        }
        Rule rule = sf.createRule();
        for (Symbolizer sym : symbolizers) {
            rule.symbolizers().add(sym);
        }
        FeatureTypeStyle fts = sf.createFeatureTypeStyle(new Rule[]{rule});
        Style style = sf.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }
}

