/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;

public class FeatureStyleScaleStyleVisitor
extends DuplicatingStyleVisitor {
    private static final Logger LOGGER = Logging.getLogger(FeatureStyleScaleStyleVisitor.class);
    private FeatureTypeStyle currentFeatureTypeStyle;
    private Double cachedMaxFromVendor;
    private Double cachedMinFromVendor;

    @Override
    public void visit(FeatureTypeStyle fts) {
        this.currentFeatureTypeStyle = fts;
        this.cachedMaxFromVendor = this.readScaleDenominator("maxScaleDenominator", Double.POSITIVE_INFINITY);
        this.cachedMinFromVendor = this.readScaleDenominator("minScaleDenominator", 0.0);
        super.visit(fts);
        this.currentFeatureTypeStyle = null;
        this.cachedMaxFromVendor = null;
        this.cachedMinFromVendor = null;
    }

    @Override
    public void visit(Rule rule) {
        super.visit(rule);
        Rule copy = (Rule)this.pages.peek();
        if (copy.getMaxScaleDenominator() == Double.POSITIVE_INFINITY) {
            copy.setMaxScaleDenominator(this.cachedMaxFromVendor.doubleValue());
        }
        if (copy.getMinScaleDenominator() == 0.0) {
            copy.setMinScaleDenominator(this.cachedMinFromVendor.doubleValue());
        }
    }

    private Double readScaleDenominator(String optionKey, double defaultValue) {
        if (this.currentFeatureTypeStyle == null) {
            return defaultValue;
        }
        String sdStr = (String)this.currentFeatureTypeStyle.getOptions().get(optionKey);
        if (sdStr == null) {
            return defaultValue;
        }
        if ((sdStr = sdStr.trim()).isEmpty()) {
            return defaultValue;
        }
        Double scaleDenominator = (Double)Converters.convert((Object)sdStr, Double.class);
        if (scaleDenominator != null) {
            return scaleDenominator;
        }
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "{0} option present but invalid in FeatureTypeStyle options: \"{1}\". Using default {2}.", new Object[]{optionKey, sdStr, defaultValue});
        }
        return defaultValue;
    }
}

