/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.measure.Units;
import org.geotools.util.Converters;
import si.uom.SI;
import systems.uom.common.USCustomary;

class Measure {
    static final FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    Expression expression;
    Double value;
    Unit<Length> uom;
    Unit<Length> defaultUnit;

    public Measure(String value, Unit<Length> defaultUnit) {
        this.setDefaultUnit(defaultUnit);
        this.processLiteralExpression(value, defaultUnit);
    }

    public Measure(Expression unscaled, Unit<Length> defaultUnit) {
        this.expression = unscaled;
        this.setDefaultUnit(defaultUnit);
        this.uom = defaultUnit;
        if (unscaled instanceof Literal) {
            Literal literal1 = (Literal)unscaled;
            this.processLiteralExpression(literal1, defaultUnit);
        } else {
            PropertyIsNull test = ff.isNull(unscaled);
            Filter simplified = (Filter)test.accept((FilterVisitor)new SimplifyingFilterVisitor(), null);
            if (simplified == Filter.INCLUDE) {
                this.expression = NilExpression.NIL;
                this.uom = defaultUnit;
            } else if (simplified instanceof PropertyIsNull) {
                PropertyIsNull pin = (PropertyIsNull)simplified;
                Expression se = pin.getExpression();
                if (se instanceof Literal) {
                    Literal literal = (Literal)se;
                    this.processLiteralExpression(literal, defaultUnit);
                } else {
                    this.expression = se;
                    this.uom = defaultUnit;
                }
            }
        }
    }

    private void setDefaultUnit(Unit<Length> defaultUnit) {
        this.defaultUnit = defaultUnit == null ? Units.PIXEL : defaultUnit;
    }

    private void processLiteralExpression(Literal literal, Unit<Length> defaultUnit) {
        String value = (String)literal.evaluate(null, String.class);
        if (value == null) {
            return;
        }
        this.processLiteralExpression(value, defaultUnit);
    }

    private void processLiteralExpression(String value, Unit<Length> defaultUnit) {
        Unit uom = defaultUnit;
        String unitless = value;
        if (value.endsWith("px")) {
            unitless = value.substring(0, value.length() - 2);
            uom = Units.PIXEL;
        } else if (value.endsWith("ft")) {
            unitless = value.substring(0, value.length() - 2);
            uom = USCustomary.FOOT;
        } else if (value.endsWith("m")) {
            unitless = value.substring(0, value.length() - 1);
            uom = SI.METRE;
        }
        Double measure = (Double)Converters.convert((Object)unitless, Double.class);
        if (measure == null) {
            throw new IllegalArgumentException("Invalid measure '" + value + "', was expecting a number, eventually followed by px, m or ft");
        }
        this.expression = ff.literal((Object)value);
        this.value = measure;
        this.uom = uom;
    }

    boolean isRealWorldUnit() {
        return this.uom != null && this.uom != Units.PIXEL;
    }

    boolean isPixelInPixelDefault() {
        return !(this.uom != null && this.uom != this.defaultUnit || this.defaultUnit != null && this.defaultUnit != Units.PIXEL);
    }

    public boolean isRealWorldUnitInPixelDefault() {
        return this.isRealWorldUnit() && (this.defaultUnit == null || this.defaultUnit == Units.PIXEL);
    }
}

