/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.zoom;

import org.geotools.api.style.Rule;

public class ScaleRange {
    final double minDenom;
    final double maxDenom;

    public ScaleRange(double minDenom, double maxDenom) {
        if (!(minDenom >= 0.0) || Double.isNaN(minDenom)) {
            throw new IllegalArgumentException("minDenom must be non-negative");
        }
        if (!(maxDenom >= 0.0) || Double.isNaN(minDenom)) {
            throw new IllegalArgumentException("maxDenom must be non-negative");
        }
        if (!(minDenom <= maxDenom)) {
            throw new IllegalArgumentException("maxDenom must be greater than or equal to minDenom");
        }
        this.minDenom = minDenom;
        this.maxDenom = maxDenom;
    }

    public void applyTo(Rule r) {
        r.setMaxScaleDenominator(this.maxDenom);
        r.setMinScaleDenominator(this.minDenom);
    }

    public boolean contains(double denom) {
        return this.minDenom <= denom && this.maxDenom > denom;
    }

    public String toString() {
        return "[1:%f, 1:%f)".formatted(this.minDenom, this.maxDenom);
    }

    public double getMinDenom() {
        return this.minDenom;
    }

    public double getMaxDenom() {
        return this.maxDenom;
    }
}

