/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.jiffleop;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.RasterFactory;
import org.eclipse.imagen.media.jiffle.Jiffle;
import org.eclipse.imagen.media.jiffle.JiffleException;
import org.eclipse.imagen.media.jiffle.runtime.BandTransform;
import org.eclipse.imagen.media.jiffle.runtime.CoordinateTransform;
import org.eclipse.imagen.media.jiffle.runtime.JiffleIndirectRuntime;
import org.eclipse.imagen.media.jiffle.runtime.JiffleRuntime;
import org.eclipse.imagen.media.jiffleop.JiffleOpImage;
import org.eclipse.imagen.media.range.NoDataContainer;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.utilities.ImageUtilities;

public class JiffleRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        String script = (String)paramBlock.getObjectParameter(2);
        String destVarName = (String)paramBlock.getObjectParameter(1);
        Rectangle destBounds = (Rectangle)paramBlock.getObjectParameter(3);
        int dataType = paramBlock.getIntParameter(4);
        Integer numBands = (Integer)paramBlock.getObjectParameter(7);
        Map<String, JiffleOpImage.ImageSpecification> sourceImages = this.buildSourceImageMap(paramBlock);
        if (destBounds == null) {
            destBounds = this.getSourceBounds(paramBlock);
        }
        JiffleIndirectRuntime runtime = this.getRuntime(script, sourceImages, destVarName, destBounds);
        if (numBands == null && (numBands = Integer.valueOf(runtime.getOutputBands())) == JiffleRuntime.DYNAMIC_BANDS) {
            throw new IllegalStateException("The destination bands parameter was not provided, but it was not possible to determine the number of output bands from the sources (band indexes are not static values)");
        }
        ImageLayout layout = this.buildLayout(destBounds, this.getPreferredTileSize(paramBlock), dataType, numBands);
        return new JiffleOpImage(sourceImages, layout, renderHints, runtime, destVarName);
    }

    private JiffleIndirectRuntime getRuntime(String script, Map<String, JiffleOpImage.ImageSpecification> sourceImages, String destVarName, Rectangle destBounds) {
        try {
            Jiffle jiffle = new Jiffle();
            jiffle.setScript(script);
            HashMap<String, Jiffle.ImageRole> imageParams = new HashMap<String, Jiffle.ImageRole>();
            for (String string : sourceImages.keySet()) {
                imageParams.put(string, Jiffle.ImageRole.SOURCE);
            }
            imageParams.put(destVarName, Jiffle.ImageRole.DEST);
            jiffle.setImageParams(imageParams);
            jiffle.compile();
            JiffleIndirectRuntime runtime = (JiffleIndirectRuntime)jiffle.getRuntimeInstance(Jiffle.RuntimeModel.INDIRECT);
            for (Map.Entry<String, JiffleOpImage.ImageSpecification> entry : sourceImages.entrySet()) {
                String name = entry.getKey();
                JiffleOpImage.ImageSpecification spec = entry.getValue();
                if (spec.nodata != null) {
                    RenderedImage image = spec.image;
                    boolean noDataMatch = false;
                    Object noDataProperty = image.getProperty("GC_NODATA");
                    if (noDataProperty instanceof NoDataContainer) {
                        NoDataContainer noData = (NoDataContainer)noDataProperty;
                        Range range = noData.getAsRange();
                        noDataMatch = Objects.equals(range, spec.nodata);
                    }
                    if (!noDataMatch) {
                        PlanarImage pi = PlanarImage.wrapRenderedImage((RenderedImage)image);
                        pi.setProperty("GC_NODATA", (Object)new NoDataContainer(spec.nodata));
                        image = pi;
                    }
                    runtime.setSourceImage(name, image, spec.coordinateTransform);
                } else {
                    runtime.setSourceImage(name, spec.image, spec.coordinateTransform);
                }
                if (spec.bandTransform == null) continue;
                runtime.setSourceImageBandTransform(name, spec.bandTransform);
            }
            Rectangle rectangle = new Rectangle(destBounds.x, destBounds.y, destBounds.width, destBounds.height);
            runtime.setWorldByResolution((Rectangle2D)rectangle, 1.0, 1.0);
            return runtime;
        }
        catch (JiffleException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Dimension getPreferredTileSize(ParameterBlock pb) {
        if (pb.getSources() == null || pb.getSources().size() == 0) {
            return ImageN.getDefaultTileSize();
        }
        RenderedImage ref = (RenderedImage)pb.getSource(0);
        return new Dimension(ref.getWidth(), ref.getHeight());
    }

    private Map<String, JiffleOpImage.ImageSpecification> buildSourceImageMap(ParameterBlock pb) {
        HashMap<String, JiffleOpImage.ImageSpecification> result = new HashMap<String, JiffleOpImage.ImageSpecification>();
        Vector<Object> sources = pb.getSources();
        String[] names = (String[])pb.getObjectParameter(0);
        CoordinateTransform[] cts = (CoordinateTransform[])pb.getObjectParameter(5);
        BandTransform[] bts = (BandTransform[])pb.getObjectParameter(6);
        Range[] nodata = (Range[])pb.getObjectParameter(8);
        if (sources == null || sources.size() == 0) {
            return result;
        }
        if (names == null) {
            for (int i = 0; i < sources.size(); ++i) {
                if (i == 0) {
                    result.put("src", this.getImageSpecification(sources, cts, bts, nodata, i));
                    continue;
                }
                result.put("src" + i, this.getImageSpecification(sources, cts, bts, nodata, i));
            }
        } else {
            if (names.length != sources.size()) {
                throw new IllegalArgumentException("Have " + sources.size() + " sources, but the source name argument contains " + names.length + " entries instead");
            }
            for (int i = 0; i < sources.size(); ++i) {
                result.put(names[i], this.getImageSpecification(sources, cts, bts, nodata, i));
            }
        }
        return result;
    }

    private JiffleOpImage.ImageSpecification getImageSpecification(Vector<Object> sources, CoordinateTransform[] cts, BandTransform[] bts, Range[] nodatas, int i) {
        RenderedImage image = (RenderedImage)sources.get(i);
        CoordinateTransform ct = null;
        if (cts != null) {
            if (cts.length != sources.size()) {
                throw new IllegalArgumentException(String.format("Have %d sources, but the coordinate transformation argument contains %d entries instead" + sources.size() + cts.length, new Object[0]));
            }
            ct = cts[i];
        }
        BandTransform bt = null;
        if (bts != null) {
            if (bts.length != sources.size()) {
                throw new IllegalArgumentException(String.format("Have %d sources, but the band transformation argument contains %d entries instead" + sources.size() + bts.length, new Object[0]));
            }
            bt = bts[i];
        }
        Range nodata = null;
        if (nodatas != null) {
            if (nodatas.length != sources.size()) {
                throw new IllegalArgumentException(String.format("Have %d sources, but the nodata argument contains %d entries instead" + sources.size() + nodatas.length, new Object[0]));
            }
            nodata = nodatas[i];
        }
        return new JiffleOpImage.ImageSpecification(image, ct, bt, nodata);
    }

    private ImageLayout buildLayout(Rectangle bounds, Dimension tileSize, int dataType, int numBands) {
        if (bounds == null) {
            throw new IllegalStateException("Cannot determine output image layout, dest bounds have not been provided");
        }
        ImageLayout layout = new ImageLayout(bounds.x, bounds.y, bounds.width, bounds.height);
        SampleModel sm = RasterFactory.createPixelInterleavedSampleModel((int)dataType, (int)tileSize.width, (int)tileSize.height, (int)numBands);
        layout.setSampleModel(sm);
        layout.setColorModel(ImageUtilities.getColorModel((SampleModel)sm, (boolean)false));
        return layout;
    }

    private Rectangle getSourceBounds(ParameterBlock pb) {
        Rectangle boundsUnion = null;
        if (pb.getNumSources() > 0) {
            boundsUnion = this.getSourceBounds(pb, 0);
            for (int i = 1; i < pb.getNumSources(); ++i) {
                Rectangle imageBounds = this.getSourceBounds(pb, i);
                boundsUnion = boundsUnion.union(imageBounds);
            }
        }
        return boundsUnion;
    }

    private Rectangle getSourceBounds(ParameterBlock pb, int imageIdx) {
        RenderedImage source = (RenderedImage)pb.getSource(imageIdx);
        return new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
    }
}

