/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.security.ConcurrentAuthenticationException;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.springframework.security.core.AuthenticationException;

public class GeoServerLoginPage
extends GeoServerBasePage {
    public GeoServerLoginPage(PageParameters parameters) {
        if (this.get("loginform") != null) {
            this.get("loginform").setVisible(false);
        }
        TextField field = new TextField("username");
        field.setModel((IModel)new Model());
        this.add(new Component[]{field});
        try {
            if (parameters.get("error").toBoolean()) {
                AuthenticationException exception = this.getAuthenticationException();
                if (exception instanceof ConcurrentAuthenticationException) {
                    ConcurrentAuthenticationException cae = (ConcurrentAuthenticationException)exception;
                    this.error((Serializable)((Object)new ParamResourceModel("concurrentAuthenticationError", (Component)this, cae.getCount()).getString()));
                } else {
                    this.error((Serializable)((Object)new ParamResourceModel("error", (Component)this, new Object[0]).getString()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private AuthenticationException getAuthenticationException() {
        Request request = this.getRequest();
        if (request == null || !(request.getContainerRequest() instanceof HttpServletRequest)) {
            return null;
        }
        HttpServletRequest hr = (HttpServletRequest)request.getContainerRequest();
        HttpSession session = hr.getSession(false);
        if (session == null) {
            return null;
        }
        Object exception = session.getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        if (exception instanceof AuthenticationException) {
            AuthenticationException authenticationException = (AuthenticationException)exception;
            return authenticationException;
        }
        return null;
    }
}

