/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.NumberTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.config.CoverageAccessInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.web.GeoserverAjaxSubmitLink;
import org.geoserver.web.admin.ServerAdminPage;
import org.geoserver.web.wicket.ParamResourceModel;

public class CoverageAccessPage
extends ServerAdminPage {
    private static final long serialVersionUID = -5028265196560034398L;
    private IModel<?> geoServerModel = this.getGeoServerModel();
    private IModel<CoverageAccessInfo> coverageModel = this.getCoverageAccessModel();

    public CoverageAccessPage() {
        Form form = new Form("form", (IModel)new CompoundPropertyModel(this.coverageModel));
        this.add(new Component[]{form});
        form.add((IFormValidator)new PoolSizeValidator());
        NumberTextField corePoolSize = new NumberTextField("corePoolSize", Integer.class);
        corePoolSize.setMinimum((Number)1);
        form.add(new Component[]{corePoolSize});
        NumberTextField maxPoolSize = new NumberTextField("maxPoolSize", Integer.class);
        maxPoolSize.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{maxPoolSize});
        NumberTextField keepAliveTime = new NumberTextField("keepAliveTime", Integer.class);
        keepAliveTime.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{keepAliveTime});
        DropDownChoice queueType = new DropDownChoice("queueType", Arrays.asList(CoverageAccessInfo.QueueType.values()), (IChoiceRenderer)new QueueTypeRenderer());
        form.add(new Component[]{queueType});
        TextField imageIOCacheThreshold = new TextField("imageIOCacheThreshold");
        imageIOCacheThreshold.add(new Behavior[]{RangeValidator.minimum((Comparable)Long.valueOf(0L))});
        form.add(new Component[]{imageIOCacheThreshold});
        Button submit = new Button("submit"){
            private static final long serialVersionUID = 4149741045073254811L;

            public void onSubmit() {
                CoverageAccessPage.this.save(true);
            }
        };
        form.add(new Component[]{submit});
        form.add(new Component[]{this.applyLink(form)});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = -57093747603810865L;

            public void onSubmit() {
                CoverageAccessPage.this.doReturn();
            }
        };
        form.add(new Component[]{cancel});
    }

    public void save(boolean doReturn) {
        GeoServer gs = (GeoServer)this.geoServerModel.getObject();
        GeoServerInfo global = gs.getGlobal();
        global.setCoverageAccess((CoverageAccessInfo)this.coverageModel.getObject());
        gs.save(global);
        if (doReturn) {
            this.doReturn();
        }
    }

    private GeoserverAjaxSubmitLink applyLink(Form form) {
        return new GeoserverAjaxSubmitLink("apply", form, this){

            @Override
            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{this.getForm()});
            }

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target) {
                try {
                    CoverageAccessPage.this.save(false);
                }
                catch (IllegalArgumentException e) {
                    this.getForm().error((Serializable)((Object)e.getMessage()));
                    target.add(new Component[]{this.getForm()});
                }
            }
        };
    }

    class PoolSizeValidator
    extends AbstractFormValidator {
        private static final long serialVersionUID = -3435198454570572665L;

        PoolSizeValidator() {
        }

        public FormComponent<?>[] getDependentFormComponents() {
            return null;
        }

        public void validate(Form<?> form) {
            if (!form.findSubmitter().getInputName().equals("submit")) {
                return;
            }
            TextField maxPoolField = (TextField)form.get("maxPoolSize");
            TextField corePoolField = (TextField)form.get("corePoolSize");
            if (maxPoolField != null && corePoolField != null) {
                String mp = maxPoolField.getValue();
                String cp = corePoolField.getValue();
                if (mp != null && cp != null && !mp.trim().isEmpty() && !cp.trim().isEmpty()) {
                    int corePool;
                    int maxPool;
                    try {
                        maxPool = Integer.valueOf(mp);
                    }
                    catch (NumberFormatException nfe) {
                        return;
                    }
                    try {
                        corePool = Integer.valueOf(cp);
                    }
                    catch (NumberFormatException nfe) {
                        return;
                    }
                    if (maxPool >= 1 && corePool >= 1 && maxPool < corePool) {
                        form.error((Serializable)((Object)new ParamResourceModel("poolSizeCheck", (Component)CoverageAccessPage.this.getPage(), new Object[0]).getString()));
                    }
                }
            }
        }
    }

    private class QueueTypeRenderer
    extends ChoiceRenderer<CoverageAccessInfo.QueueType> {
        private static final long serialVersionUID = -702911785346928083L;

        private QueueTypeRenderer() {
        }

        public String getDisplayValue(CoverageAccessInfo.QueueType type) {
            return new StringResourceModel(type.name(), (Component)CoverageAccessPage.this, null).getString();
        }

        public String getIdValue(CoverageAccessInfo.QueueType type, int index) {
            return type.name();
        }

        public CoverageAccessInfo.QueueType getObject(String id, IModel<? extends List<? extends CoverageAccessInfo.QueueType>> choices) {
            return CoverageAccessInfo.QueueType.valueOf((String)id);
        }
    }
}

