/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ImageProcessingInfo;
import org.geoserver.web.GeoserverAjaxSubmitLink;
import org.geoserver.web.admin.ServerAdminPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.PercentageTextField;

public class JAIPage
extends ServerAdminPage {
    private static final long serialVersionUID = -1184717232184497578L;
    private final IModel<GeoServer> geoServerModel = this.getGeoServerModel();
    private final IModel<ImageProcessingInfo> jaiModel = this.getJAIModel();

    public JAIPage() {
        Form form = new Form("form", (IModel)new CompoundPropertyModel(this.jaiModel));
        this.add(new Component[]{form});
        RangeValidator percentageValidator = RangeValidator.range((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0));
        PercentageTextField memoryCapacity = new PercentageTextField("memoryCapacity");
        memoryCapacity.add((IValidator)percentageValidator);
        form.add(new Component[]{memoryCapacity});
        PercentageTextField memoryThreshold = new PercentageTextField("memoryThreshold");
        memoryThreshold.add((IValidator)percentageValidator);
        form.add(new Component[]{memoryThreshold});
        TextField tileThreads = new TextField("tileThreads");
        tileThreads.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{tileThreads});
        TextField tilePriority = new TextField("tilePriority");
        tilePriority.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{tilePriority});
        form.add(new Component[]{new CheckBox("recycling")});
        this.addPngEncoderEditor((Form<ImageProcessingInfo>)form);
        Button submit = new Button("submit"){
            private static final long serialVersionUID = -2842881187264147131L;

            public void onSubmit() {
                JAIPage.this.save(true);
            }
        };
        form.add(new Component[]{submit});
        form.add(new Component[]{this.applyLink(form)});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 7917847596581898225L;

            public void onSubmit() {
                JAIPage.this.doReturn();
            }
        };
        form.add(new Component[]{cancel});
    }

    private void save(boolean doReturn) {
        GeoServer gs = (GeoServer)this.geoServerModel.getObject();
        GeoServerInfo global = gs.getGlobal();
        global.setImageProcessing((ImageProcessingInfo)this.jaiModel.getObject());
        gs.save(global);
        if (doReturn) {
            this.doReturn();
        }
    }

    private GeoserverAjaxSubmitLink applyLink(final Form form) {
        return new GeoserverAjaxSubmitLink("apply", form, this){

            @Override
            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{form});
            }

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target) {
                try {
                    JAIPage.this.save(false);
                }
                catch (IllegalArgumentException e) {
                    this.getForm().error((Serializable)((Object)e.getMessage()));
                    target.add(new Component[]{this.getForm()});
                }
            }
        };
    }

    private void addPngEncoderEditor(Form<ImageProcessingInfo> form) {
        ArrayList<ImageProcessingInfo.PngEncoderType> encoders = new ArrayList<ImageProcessingInfo.PngEncoderType>(Arrays.asList(ImageProcessingInfo.PngEncoderType.values()));
        DropDownChoice editor = new DropDownChoice("pngEncoderType", encoders, (IChoiceRenderer)new ChoiceRenderer<ImageProcessingInfo.PngEncoderType>(){
            private static final long serialVersionUID = 1L;

            public Object getDisplayValue(ImageProcessingInfo.PngEncoderType type) {
                return new ParamResourceModel("pngEncoder." + type.name(), (Component)JAIPage.this, new Object[0]).getString();
            }

            public String getIdValue(ImageProcessingInfo.PngEncoderType type, int index) {
                return type.name();
            }
        });
        form.add(new Component[]{editor});
        if (!encoders.contains(editor.getModelObject())) {
            editor.setModelObject((Object)ImageProcessingInfo.PngEncoderType.PNGJ);
        }
    }
}

