/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.Serializable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.CoverageAccessInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ImageProcessingInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.web.GeoServerSecuredPage;

public abstract class ServerAdminPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 4712657652337914993L;

    public IModel<GeoServer> getGeoServerModel() {
        return new LoadableDetachableModel<GeoServer>(){

            public GeoServer load() {
                return ServerAdminPage.this.getGeoServerApplication().getGeoServer();
            }
        };
    }

    public IModel<GeoServerInfo> getGlobalInfoModel() {
        return new Model((Serializable)this.getGeoServerApplication().getGeoServer().getGlobal());
    }

    public IModel<ImageProcessingInfo> getJAIModel() {
        ImageProcessingInfo currImageProcessingInfo = this.getGeoServerApplication().getGeoServer().getGlobal().getImageProcessing().clone();
        return new Model((Serializable)currImageProcessingInfo);
    }

    public IModel<CoverageAccessInfo> getCoverageAccessModel() {
        CoverageAccessInfo currCoverageAccessInfo = this.getGeoServerApplication().getGeoServer().getGlobal().getCoverageAccess().clone();
        return new Model((Serializable)currCoverageAccessInfo);
    }

    public IModel<ContactInfo> getContactInfoModel() {
        return new LoadableDetachableModel<ContactInfo>(){

            public ContactInfo load() {
                return ServerAdminPage.this.getGeoServerApplication().getGeoServer().getGlobal().getSettings().getContact();
            }
        };
    }

    public IModel<LoggingInfo> getLoggingInfoModel() {
        return new LoadableDetachableModel<LoggingInfo>(){

            protected LoggingInfo load() {
                return ServerAdminPage.this.getGeoServer().getLogging();
            }
        };
    }
}

