/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.EnumChoiceRenderer;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.eclipse.imagen.ImageLayout;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.JiffleParser;
import org.geoserver.web.GeoServerApplication;
import org.geotools.coverage.grid.io.GridCoverage2DReader;

public class CoverageViewEditor
extends FormComponentPanel<List<String>> {
    private static final List<CoverageView.CompositionType> SUPPORTED_MODES = Arrays.stream(CoverageView.CompositionType.values()).filter(v -> v != CoverageView.CompositionType.UNSUPPORTED).collect(Collectors.toList());
    IModel<List<String>> coverages;
    IModel<List<CoverageView.CoverageBand>> outputBands;
    IModel<String> referenceInputModel = new Model();
    IModel<List<String>> inputCoverageNamesModel = new ListModel(new ArrayList());
    List<String> availableCoverages;
    List<CoverageView.CoverageBand> currentOutputBands;
    ListMultipleChoice<String> coveragesChoice;
    IModel<CoverageView.CompositionType> compositionType;
    IModel<CoverageView.EnvelopeCompositionType> envelopeCompositionType;
    IModel<CoverageView.SelectedResolution> selectedResolution;
    IModel<String> resolutionReferenceCoverage;
    ListMultipleChoice<CoverageView.CoverageBand> outputBandsChoice;
    DropDownChoice<String> referenceInputChoice;
    Map<String, Integer> inputCoverageBands = new HashMap<String, Integer>();
    String storeId;
    WebMarkupContainer bandChoiceContainer;
    WebMarkupContainer jiffleEditorContainer;
    Label inputBandSummary;
    TextArea<String> jiffleFormulaArea;
    TextField<String> jiffleOutputNameField;
    IModel<String> jiffleFormulaModel = Model.of((Serializable)((Object)""));
    IModel<String> jiffleOutputNameModel = Model.of((Serializable)((Object)""));
    IModel<Boolean> fillMissingBands;

    public CoverageViewEditor(String id, IModel<List<String>> inputCoverages, IModel<List<CoverageView.CoverageBand>> bands, IModel<CoverageView.EnvelopeCompositionType> envelopeCompositionType, IModel<CoverageView.SelectedResolution> selectedResolution, IModel<String> resolutionReferenceCoverage, final IModel<CoverageView.CompositionType> compositionType, List<String> availableCoverages, String definition, String outputName, String storeId, IModel<Boolean> fillMissingBands) {
        super(id, inputCoverages);
        this.storeId = storeId;
        this.coverages = inputCoverages;
        this.outputBands = bands;
        this.envelopeCompositionType = envelopeCompositionType;
        this.selectedResolution = selectedResolution;
        this.compositionType = compositionType;
        this.resolutionReferenceCoverage = resolutionReferenceCoverage;
        this.availableCoverages = availableCoverages;
        this.fillMissingBands = fillMissingBands;
        this.coveragesChoice = new ListMultipleChoice("coveragesChoice", (IModel)new Model(), new ArrayList((Collection)this.coverages.getObject()), (IChoiceRenderer)new ChoiceRenderer<String>(){

            public Object getDisplayValue(String coverage) {
                return coverage;
            }
        });
        this.coveragesChoice.setOutputMarkupId(true);
        new ArrayList();
        this.outputBandsChoice = new ListMultipleChoice("outputBandsChoice", (IModel)new Model(), new ArrayList((Collection)this.outputBands.getObject()), (IChoiceRenderer)new ChoiceRenderer<CoverageView.CoverageBand>(){

            public Object getDisplayValue(CoverageView.CoverageBand vcb) {
                return vcb.getDefinition();
            }
        });
        this.outputBandsChoice.setOutputMarkupId(true);
        this.currentOutputBands = new ArrayList<CoverageView.CoverageBand>(this.outputBandsChoice.getChoices());
        if (this.currentOutputBands != null && !this.currentOutputBands.isEmpty() && compositionType.getObject() == CoverageView.CompositionType.JIFFLE) {
            this.referenceInputModel.setObject((Object)((CoverageView.InputCoverageBand)this.currentOutputBands.get(0).getInputCoverageBands().get(0)).getCoverageName());
        }
        DropDownChoice compositionModeChoice = new DropDownChoice("compositionMode", SUPPORTED_MODES);
        compositionModeChoice.setModel(compositionType);
        compositionModeChoice.setChoiceRenderer((IChoiceRenderer)new EnumChoiceRenderer((Component)this));
        compositionModeChoice.setOutputMarkupId(true);
        compositionModeChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                CoverageView.CompositionType selectedMode = (CoverageView.CompositionType)compositionType.getObject();
                CoverageViewEditor.this.bandChoiceContainer.setVisible(selectedMode == CoverageView.CompositionType.BAND_SELECT);
                CoverageViewEditor.this.jiffleEditorContainer.setVisible(selectedMode == CoverageView.CompositionType.JIFFLE);
                if (selectedMode == CoverageView.CompositionType.JIFFLE) {
                    CoverageViewEditor.this.inputBandSummary.modelChanged();
                    target.add(new Component[]{CoverageViewEditor.this.inputBandSummary});
                    target.add(new Component[]{CoverageViewEditor.this.referenceInputChoice});
                    CoverageViewEditor.this.inputCoverageNamesModel.setObject(new ArrayList<String>(CoverageViewEditor.this.inputCoverageBands.keySet()));
                } else {
                    CoverageViewEditor.this.currentOutputBands.clear();
                    CoverageViewEditor.this.outputBandsChoice.setChoices(CoverageViewEditor.this.currentOutputBands);
                    CoverageViewEditor.this.outputBandsChoice.modelChanged();
                }
                target.add(new Component[]{CoverageViewEditor.this.bandChoiceContainer});
                target.add(new Component[]{CoverageViewEditor.this.jiffleEditorContainer});
            }
        }});
        this.add(new Component[]{compositionModeChoice});
        this.bandChoiceContainer = new WebMarkupContainer("bandChoiceContainer");
        this.bandChoiceContainer.setOutputMarkupId(true);
        this.bandChoiceContainer.add(new Component[]{this.coveragesChoice});
        this.bandChoiceContainer.add(new Component[]{this.outputBandsChoice});
        this.bandChoiceContainer.add(new Component[]{this.addBandButton()});
        this.bandChoiceContainer.add(new Component[]{this.addRemoveButton()});
        this.bandChoiceContainer.add(new Component[]{this.addRemoveAllButton()});
        this.add(new Component[]{this.bandChoiceContainer});
        this.jiffleEditorContainer = new WebMarkupContainer("jiffleEditorContainer");
        this.inputBandSummary = new Label("inputBandSummary", (IModel)new LoadableDetachableModel<String>(){

            protected String load() {
                try {
                    return CoverageViewEditor.this.generateBandSummary();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.inputBandSummary.setOutputMarkupId(true);
        this.jiffleEditorContainer.add(new Component[]{this.inputBandSummary});
        this.jiffleFormulaArea = new TextArea("jiffleFormula", this.jiffleFormulaModel);
        this.jiffleFormulaArea.setOutputMarkupId(true);
        this.jiffleOutputNameField = new TextField("jiffleOutputName", this.jiffleOutputNameModel);
        this.jiffleOutputNameField.setOutputMarkupId(true);
        this.jiffleEditorContainer.add(new Component[]{this.jiffleOutputNameField});
        this.jiffleEditorContainer.add(new Component[]{this.jiffleFormulaArea});
        this.jiffleEditorContainer.setOutputMarkupId(true);
        this.referenceInputChoice = new DropDownChoice("referenceInput", this.referenceInputModel, this.inputCoverageNamesModel);
        this.referenceInputChoice.setNullValid(false);
        this.referenceInputChoice.setOutputMarkupId(true);
        this.jiffleEditorContainer.add(new Component[]{this.referenceInputChoice});
        this.add(new Component[]{this.jiffleEditorContainer});
        this.bandChoiceContainer.setOutputMarkupPlaceholderTag(true);
        this.jiffleEditorContainer.setOutputMarkupPlaceholderTag(true);
        CoverageView.CompositionType selected = (CoverageView.CompositionType)compositionType.getObject();
        boolean isJiffle = selected == CoverageView.CompositionType.JIFFLE;
        this.bandChoiceContainer.setVisible(!isJiffle);
        this.jiffleEditorContainer.setVisible(isJiffle);
        if (isJiffle) {
            this.jiffleFormulaModel.setObject((Object)definition);
            this.jiffleOutputNameModel.setObject((Object)outputName);
        }
        CheckBox checkBox = new CheckBox("fillMissingBands", fillMissingBands);
        this.add(new Component[]{checkBox});
        WebMarkupContainer heterogeneousControlsContainer = new WebMarkupContainer("heterogeneousControlsContainer");
        heterogeneousControlsContainer.setOutputMarkupId(true);
        this.add(new Component[]{heterogeneousControlsContainer});
        WebMarkupContainer heterogeneousControls = new WebMarkupContainer("heterogeneousControls");
        heterogeneousControlsContainer.add(new Component[]{heterogeneousControls});
        DropDownChoice envelopePolicy = new DropDownChoice("envelopeCompositionType", Arrays.asList(CoverageView.EnvelopeCompositionType.values()));
        envelopePolicy.setModel(envelopeCompositionType);
        envelopePolicy.setChoiceRenderer((IChoiceRenderer)new EnumChoiceRenderer((Component)this));
        heterogeneousControls.add(new Component[]{envelopePolicy});
        DropDownChoice resolutionPolicy = new DropDownChoice("selectedResolution", Arrays.asList(CoverageView.SelectedResolution.values()));
        resolutionPolicy.setModel(selectedResolution);
        resolutionPolicy.setChoiceRenderer((IChoiceRenderer)new EnumChoiceRenderer((Component)this));
        heterogeneousControls.add(new Component[]{resolutionPolicy});
    }

    public String validateAndSave() throws IllegalArgumentException {
        String error = null;
        if (this.compositionType.getObject() == CoverageView.CompositionType.JIFFLE) {
            error = this.parseAndSetOutput();
            this.outputBandsChoice.setChoices(this.currentOutputBands);
            this.outputBandsChoice.modelChanged();
        }
        return error;
    }

    private AjaxButton addBandButton() {
        AjaxButton button = new AjaxButton("addBand"){

            public void onSubmit(AjaxRequestTarget target) {
                List selection = (List)CoverageViewEditor.this.coveragesChoice.getModelObject();
                ArrayList<CoverageView.CoverageBand> bandsList = new ArrayList<CoverageView.CoverageBand>();
                int i = CoverageViewEditor.this.currentOutputBands.size();
                for (String coverage : selection) {
                    int bandIndexChar = coverage.indexOf("@");
                    String coverageName = coverage;
                    String bandIndex = null;
                    if (bandIndexChar != -1) {
                        coverageName = coverage.substring(0, bandIndexChar);
                        bandIndex = coverage.substring(bandIndexChar + 1);
                    }
                    CoverageView.CoverageBand band = new CoverageView.CoverageBand(Collections.singletonList(new CoverageView.InputCoverageBand(coverageName, bandIndex)), coverage, i++, CoverageView.CompositionType.BAND_SELECT);
                    bandsList.add(band);
                }
                CoverageViewEditor.this.currentOutputBands.addAll(bandsList);
                CoverageViewEditor.this.outputBandsChoice.setChoices(CoverageViewEditor.this.currentOutputBands);
                CoverageViewEditor.this.outputBandsChoice.modelChanged();
                CoverageViewEditor.this.coveragesChoice.setChoices(CoverageViewEditor.this.availableCoverages);
                CoverageViewEditor.this.coveragesChoice.modelChanged();
                target.add(new Component[]{CoverageViewEditor.this.coveragesChoice});
                target.add(new Component[]{CoverageViewEditor.this.outputBandsChoice});
            }
        };
        return button;
    }

    private AjaxButton addRemoveAllButton() {
        AjaxButton button = new AjaxButton("removeAllBands"){

            public void onSubmit(AjaxRequestTarget target) {
                List outputBands = (List)CoverageViewEditor.this.outputBandsChoice.getModelObject();
                outputBands.clear();
                CoverageViewEditor.this.currentOutputBands.clear();
                CoverageViewEditor.this.outputBandsChoice.setChoices(CoverageViewEditor.this.currentOutputBands);
                CoverageViewEditor.this.outputBandsChoice.modelChanged();
                target.add(new Component[]{CoverageViewEditor.this.outputBandsChoice});
            }
        };
        return button;
    }

    private AjaxButton addRemoveButton() {
        AjaxButton button = new AjaxButton("removeBands"){

            public void onSubmit(AjaxRequestTarget target) {
                List removedBands = (List)CoverageViewEditor.this.outputBandsChoice.getModel().getObject();
                for (Object band : removedBands) {
                    CoverageViewEditor.this.currentOutputBands.remove(band);
                }
                CoverageViewEditor.this.outputBandsChoice.setChoices(CoverageViewEditor.this.currentOutputBands);
                CoverageViewEditor.this.outputBandsChoice.modelChanged();
                target.add(new Component[]{CoverageViewEditor.this.outputBandsChoice});
            }
        };
        return button;
    }

    private String parseAndSetOutput() throws IllegalArgumentException {
        String outputVar = (String)this.jiffleOutputNameModel.getObject();
        if (outputVar == null || outputVar.isBlank()) {
            return "Output Name is required";
        }
        String formulaText = (String)this.jiffleFormulaModel.getObject();
        if (formulaText == null || formulaText.isBlank()) {
            return "Formula is required in Jiffle Script section";
        }
        JiffleParser.JiffleParsingResult parsed = JiffleParser.parse((String)outputVar, (String)formulaText, this.availableCoverages);
        if (parsed.outputVar == null) {
            return parsed.error;
        }
        String selectedBand = (String)this.referenceInputModel.getObject();
        if (StringUtils.isBlank((String)selectedBand)) {
            return "Reference Band is required";
        }
        Set inputBands = parsed.inputBands;
        int referenceInputMatching = -1;
        ArrayList<CoverageView.InputCoverageBand> icbs = new ArrayList<CoverageView.InputCoverageBand>();
        int j = 0;
        for (CoverageView.InputCoverageBand input : inputBands) {
            icbs.add(input);
            if (input.getCoverageName().equals(selectedBand)) {
                referenceInputMatching = j;
            }
            ++j;
        }
        if (referenceInputMatching < 0) {
            return "The selected reference input is not referenced in the formula. Please select a band that is used in the expressions.";
        }
        if (referenceInputMatching > 0 && referenceInputMatching < icbs.size()) {
            CoverageView.InputCoverageBand element = (CoverageView.InputCoverageBand)icbs.remove(referenceInputMatching);
            icbs.add(0, element);
        }
        ArrayList<CoverageView.CoverageBand> newBands = new ArrayList<CoverageView.CoverageBand>();
        for (int i = 0; i < parsed.numBands; ++i) {
            Object outputBand = parsed.outputVar;
            if (parsed.numBands > 1) {
                outputBand = (String)outputBand + "@" + i;
            }
            CoverageView.CoverageBand band = new CoverageView.CoverageBand(icbs, (String)outputBand, 0, CoverageView.CompositionType.JIFFLE);
            newBands.add(band);
        }
        this.currentOutputBands.clear();
        this.currentOutputBands.addAll(newBands);
        this.outputBands.setObject(newBands);
        return null;
    }

    private String generateBandSummary() throws IOException {
        String[] coverageNames;
        StringBuilder sb = new StringBuilder();
        Catalog catalog = GeoServerApplication.get().getCatalog();
        ArrayList<String> bands = new ArrayList<String>();
        this.inputCoverageBands.clear();
        CoverageStoreInfo store = (CoverageStoreInfo)catalog.getStore(this.storeId, CoverageStoreInfo.class);
        GridCoverage2DReader reader = (GridCoverage2DReader)catalog.getResourcePool().getGridCoverageReader(store, null);
        for (String coverage : coverageNames = reader.getGridCoverageNames()) {
            ImageLayout layout = reader.getImageLayout(coverage);
            SampleModel sampleModel = layout.getSampleModel(null);
            int numBands = sampleModel.getNumBands();
            this.inputCoverageBands.put(coverage, numBands);
            String coverageBand = "%s (%d band, %s)".formatted(coverage, numBands, CoverageViewEditor.getDataTypeName(sampleModel.getDataType()));
            bands.add(coverageBand);
            this.inputCoverageNamesModel.setObject(new ArrayList<String>(this.inputCoverageBands.keySet()));
        }
        sb.append(String.join((CharSequence)"\n", bands)).append("\n");
        return sb.toString();
    }

    private static String getDataTypeName(int dataType) {
        switch (dataType) {
            case 0: {
                return "Byte";
            }
            case 2: {
                return "Int16";
            }
            case 1: {
                return "UInt16";
            }
            case 3: {
                return "Int32";
            }
            case 4: {
                return "Float32";
            }
            case 5: {
                return "Float64";
            }
        }
        return "Unknown";
    }
}

