/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.layer.LayerDetachableModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;

public class LayerProvider
extends GeoServerDataProvider<LayerInfo> {
    static final GeoServerDataProvider.Property<LayerInfo> TYPE = new GeoServerDataProvider.BeanProperty<LayerInfo>("type", "type");
    static final GeoServerDataProvider.Property<LayerInfo> STORE = new GeoServerDataProvider.BeanProperty<LayerInfo>("store", "resource.store.name");
    static final GeoServerDataProvider.Property<LayerInfo> NAME = new GeoServerDataProvider.BeanProperty<LayerInfo>("name", "name");
    static final GeoServerDataProvider.Property<LayerInfo> TITLE = new GeoServerDataProvider.BeanProperty<LayerInfo>("title", "title");
    static final GeoServerDataProvider.Property<LayerInfo> MODIFIED_TIMESTAMP = new GeoServerDataProvider.BeanProperty<LayerInfo>("datemodfied", "dateModified");
    static final GeoServerDataProvider.Property<LayerInfo> CREATED_TIMESTAMP = new GeoServerDataProvider.BeanProperty<LayerInfo>("datecreated", "dateCreated");
    static final GeoServerDataProvider.Property<LayerInfo> MODIFIED_BY = new GeoServerDataProvider.BeanProperty<LayerInfo>("modifiedby", "modifiedBy");
    static final GeoServerDataProvider.Property<LayerInfo> ENABLED = new GeoServerDataProvider.AbstractProperty<LayerInfo>("enabled"){

        public Boolean getPropertyValue(LayerInfo item) {
            return item.enabled();
        }
    };
    static final GeoServerDataProvider.Property<LayerInfo> SRS = new GeoServerDataProvider.BeanProperty<LayerInfo>("SRS", "resource.SRS"){

        @Override
        public Comparator<LayerInfo> getComparator() {
            return (o1, o2) -> {
                String[] srs2;
                String[] srs1 = o1.getResource().getSRS().split(":");
                if (srs1[0].equalsIgnoreCase((srs2 = o2.getResource().getSRS().split(":"))[0]) && srs1.length > 1 && srs2.length > 1) {
                    try {
                        return Integer.valueOf(srs1[1]).compareTo(Integer.valueOf(srs2[1]));
                    }
                    catch (NumberFormatException e) {
                        return srs1[1].compareTo(srs2[1]);
                    }
                }
                return srs1[0].compareToIgnoreCase(srs2[0]);
            };
        }
    };
    static final List<GeoServerDataProvider.Property<LayerInfo>> PROPERTIES = Arrays.asList(TYPE, TITLE, NAME, STORE, ENABLED, SRS);

    @Override
    protected List<LayerInfo> getItems() {
        throw new UnsupportedOperationException("This method should not be being called! We use the catalog streaming API");
    }

    @Override
    protected List<GeoServerDataProvider.Property<LayerInfo>> getProperties() {
        String trackUser;
        ArrayList<GeoServerDataProvider.Property<LayerInfo>> modifiedPropertiesList = new ArrayList<GeoServerDataProvider.Property<LayerInfo>>(PROPERTIES);
        if (GeoServerApplication.get().getGeoServer().getSettings().isShowCreatedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(CREATED_TIMESTAMP);
        }
        if (GeoServerApplication.get().getGeoServer().getSettings().isShowModifiedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(MODIFIED_TIMESTAMP);
        }
        if ((trackUser = GeoServerExtensions.getProperty((String)"TRACK_USER")) == null && GeoServerApplication.get().getGeoServer().getSettings().isShowModifiedUserInAdminList() || Boolean.parseBoolean(trackUser)) {
            modifiedPropertiesList.add(MODIFIED_BY);
        }
        return modifiedPropertiesList;
    }

    @Override
    public IModel<LayerInfo> newModel(LayerInfo object) {
        return new LayerDetachableModel(object);
    }

    @Override
    protected Comparator<LayerInfo> getComparator(SortParam<?> sort) {
        return super.getComparator(sort);
    }

    @Override
    public long size() {
        Filter filter = this.getFilter();
        int count = this.getCatalog().count(LayerInfo.class, filter);
        return count;
    }

    @Override
    public int fullSize() {
        Filter filter = Predicates.acceptAll();
        int count = this.getCatalog().count(LayerInfo.class, filter);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<LayerInfo> iterator(long first, long count) {
        Iterator<LayerInfo> iterator = this.filteredItems(first, count);
        if (iterator instanceof CloseableIterator) {
            try {
                Iterator<LayerInfo> iterator2 = Lists.newArrayList(iterator).iterator();
                return iterator2;
            }
            finally {
                CloseableIteratorAdapter.close(iterator);
            }
        }
        return iterator;
    }

    private Iterator<LayerInfo> filteredItems(Long first, Long count) {
        Catalog catalog = this.getCatalog();
        SortParam sort = this.getSort();
        GeoServerDataProvider.Property property = this.getProperty(sort);
        SortBy sortOrder = null;
        if (sort != null) {
            if (property instanceof GeoServerDataProvider.BeanProperty) {
                String sortProperty = ((GeoServerDataProvider.BeanProperty)property).getPropertyPath();
                sortOrder = Predicates.sortBy((String)sortProperty, (boolean)sort.isAscending());
            } else if (property == ENABLED) {
                sortOrder = Predicates.sortBy((String)"enabled", (boolean)sort.isAscending());
            }
        }
        if (first > Integer.MAX_VALUE || first < Integer.MIN_VALUE || count > Integer.MAX_VALUE || count < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        Filter filter = this.getFilter();
        CloseableIterator items = catalog.list(LayerInfo.class, filter, Integer.valueOf(first.intValue()), Integer.valueOf(count.intValue()), sortOrder);
        return items;
    }
}

