/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.importer.WMSLayerImporterPage;
import org.geoserver.web.data.importer.WMTSLayerImporterPage;
import org.geoserver.web.data.layer.CascadedWFSStoredQueryNewPage;
import org.geoserver.web.data.layer.CoverageViewNewPage;
import org.geoserver.web.data.layer.NewFeatureTypePage;
import org.geoserver.web.data.layer.NewLayerPageProvider;
import org.geoserver.web.data.layer.Resource;
import org.geoserver.web.data.layer.SQLViewNewPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.data.store.StoreListChoiceRenderer;
import org.geoserver.web.data.store.StoreListModel;
import org.geoserver.web.wicket.CachingImage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.Select2DropDownChoice;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.util.decorate.Wrapper;

public class NewLayerPage
extends GeoServerSecuredPage {
    String storeId;
    private NewLayerPageProvider provider;
    private GeoServerTablePanel<Resource> layers;
    private WebMarkupContainer selectLayersContainer;
    private WebMarkupContainer selectLayers;
    private Label storeName;
    private WebMarkupContainer createTypeContainer;
    private WebMarkupContainer createSQLViewContainer;
    private WebMarkupContainer createCoverageViewContainer;
    private WebMarkupContainer createCascadedWFSStoredQueryContainer;
    private WebMarkupContainer createWMSLayerImportContainer;
    private WebMarkupContainer createWMTSLayerImportContainer;

    public NewLayerPage() {
        this((String)null);
    }

    public NewLayerPage(String storeId) {
        StoreInfo store;
        this.storeId = storeId;
        Form selector = new Form("selector");
        selector.add(new Component[]{this.storesDropDown()});
        selector.setVisible(storeId == null);
        this.add(new Component[]{selector});
        this.selectLayersContainer = new WebMarkupContainer("selectLayersContainer");
        this.selectLayersContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.selectLayersContainer});
        this.selectLayers = new WebMarkupContainer("selectLayers");
        this.selectLayers.setVisible(storeId != null);
        this.selectLayersContainer.add(new Component[]{this.selectLayers});
        Component[] componentArray = new Component[1];
        this.storeName = new Label("storeName", (IModel)new Model());
        componentArray[0] = this.storeName;
        this.selectLayers.add(componentArray);
        if (storeId != null) {
            store = this.getCatalog().getStore(storeId, StoreInfo.class);
            this.storeName.setDefaultModelObject((Object)store.getName());
        }
        this.provider = new NewLayerPageProvider();
        this.provider.setStoreId(storeId);
        this.provider.setShowPublished(true);
        this.layers = new GeoServerTablePanel<Resource>("layers", (GeoServerDataProvider)this.provider){

            @Override
            protected Component getComponentForProperty(String id, IModel<Resource> itemModel, GeoServerDataProvider.Property<Resource> property) {
                if (property == NewLayerPageProvider.NAME) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property == NewLayerPageProvider.PUBLISHED) {
                    Resource resource = (Resource)itemModel.getObject();
                    CatalogIconFactory icons = CatalogIconFactory.get();
                    if (resource.isPublished()) {
                        PackageResourceReference icon = icons.getEnabledIcon();
                        Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)NewLayerPage.this.selectLayers);
                        f.add(new Component[]{new CachingImage("layerIcon", (ResourceReference)icon, new ResourceReference[0])});
                        return f;
                    }
                    return new Label(id);
                }
                if (property == NewLayerPageProvider.ACTION) {
                    Resource resource = (Resource)itemModel.getObject();
                    if (resource.isPublished()) {
                        return NewLayerPage.this.resourceChooserLink(id, itemModel, (IModel<String>)new ParamResourceModel("publishAgain", (Component)this, new Object[0]));
                    }
                    return NewLayerPage.this.resourceChooserLink(id, itemModel, (IModel<String>)new ParamResourceModel("publish", (Component)this, new Object[0]));
                }
                throw new IllegalArgumentException("Don't know of property " + property.getName());
            }
        };
        this.layers.setFilterVisible(true);
        this.selectLayers.add(new Component[]{this.layers});
        this.createTypeContainer = new WebMarkupContainer("createTypeContainer");
        this.createTypeContainer.setVisible(false);
        this.createTypeContainer.add(new Component[]{this.newFeatureTypeLink()});
        this.selectLayersContainer.add(new Component[]{this.createTypeContainer});
        this.createSQLViewContainer = new WebMarkupContainer("createSQLViewContainer");
        this.createSQLViewContainer.setVisible(false);
        this.createSQLViewContainer.add(new Component[]{this.newSQLViewLink()});
        this.selectLayersContainer.add(new Component[]{this.createSQLViewContainer});
        this.createCoverageViewContainer = new WebMarkupContainer("createCoverageViewContainer");
        this.createCoverageViewContainer.setVisible(false);
        this.createCoverageViewContainer.add(new Component[]{this.newCoverageViewLink()});
        this.selectLayersContainer.add(new Component[]{this.createCoverageViewContainer});
        this.createCascadedWFSStoredQueryContainer = new WebMarkupContainer("createCascadedWFSStoredQueryContainer");
        this.createCascadedWFSStoredQueryContainer.setVisible(false);
        this.createCascadedWFSStoredQueryContainer.add(new Component[]{this.newCascadedWFSStoredQueryLink()});
        this.selectLayersContainer.add(new Component[]{this.createCascadedWFSStoredQueryContainer});
        this.createWMSLayerImportContainer = new WebMarkupContainer("createWMSLayerImportContainer");
        this.createWMSLayerImportContainer.setVisible(false);
        this.createWMSLayerImportContainer.add(new Component[]{this.newWMSImportLink()});
        this.selectLayersContainer.add(new Component[]{this.createWMSLayerImportContainer});
        this.createWMTSLayerImportContainer = new WebMarkupContainer("createWMTSLayerImportContainer");
        this.createWMTSLayerImportContainer.setVisible(false);
        this.createWMTSLayerImportContainer.add(new Component[]{this.newWMTSImportLink()});
        this.selectLayersContainer.add(new Component[]{this.createWMTSLayerImportContainer});
        if (storeId != null) {
            store = this.getCatalog().getStore(storeId, StoreInfo.class);
            this.updateSpecialFunctionPanels(store);
        }
    }

    Component newFeatureTypeLink() {
        return new AjaxLink<Void>("createFeatureType"){

            public void onClick(AjaxRequestTarget target) {
                DataStoreInfo ds = (DataStoreInfo)NewLayerPage.this.getCatalog().getStore(NewLayerPage.this.storeId, DataStoreInfo.class);
                PageParameters pp = new PageParameters().add("wsName", (Object)ds.getWorkspace().getName()).add("storeName", (Object)ds.getName());
                this.setResponsePage(NewFeatureTypePage.class, pp);
            }
        };
    }

    Component newSQLViewLink() {
        return new AjaxLink<Void>("createSQLView"){

            public void onClick(AjaxRequestTarget target) {
                DataStoreInfo ds = (DataStoreInfo)NewLayerPage.this.getCatalog().getStore(NewLayerPage.this.storeId, DataStoreInfo.class);
                PageParameters pp = new PageParameters().add("wsName", (Object)ds.getWorkspace().getName()).add("storeName", (Object)ds.getName());
                this.setResponsePage(SQLViewNewPage.class, pp);
            }
        };
    }

    Component newCoverageViewLink() {
        return new AjaxLink<Void>("createCoverageView"){

            public void onClick(AjaxRequestTarget target) {
                CoverageStoreInfo cs = (CoverageStoreInfo)NewLayerPage.this.getCatalog().getStore(NewLayerPage.this.storeId, CoverageStoreInfo.class);
                PageParameters pp = new PageParameters().add("wsName", (Object)cs.getWorkspace().getName()).add("storeName", (Object)cs.getName());
                this.setResponsePage(CoverageViewNewPage.class, pp);
            }
        };
    }

    Component newCascadedWFSStoredQueryLink() {
        return new AjaxLink<Void>("createCascadedWFSStoredQuery"){

            public void onClick(AjaxRequestTarget target) {
                DataStoreInfo ds = (DataStoreInfo)NewLayerPage.this.getCatalog().getStore(NewLayerPage.this.storeId, DataStoreInfo.class);
                PageParameters pp = new PageParameters().add("wsName", (Object)ds.getWorkspace().getName()).add("storeName", (Object)ds.getName());
                this.setResponsePage(CascadedWFSStoredQueryNewPage.class, pp);
            }
        };
    }

    Component newWMSImportLink() {
        return new AjaxLink<Void>("createWMSImport"){

            public void onClick(AjaxRequestTarget target) {
                PageParameters pp = new PageParameters().add("storeId", (Object)NewLayerPage.this.storeId);
                this.setResponsePage(WMSLayerImporterPage.class, pp);
            }
        };
    }

    Component newWMTSImportLink() {
        return new AjaxLink<Void>("createWMTSImport"){

            public void onClick(AjaxRequestTarget target) {
                PageParameters pp = new PageParameters().add("storeId", (Object)NewLayerPage.this.storeId);
                this.setResponsePage(WMTSLayerImporterPage.class, pp);
            }
        };
    }

    private Select2DropDownChoice<StoreInfo> storesDropDown() {
        final Select2DropDownChoice<StoreInfo> stores = new Select2DropDownChoice<StoreInfo>("storesDropDown", (IModel<StoreInfo>)new Model(), (IModel<List<StoreInfo>>)new StoreListModel(), (IChoiceRenderer<StoreInfo>)new StoreListChoiceRenderer());
        stores.setOutputMarkupId(true);
        stores.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                if (stores.getModelObject() != null) {
                    StoreInfo store = (StoreInfo)stores.getModelObject();
                    NewLayerPage.this.storeId = store.getId();
                    NewLayerPage.this.provider.setStoreId(store.getId());
                    NewLayerPage.this.storeName.setDefaultModelObject((Object)store.getName());
                    NewLayerPage.this.selectLayers.setVisible(true);
                    try {
                        NewLayerPage.this.provider.getItems();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Error retrieving layers for the specified store", e);
                        NewLayerPage.this.error((Serializable)((Object)e.getMessage()));
                        NewLayerPage.this.selectLayers.setVisible(false);
                    }
                    NewLayerPage.this.updateSpecialFunctionPanels(store);
                } else {
                    NewLayerPage.this.selectLayers.setVisible(false);
                    NewLayerPage.this.createTypeContainer.setVisible(false);
                }
                target.add(new Component[]{NewLayerPage.this.selectLayersContainer});
                NewLayerPage.this.addFeedbackPanels(target);
            }
        }});
        return stores;
    }

    SimpleAjaxLink<Resource> resourceChooserLink(String id, IModel<Resource> itemModel, IModel<String> label) {
        return new SimpleAjaxLink<Resource>(id, itemModel, label){

            @Override
            protected void onClick(AjaxRequestTarget target) {
                Resource resource = (Resource)this.getDefaultModelObject();
                this.setResponsePage((IRequestablePage)new ResourceConfigurationPage(NewLayerPage.this.buildLayerInfo(resource), true));
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    void updateSpecialFunctionPanels(StoreInfo store) {
        try {
            if (!(store instanceof DataStoreInfo)) ** GOTO lbl-1000
            dsi = (DataStoreInfo)store;
            if (((DataStoreInfo)store).getDataStore(null) instanceof DataStore) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            this.createTypeContainer.setVisible(v0);
        }
        catch (IOException e) {
            NewLayerPage.LOGGER.log(Level.FINEST, e.getMessage());
        }
        this.createSQLViewContainer.setVisible(false);
        this.createCascadedWFSStoredQueryContainer.setVisible(false);
        if (store instanceof DataStoreInfo) {
            info = (DataStoreInfo)store;
            try {
                da = info.getDataStore(null);
                if (da instanceof Wrapper) {
                    wrapper = (Wrapper)da;
                    try {
                        da = (DataAccess)wrapper.unwrap(DataAccess.class);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException(e);
                    }
                }
                this.createSQLViewContainer.setVisible(da instanceof JDBCDataStore);
                if (da instanceof WFSDataStore) {
                    dataStore = (WFSDataStore)da;
                    this.createCascadedWFSStoredQueryContainer.setVisible(dataStore.supportsStoredQueries());
                }
            }
            catch (IOException e) {
                NewLayerPage.LOGGER.log(Level.FINEST, e.getMessage());
            }
        }
        this.createCoverageViewContainer.setVisible(false);
        if (store instanceof CoverageStoreInfo) {
            this.createCoverageViewContainer.setVisible(true);
        }
        this.createWMSLayerImportContainer.setVisible(false);
        this.createWMTSLayerImportContainer.setVisible(false);
        if (store instanceof WMTSStoreInfo) {
            info1 = (WMTSStoreInfo)store;
            try {
                wmts = info1.getWebMapTileServer(null);
                this.createWMTSLayerImportContainer.setVisible(wmts != null);
            }
            catch (IOException e) {
                NewLayerPage.LOGGER.log(Level.FINEST, e.getMessage());
            }
        } else if (store instanceof WMSStoreInfo) {
            info = (WMSStoreInfo)store;
            try {
                wms = info.getWebMapServer(null);
                this.createWMSLayerImportContainer.setVisible(wms != null);
            }
            catch (IOException e) {
                NewLayerPage.LOGGER.log(Level.FINEST, e.getMessage());
            }
        }
    }

    LayerInfo buildLayerInfo(Resource resource) {
        Catalog catalog = this.getCatalog();
        StoreInfo store = catalog.getStore(this.getSelectedStoreId(), StoreInfo.class);
        DataStoreInfo expandedStore = null;
        if (store instanceof DataStoreInfo) {
            DataStoreInfo dstore = (DataStoreInfo)store;
            expandedStore = this.getCatalog().getResourcePool().clone(dstore, true);
        } else if (store instanceof CoverageStoreInfo) {
            CoverageStoreInfo cstore = (CoverageStoreInfo)store;
            expandedStore = this.getCatalog().getResourcePool().clone(cstore, true);
        } else if (store instanceof WMSStoreInfo) {
            WMSStoreInfo wmsInfo = (WMSStoreInfo)store;
            expandedStore = this.getCatalog().getResourcePool().clone(wmsInfo, true);
        } else if (store instanceof WMTSStoreInfo) {
            WMTSStoreInfo wmsInfo = (WMTSStoreInfo)store;
            expandedStore = this.getCatalog().getResourcePool().clone(wmsInfo, true);
        }
        try {
            WMTSLayerInfo wli;
            CatalogBuilder builder = new CatalogBuilder(catalog);
            builder.setStore((StoreInfo)expandedStore);
            if (expandedStore instanceof CoverageStoreInfo) {
                CoverageInfo ci = builder.buildCoverage(resource.getName().getLocalPart());
                return builder.buildLayer(ci);
            }
            if (expandedStore instanceof DataStoreInfo) {
                FeatureTypeInfo fti = builder.buildFeatureType(resource.getName());
                return builder.buildLayer(fti);
            }
            if (expandedStore instanceof WMTSStoreInfo) {
                wli = builder.buildWMTSLayer(resource.getLocalName());
                return builder.buildLayer((ResourceInfo)wli);
            }
            if (expandedStore instanceof WMSStoreInfo) {
                wli = builder.buildWMSLayer(resource.getLocalName());
                return builder.buildLayer((WMSLayerInfo)wli);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while building the resources for the configuration page", e);
        }
        if (expandedStore == null) {
            throw new IllegalArgumentException("Store is missing from configuration!");
        }
        throw new IllegalArgumentException("Don't know how to deal with this store " + String.valueOf(expandedStore));
    }

    String getSelectedStoreId() {
        return this.provider.getStoreId();
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }
}

