/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.Serializable;
import java.util.logging.Level;
import org.geoserver.web.data.layer.SQLViewParamProvider;
import org.geotools.jdbc.RegexpValidator;
import org.geotools.jdbc.VirtualTableParameter;

class Parameter
implements Serializable {
    private static final long serialVersionUID = -5028680760307467030L;
    String name;
    String defaultValue;
    String regexp;

    public Parameter(String name, String defaultValue, String regexp) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.regexp = regexp;
    }

    public Parameter(VirtualTableParameter param) {
        this.name = param.getName();
        this.defaultValue = param.getDefaultValue();
        VirtualTableParameter.Validator validator = param.getValidator();
        if (validator != null) {
            if (validator instanceof RegexpValidator) {
                RegexpValidator regexpValidator = (RegexpValidator)validator;
                this.regexp = regexpValidator.getPattern().pattern();
            } else {
                SQLViewParamProvider.LOGGER.log(Level.WARNING, "Skipping unknown validator type " + String.valueOf(validator.getClass()));
            }
        }
    }

    public VirtualTableParameter toVirtualTableParameter() {
        VirtualTableParameter result = new VirtualTableParameter(this.name, this.defaultValue);
        if (this.regexp != null) {
            result.setValidator((VirtualTableParameter.Validator)new RegexpValidator(this.regexp));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.regexp == null ? 0 : this.regexp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.regexp == null ? other.regexp != null : !this.regexp.equals(other.regexp));
    }

    public String toString() {
        return "Parameter [defaultValue=" + this.defaultValue + ", name=" + this.name + ", regexp=" + this.regexp + "]";
    }
}

