/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.data.layergroup.LayerGroupEntry;
import org.geoserver.web.data.layergroup.LayerGroupEntryPanel;
import org.geoserver.web.data.layergroup.LayerGroupModeChoiceRenderer;
import org.geoserver.web.data.layergroup.LayerGroupModeModel;
import org.geoserver.web.data.layergroup.LayerGroupPage;
import org.geoserver.web.data.layergroup.LayerGroupStyleConfig;
import org.geoserver.web.data.layergroup.RootLayerEntryPanel;
import org.geoserver.web.data.resource.MetadataLinkEditor;
import org.geoserver.web.data.resource.TitleAndAbstractPanel;
import org.geoserver.web.data.workspace.WorkspaceChoiceRenderer;
import org.geoserver.web.data.workspace.WorkspacesModel;
import org.geoserver.web.publish.PublishedConfigurationPage;
import org.geoserver.web.publish.PublishedEditTabPanel;
import org.geoserver.web.wicket.EnvelopePanel;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.KeywordsEditor;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;

public class LayerGroupEditPage
extends PublishedConfigurationPage<LayerGroupInfo> {
    private static final long serialVersionUID = 5659874305843575438L;
    public static final String GROUP = "group";
    public static final String WORKSPACE = "workspace";
    LayerGroupEntryPanel<LayerGroupInfo> lgEntryPanel;
    private CheckBox queryableCheckBox;

    protected LayerGroupEditPage(boolean isNew) {
        super(isNew);
        this.returnPageClass = LayerGroupPage.class;
    }

    public LayerGroupEditPage() {
        this(true);
        this.setupPublished(this.getCatalog().getFactory().createLayerGroup());
        this.postInit();
    }

    public LayerGroupEditPage(PageParameters parameters) {
        this(false);
        LayerGroupInfo lg;
        String groupName = parameters.get(GROUP).toString();
        String wsName = parameters.get(WORKSPACE).toOptionalString();
        LayerGroupInfo layerGroupInfo = lg = wsName != null ? this.getCatalog().getLayerGroupByName(wsName, groupName) : this.getCatalog().getLayerGroupByName(groupName);
        if (lg == null) {
            this.error((Serializable)((Object)new ParamResourceModel("LayerGroupEditPage.notFound", (Component)this, groupName).getString()));
            this.doReturn(LayerGroupPage.class);
            return;
        }
        this.setupPublished(lg);
        this.postInit();
    }

    private void postInit() {
        if (!this.isAuthenticatedAsAdmin() && !this.isNew && ((LayerGroupInfo)this.getPublishedInfo()).getWorkspace() == null) {
            this.setInputEnabled(false);
            this.info((Serializable)((Object)new StringResourceModel("globalLayerGroupReadOnly", (Component)this, null).getString()));
        }
    }

    @Override
    protected PublishedEditTabPanel<LayerGroupInfo> createMainTab(String panelID) {
        return new LayerGroupTab(panelID);
    }

    @Override
    protected void doSaveInternal() {
        if (this.lgEntryPanel.getEntries().isEmpty()) {
            this.error((Serializable)new ParamResourceModel("oneLayerMinimum", (Component)this.getPage(), new Object[0]).getObject());
            return;
        }
        LayerGroupInfo lg = (LayerGroupInfo)this.getPublishedInfo();
        if (!LayerGroupInfo.Mode.EO.equals((Object)lg.getMode())) {
            lg.setRootLayer(null);
            lg.setRootLayerStyle(null);
        } else if (lg.getRootLayerStyle() == null && lg.getRootLayer() != null) {
            lg.setRootLayerStyle(lg.getRootLayer().getDefaultStyle());
        }
        lg.getLayers().clear();
        lg.getStyles().clear();
        for (LayerGroupEntry entry : this.lgEntryPanel.getEntries()) {
            lg.getLayers().add(entry.getLayer());
            lg.getStyles().add(entry.getStyle());
        }
        Boolean queryable = (Boolean)this.queryableCheckBox.getModelObject();
        lg.setQueryDisabled(queryable == false);
        try {
            Catalog catalog = this.getCatalog();
            if (this.isNew) {
                catalog.add(lg);
            } else {
                catalog.save(lg);
            }
        }
        catch (Exception e) {
            this.error(e);
            LOGGER.log(Level.WARNING, "Error adding/modifying layer group.", e);
        }
    }

    public class LayerGroupTab
    extends PublishedEditTabPanel<LayerGroupInfo> {
        private static final long serialVersionUID = 2192005814142588155L;
        private EnvelopePanel envelopePanel;
        protected RootLayerEntryPanel rootLayerPanel;
        private LayerGroupStyleConfig groupStyleConfig;

        public LayerGroupTab(String id) {
            super(id, LayerGroupEditPage.this.myModel);
            this.initUI();
        }

        private void initUI() {
            final WebMarkupContainer rootLayerPanelContainer = new WebMarkupContainer("rootLayerContainer");
            rootLayerPanelContainer.setOutputMarkupId(true);
            this.add(new Component[]{rootLayerPanelContainer});
            this.rootLayerPanel = new RootLayerEntryPanel("rootLayer", ((LayerGroupInfo)this.getPublishedInfo()).getWorkspace(), (IModel<LayerGroupInfo>)LayerGroupEditPage.this.myModel);
            rootLayerPanelContainer.add(new Component[]{this.rootLayerPanel});
            this.updateRootLayerPanel(((LayerGroupInfo)this.getPublishedInfo()).getMode());
            TextField name = new TextField("name");
            name.setRequired(true);
            this.add(new Component[]{name});
            this.add(new Component[]{new CheckBox("enabled")});
            this.add(new Component[]{new CheckBox("advertised")});
            final DropDownChoice modeChoice = new DropDownChoice("mode", (IModel)new LayerGroupModeModel(), (IChoiceRenderer)new LayerGroupModeChoiceRenderer());
            modeChoice.setNullValid(false);
            modeChoice.setRequired(true);
            modeChoice.add(new Behavior[]{new OnChangeAjaxBehavior(){
                private static final long serialVersionUID = 8819356789334465887L;

                protected void onUpdate(AjaxRequestTarget target) {
                    LayerGroupInfo.Mode mode = (LayerGroupInfo.Mode)modeChoice.getModelObject();
                    LayerGroupTab.this.updateRootLayerPanel(mode);
                    if (mode.equals((Object)LayerGroupInfo.Mode.SINGLE) || mode.equals((Object)LayerGroupInfo.Mode.OPAQUE_CONTAINER)) {
                        LayerGroupTab.this.groupStyleConfig.setVisible(true);
                    } else {
                        LayerGroupTab.this.groupStyleConfig.setVisible(false);
                    }
                    target.add(new Component[]{rootLayerPanelContainer, LayerGroupTab.this.groupStyleConfig});
                }
            }});
            this.add(new Component[]{modeChoice});
            LayerGroupEditPage.this.queryableCheckBox = new CheckBox("queryable", (IModel)new Model((Serializable)Boolean.valueOf(!((LayerGroupInfo)this.getPublishedInfo()).isQueryDisabled())));
            this.add(new Component[]{LayerGroupEditPage.this.queryableCheckBox});
            this.add(new Component[]{new TitleAndAbstractPanel("titleAndAbstract", LayerGroupEditPage.this.myModel, "layerGroupTitle", "abstract", (MarkupContainer)this)});
            DropDownChoice wsChoice = new DropDownChoice(LayerGroupEditPage.WORKSPACE, (IModel)new WorkspacesModel(), (IChoiceRenderer)new WorkspaceChoiceRenderer());
            wsChoice.setNullValid(true);
            wsChoice.add(new Behavior[]{new OnChangeAjaxBehavior(){

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
            if (!LayerGroupEditPage.this.isAuthenticatedAsAdmin()) {
                wsChoice.setNullValid(false);
                wsChoice.setRequired(true);
            }
            this.add(new Component[]{wsChoice});
            Component[] componentArray = new Component[1];
            this.envelopePanel = new EnvelopePanel("bounds");
            componentArray[0] = this.envelopePanel;
            this.add(componentArray);
            this.envelopePanel.setRequired(true);
            this.envelopePanel.setCRSFieldVisible(true);
            this.envelopePanel.setCrsRequired(true);
            this.envelopePanel.setOutputMarkupId(true);
            this.add(new Component[]{new GeoServerAjaxFormLink("generateBounds"){
                private static final long serialVersionUID = -5290731459036222837L;

                @Override
                public void onClick(AjaxRequestTarget target, Form<?> form) {
                    LayerGroupInfo lg = LayerGroupEditPage.this.getCatalog().getFactory().createLayerGroup();
                    for (LayerGroupEntry entry : LayerGroupEditPage.this.lgEntryPanel.getEntries()) {
                        lg.getLayers().add(entry.getLayer());
                        lg.getStyles().add(entry.getStyle());
                    }
                    try {
                        CoordinateReferenceSystem crs = LayerGroupTab.this.envelopePanel.getCoordinateReferenceSystem();
                        if (crs != null) {
                            new CatalogBuilder(LayerGroupEditPage.this.getCatalog()).calculateLayerGroupBounds(lg, crs);
                        } else {
                            new CatalogBuilder(LayerGroupEditPage.this.getCatalog()).calculateLayerGroupBounds(lg);
                        }
                        LayerGroupTab.this.envelopePanel.setModelObject(lg.getBounds());
                        target.add(new Component[]{LayerGroupTab.this.envelopePanel});
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException((Throwable)e);
                    }
                }
            }});
            this.add(new Component[]{new GeoServerAjaxFormLink("generateBoundsFromCRS"){
                private static final long serialVersionUID = -7907583302556368270L;

                @Override
                protected void onClick(AjaxRequestTarget target, Form<?> form) {
                    LOGGER.log(Level.FINE, "Computing bounds for LG based off CRS");
                    LayerGroupInfo lg = (LayerGroupInfo)LayerGroupTab.this.getPublishedInfo();
                    CoordinateReferenceSystem crs = LayerGroupTab.this.envelopePanel.getCoordinateReferenceSystem();
                    new CatalogBuilder(LayerGroupEditPage.this.getCatalog()).calculateLayerGroupBoundsFromCRS(lg, crs);
                    LayerGroupTab.this.envelopePanel.modelChanged();
                    target.add(new Component[]{LayerGroupTab.this.envelopePanel});
                }
            }});
            Component[] componentArray2 = new Component[1];
            LayerGroupEditPage.this.lgEntryPanel = new LayerGroupEntryPanel<LayerGroupInfo>("layers", (LayerGroupInfo)this.getPublishedInfo(), wsChoice.getModel()){

                @Override
                protected List<PublishedInfo> getLayers(LayerGroupInfo object) {
                    return object.getLayers();
                }

                @Override
                protected List<StyleInfo> getStyles(LayerGroupInfo object) {
                    return object.getStyles();
                }
            };
            componentArray2[0] = LayerGroupEditPage.this.lgEntryPanel;
            this.add(componentArray2);
            Component[] componentArray3 = new Component[1];
            this.groupStyleConfig = new LayerGroupStyleConfig("layerGroupStyles", (IModel<LayerGroupInfo>)LayerGroupEditPage.this.myModel);
            componentArray3[0] = this.groupStyleConfig;
            this.add(componentArray3);
            this.groupStyleConfig.setOutputMarkupId(true);
            this.groupStyleConfig.setOutputMarkupPlaceholderTag(true);
            this.add(new Component[]{new MetadataLinkEditor("metadataLinks", LayerGroupEditPage.this.myModel)});
            this.add(new Component[]{new KeywordsEditor("keywords", LiveCollectionModel.list(new PropertyModel((Object)LayerGroupEditPage.this.myModel, "keywords")))});
            if (!LayerGroupEditPage.this.isAuthenticatedAsAdmin()) {
                if (LayerGroupEditPage.this.isNew) {
                    List ws = LayerGroupEditPage.this.getCatalog().getWorkspaces();
                    if (!ws.isEmpty()) {
                        wsChoice.setModelObject((Object)((WorkspaceInfo)ws.get(0)));
                    }
                } else {
                    wsChoice.setEnabled(false);
                }
            }
        }

        private void updateRootLayerPanel(LayerGroupInfo.Mode mode) {
            this.rootLayerPanel.setEnabled(LayerGroupInfo.Mode.EO.equals((Object)mode));
            this.rootLayerPanel.setVisible(LayerGroupInfo.Mode.EO.equals((Object)mode));
        }

        class GroupNameValidator
        implements IValidator<String> {
            private static final long serialVersionUID = -6621372846640620132L;

            GroupNameValidator() {
            }

            public void validate(IValidatable<String> validatable) {
                String name = (String)validatable.getValue();
                LayerGroupInfo other = LayerGroupEditPage.this.getCatalog().getLayerGroupByName(name);
                if (other != null && (LayerGroupEditPage.this.isNew || !other.getId().equals(((LayerGroupInfo)LayerGroupTab.this.getPublishedInfo()).getId()))) {
                    ValidationError err = new ValidationError("duplicateGroupNameError").addKey("duplicateGroupNameError").setVariable("name", (Object)name);
                    validatable.error((IValidationError)err);
                }
            }
        }
    }
}

