/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.SelectionRemovalLink;
import org.geoserver.web.data.layergroup.LayerGroupEditPage;
import org.geoserver.web.data.layergroup.LayerGroupProvider;
import org.geoserver.web.data.workspace.WorkspaceEditPage;
import org.geoserver.web.wicket.CachingImage;
import org.geoserver.web.wicket.DateTimeLabel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleBookmarkableLink;

public class LayerGroupPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 5039809655908312633L;
    GeoServerTablePanel<LayerGroupInfo> table;
    GeoServerDialog dialog;
    SelectionRemovalLink removal;

    public LayerGroupPage() {
        final CatalogIconFactory icons = CatalogIconFactory.get();
        LayerGroupProvider provider = new LayerGroupProvider();
        Component[] componentArray = new Component[1];
        this.table = new GeoServerTablePanel<LayerGroupInfo>("table", (GeoServerDataProvider)provider, true){
            private static final long serialVersionUID = 714777934301159139L;

            @Override
            protected Component getComponentForProperty(String id, IModel<LayerGroupInfo> itemModel, GeoServerDataProvider.Property<LayerGroupInfo> property) {
                if (property == LayerGroupProvider.NAME) {
                    return LayerGroupPage.this.layerGroupLink(id, itemModel);
                }
                if (property == LayerGroupProvider.WORKSPACE) {
                    return LayerGroupPage.this.workspaceLink(id, itemModel);
                }
                if (property == LayerGroupProvider.MODIFIED_TIMESTAMP) {
                    return new DateTimeLabel(id, LayerGroupProvider.MODIFIED_TIMESTAMP.getModel(itemModel));
                }
                if (property == LayerGroupProvider.CREATED_TIMESTAMP) {
                    return new DateTimeLabel(id, LayerGroupProvider.CREATED_TIMESTAMP.getModel(itemModel));
                }
                if (property == LayerGroupProvider.ENABLED) {
                    LayerGroupInfo layerGroupInfo = (LayerGroupInfo)itemModel.getObject();
                    boolean enabled = layerGroupInfo.isEnabled();
                    PackageResourceReference icon = enabled ? icons.getEnabledIcon() : icons.getDisabledIcon();
                    Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)LayerGroupPage.this);
                    f.add(new Component[]{new CachingImage("layerIcon", (ResourceReference)icon, new ResourceReference[0])});
                    return f;
                }
                if (property == LayerGroupProvider.MODIFIED_BY) {
                    return new Label(id, LayerGroupProvider.MODIFIED_BY.getModel(itemModel));
                }
                return null;
            }

            @Override
            protected void onSelectionUpdate(AjaxRequestTarget target) {
                if (!LayerGroupPage.this.table.getSelection().isEmpty()) {
                    boolean canRemove = true;
                    if (!LayerGroupPage.this.isAuthenticatedAsAdmin()) {
                        for (LayerGroupInfo lg : LayerGroupPage.this.table.getSelection()) {
                            if (lg.getWorkspace() != null) continue;
                            canRemove = false;
                            break;
                        }
                    }
                    LayerGroupPage.this.removal.setEnabled(canRemove);
                } else {
                    LayerGroupPage.this.removal.setEnabled(false);
                }
                target.add(new Component[]{LayerGroupPage.this.removal});
            }
        };
        componentArray[0] = this.table;
        this.add(componentArray);
        this.table.setOutputMarkupId(true);
        this.add(new Component[]{this.table});
        Component[] componentArray2 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray2[0] = this.dialog;
        this.add(componentArray2);
        this.setHeaderPanel(this.headerPanel());
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new BookmarkablePageLink("addNew", LayerGroupEditPage.class)});
        Component[] componentArray = new Component[1];
        this.removal = new SelectionRemovalLink("removeSelected", this.table, this.dialog);
        componentArray[0] = this.removal;
        header.add(componentArray);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        return header;
    }

    Component layerGroupLink(String id, IModel<LayerGroupInfo> itemModel) {
        IModel<?> groupNameModel = LayerGroupProvider.NAME.getModel(itemModel);
        IModel<?> wsModel = LayerGroupProvider.WORKSPACE.getModel(itemModel);
        String groupName = (String)groupNameModel.getObject();
        String wsName = (String)wsModel.getObject();
        if (wsName == null) {
            return new SimpleBookmarkableLink(id, LayerGroupEditPage.class, groupNameModel, "group", groupName);
        }
        return new SimpleBookmarkableLink(id, LayerGroupEditPage.class, groupNameModel, "group", groupName, "workspace", wsName);
    }

    Component workspaceLink(String id, IModel<LayerGroupInfo> itemModel) {
        IModel<?> wsNameModel = LayerGroupProvider.WORKSPACE.getModel(itemModel);
        String wsName = (String)wsNameModel.getObject();
        if (wsName != null) {
            return new SimpleBookmarkableLink(id, WorkspaceEditPage.class, (IModel<?>)new Model((Serializable)((Object)wsName)), "name", wsName);
        }
        return new WebMarkupContainer(id);
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }
}

