/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.SettingsInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.layergroup.LayerGroupDetachableModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.springframework.lang.Nullable;

public class LayerGroupProvider
extends GeoServerDataProvider<LayerGroupInfo> {
    private static final long serialVersionUID = 4806818198949114395L;
    public static GeoServerDataProvider.Property<LayerGroupInfo> NAME = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("name", "name");
    public static GeoServerDataProvider.Property<LayerGroupInfo> WORKSPACE = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("workspace", "workspace.name");
    static final GeoServerDataProvider.Property<LayerGroupInfo> MODIFIED_TIMESTAMP = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("datemodfied", "dateModified");
    static final GeoServerDataProvider.Property<LayerGroupInfo> CREATED_TIMESTAMP = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("datecreated", "dateCreated");
    static final GeoServerDataProvider.Property<LayerGroupInfo> MODIFIED_BY = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("modifiedby", "modifiedBy");
    public static GeoServerDataProvider.Property<LayerGroupInfo> ENABLED = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("enabled", "enabled");
    static List<GeoServerDataProvider.Property<LayerGroupInfo>> PROPERTIES = Arrays.asList(NAME, WORKSPACE, ENABLED);

    @Override
    public long size() {
        return this.count(this.getFilter());
    }

    @Override
    public int fullSize() {
        return this.count(Predicates.acceptAll());
    }

    private int count(Filter filter) {
        return this.getCatalog().count(LayerGroupInfo.class, filter);
    }

    @Override
    public Iterator<LayerGroupInfo> iterator(long first, long count) {
        SortBy sortOrder = this.getSortOrder();
        Filter filter = this.getFilter();
        try (Stream<LayerGroupInfo> items = this.query(filter, (int)first, (int)count, sortOrder);){
            Iterator<LayerGroupInfo> iterator = items.collect(Collectors.toList()).iterator();
            return iterator;
        }
    }

    @Override
    protected List<LayerGroupInfo> getItems() {
        throw new UnsupportedOperationException("This method should not be being called! We use the catalog streaming API");
    }

    @Override
    protected List<GeoServerDataProvider.Property<LayerGroupInfo>> getProperties() {
        String trackUser;
        List<GeoServerDataProvider.Property<LayerGroupInfo>> modifiedPropertiesList = PROPERTIES.stream().map(c -> c).collect(Collectors.toList());
        SettingsInfo settings = GeoServerApplication.get().getGeoServer().getSettings();
        if (settings.isShowCreatedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(CREATED_TIMESTAMP);
        }
        if (settings.isShowModifiedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(MODIFIED_TIMESTAMP);
        }
        if ((trackUser = GeoServerExtensions.getProperty((String)"TRACK_USER")) == null && GeoServerApplication.get().getGeoServer().getSettings().isShowModifiedUserInAdminList() || Boolean.parseBoolean(trackUser)) {
            modifiedPropertiesList.add(MODIFIED_BY);
        }
        return modifiedPropertiesList;
    }

    @Override
    public IModel<LayerGroupInfo> newModel(LayerGroupInfo object) {
        return new LayerGroupDetachableModel(object);
    }

    private Stream<LayerGroupInfo> query(Filter filter, @Nullable Integer first, @Nullable Integer count, @Nullable SortBy sortOrder) {
        Catalog catalog = this.getCatalog();
        CloseableIterator items = catalog.list(LayerGroupInfo.class, filter, first, count, sortOrder);
        Stream stream = Streams.stream((Iterator)items);
        return (Stream)stream.onClose(() -> ((CloseableIterator)items).close());
    }

    private SortBy getSortOrder() {
        SortParam sort = this.getSort();
        if (null == sort) {
            sort = new SortParam((Object)NAME.getName(), true);
        }
        GeoServerDataProvider.Property property = this.getProperty(sort);
        SortBy sortOrder = null;
        if (property instanceof GeoServerDataProvider.BeanProperty) {
            String sortProperty = ((GeoServerDataProvider.BeanProperty)property).getPropertyPath();
            sortOrder = Predicates.sortBy((String)sortProperty, (boolean)sort.isAscending());
        } else if (null != property) {
            throw new IllegalStateException("Unknown sort property " + String.valueOf(property));
        }
        return sortOrder;
    }
}

