/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.web.data.style.StyleDetachableModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public abstract class StyleListPanel
extends GeoServerTablePanel<StyleInfo> {
    private static final long serialVersionUID = -811883647153309626L;
    static GeoServerDataProvider.Property<StyleInfo> NAME = new GeoServerDataProvider.BeanProperty<StyleInfo>("name", "name");

    public StyleListPanel(String id, StyleListProvider styleProvider) {
        super(id, styleProvider);
        this.getTopPager().setVisible(false);
    }

    public StyleListPanel(String id, PublishedInfo publishedInfo) {
        this(id, new StyleListProvider(publishedInfo));
    }

    @Override
    protected Component getComponentForProperty(String id, IModel<StyleInfo> itemModel, GeoServerDataProvider.Property<StyleInfo> property) {
        final StyleInfo style = (StyleInfo)itemModel.getObject();
        if (property == NAME) {
            return new SimpleAjaxLink<String>(id, NAME.getModel(itemModel)){
                private static final long serialVersionUID = -2537227506881638001L;

                @Override
                public void onClick(AjaxRequestTarget target) {
                    StyleListPanel.this.handleStyle(style, target);
                }
            };
        }
        return null;
    }

    protected abstract void handleStyle(StyleInfo var1, AjaxRequestTarget var2);

    protected static class StyleListProvider
    extends GeoServerDataProvider<StyleInfo> {
        private static final long serialVersionUID = -5061497681708482229L;
        private PublishedInfo publishedInfo;

        protected StyleListProvider(PublishedInfo publishedInfo) {
            this.publishedInfo = publishedInfo;
        }

        protected StyleListProvider() {
        }

        @Override
        protected List<StyleInfo> getItems() {
            List<StyleInfo> items;
            PublishedInfo publishedInfo = this.publishedInfo;
            if (publishedInfo instanceof LayerGroupInfo) {
                LayerGroupInfo info = (LayerGroupInfo)publishedInfo;
                items = this.groupStyles(info);
            } else {
                items = new ArrayList<StyleInfo>(this.getCatalog().getStyles());
            }
            return items;
        }

        private List<StyleInfo> groupStyles(LayerGroupInfo groupInfo) {
            List groupStyles = groupInfo.getLayerGroupStyles();
            List<Object> styles = groupStyles == null || groupStyles.isEmpty() ? Collections.emptyList() : groupStyles.stream().map(gs -> gs.getName()).collect(Collectors.toList());
            return styles;
        }

        @Override
        protected List<GeoServerDataProvider.Property<StyleInfo>> getProperties() {
            return Arrays.asList(NAME);
        }

        @Override
        public IModel<StyleInfo> newModel(StyleInfo object) {
            if (this.publishedInfo instanceof LayerGroupInfo) {
                return Model.of((Serializable)object);
            }
            return new StyleDetachableModel(object);
        }
    }
}

