/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.form.NumberTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.web.data.resource.ClassTextField;
import org.geoserver.web.data.resource.InternationalStringConverter;
import org.geotools.util.NumberRange;

public class AttributeTypeInfoEditPanel
extends Panel {
    private static final long serialVersionUID = -4226325094883373205L;
    private final IModel<AttributeTypeInfo> model;
    private final AttributeTypeInfo object;
    private ClassTextField typeTextField;
    private WebMarkupContainer restrictionsContainer;
    private DropDownChoice<RESTRICTION_TYPE> restrictionTypeDropDownChoice;
    private WebMarkupContainer optionsContainer;
    private ListMultipleChoice<Object> optionsListMultipleChoice;
    private TextField<Serializable> newOptionTextField;
    private WebMarkupContainer rangeContainer;
    private NumberTextField<? extends Number> rangeMinTextField;
    private NumberTextField<? extends Number> rangeMaxTextField;

    public AttributeTypeInfoEditPanel(String id, IModel<AttributeTypeInfo> model) {
        super(id, model);
        this.model = model;
        this.object = (AttributeTypeInfo)model.getObject();
        this.add(new Behavior[]{new Behavior(){

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)AttributeTypeInfoEditPanel.this.adjustModalHeightScript()));
            }
        }});
        this.initComponents();
    }

    void initComponents() {
        Form form = new Form("attributeForm", this.model);
        this.initAttributeInfoFields((Form<AttributeTypeInfo>)form);
        this.initRestrictionsContainer();
        form.add(new Component[]{this.restrictionsContainer});
        form.add(this.newOptionValidator());
        form.add(this.rangeValidator());
        form.add(new Component[]{this.createFeedbackPanel()});
        this.add(new Component[]{form});
    }

    private void initAttributeInfoFields(Form<AttributeTypeInfo> form) {
        TextField nameTextField = new TextField("name", (IModel)new PropertyModel(this.model, "name"));
        nameTextField.setRequired(true);
        this.initTypeTextField();
        TextArea sourceTextArea = new TextArea("source", (IModel)new PropertyModel(this.model, "source"));
        TextArea<String> descriptionTextArea = new TextArea<String>("description", (IModel)new PropertyModel(this.model, "description")){

            public <C> IConverter<C> getConverter(Class<C> type) {
                return new InternationalStringConverter();
            }
        };
        CheckBox nillableCheckBox = new CheckBox("nillable", (IModel)new PropertyModel(this.model, "nillable"));
        form.add(new Component[]{nameTextField, this.typeTextField, sourceTextArea, descriptionTextArea, nillableCheckBox});
    }

    private void initTypeTextField() {
        this.typeTextField = new ClassTextField((IModel<Class>)Model.of((Serializable)this.object.getBinding()));
        this.typeTextField.setType(Class.class);
        this.typeTextField.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                AttributeTypeInfoEditPanel.this.restrictionTypeDropDownChoice.setModel((IModel)Model.of((Serializable)((Object)RESTRICTION_TYPE.NONE)));
                AttributeTypeInfoEditPanel.this.optionsListMultipleChoice.setChoices(new ArrayList());
                Class convertedInput = (Class)AttributeTypeInfoEditPanel.this.typeTextField.getModelObject();
                AttributeTypeInfoEditPanel.this.rangeMinTextField.setType(convertedInput);
                AttributeTypeInfoEditPanel.this.rangeMaxTextField.setType(convertedInput);
                target.add(new Component[]{AttributeTypeInfoEditPanel.this.restrictionsContainer});
                target.add(new Component[]{AttributeTypeInfoEditPanel.this.restrictionTypeDropDownChoice});
                target.appendJavaScript((CharSequence)AttributeTypeInfoEditPanel.this.adjustModalHeightScript());
            }
        }});
    }

    private void initRestrictionsContainer() {
        this.restrictionsContainer = new WebMarkupContainer("restrictionsContainer");
        this.restrictionsContainer.setOutputMarkupId(true);
        this.restrictionsContainer.setOutputMarkupPlaceholderTag(true);
        this.restrictionsContainer.add(new Behavior[]{new Behavior(){

            public void onConfigure(Component component) {
                super.onConfigure(component);
                component.setVisible(AttributeTypeInfoEditPanel.this.shouldRestrictionBeVisible());
            }
        }});
        this.initRestrictionTypeDropDownChoice();
        this.restrictionsContainer.add(new Component[]{this.restrictionTypeDropDownChoice});
        this.initOptionsContainer();
        this.restrictionsContainer.add(new Component[]{this.optionsContainer});
        this.initRangeContainer();
        this.restrictionsContainer.add(new Component[]{this.rangeContainer});
    }

    private boolean shouldRestrictionBeVisible() {
        return this.typeTextField.getModelObject() != null && (this.isAttributeTypeString() || this.isAttributeTypeNumber());
    }

    private void initRestrictionTypeDropDownChoice() {
        this.restrictionTypeDropDownChoice = new DropDownChoice("restrictionType", (IModel)Model.of((Serializable)((Object)this.computeActualRestrictionType())), (IModel)new LoadableDetachableModel<List<RESTRICTION_TYPE>>(){

            protected List<RESTRICTION_TYPE> load() {
                return AttributeTypeInfoEditPanel.this.computeAvailableRestrictionTypes();
            }
        }, (IChoiceRenderer)new IChoiceRenderer<RESTRICTION_TYPE>(){

            public Object getDisplayValue(RESTRICTION_TYPE type) {
                return new StringResourceModel("AttributeTypeInfoEditPanel.restrictionType." + type.name().toLowerCase()).getString();
            }

            public String getIdValue(RESTRICTION_TYPE type, int index) {
                return type.name();
            }
        });
        this.restrictionTypeDropDownChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{AttributeTypeInfoEditPanel.this.optionsContainer});
                target.add(new Component[]{AttributeTypeInfoEditPanel.this.rangeContainer});
                target.appendJavaScript((CharSequence)AttributeTypeInfoEditPanel.this.adjustModalHeightScript());
            }
        }});
    }

    private RESTRICTION_TYPE computeActualRestrictionType() {
        if (this.object.getOptions() != null && !this.object.getOptions().isEmpty()) {
            return RESTRICTION_TYPE.OPTIONS;
        }
        if (this.object.getRange() != null) {
            return RESTRICTION_TYPE.RANGE;
        }
        return RESTRICTION_TYPE.NONE;
    }

    private List<RESTRICTION_TYPE> computeAvailableRestrictionTypes() {
        if (this.isAttributeTypeNumber()) {
            return List.of(RESTRICTION_TYPE.values());
        }
        if (this.isAttributeTypeString()) {
            return List.of(RESTRICTION_TYPE.NONE, RESTRICTION_TYPE.OPTIONS);
        }
        return List.of();
    }

    private boolean isAttributeTypeNumber() {
        return Number.class.isAssignableFrom((Class)this.typeTextField.getModelObject());
    }

    private boolean isAttributeTypeString() {
        return String.class == this.typeTextField.getModelObject();
    }

    private String adjustModalHeightScript() {
        return String.format("var modal = document.querySelector('.wicket-modal'); modal.style.height = '%spx';", this.calculateModalHeight());
    }

    private int calculateModalHeight() {
        if (!this.shouldRestrictionBeVisible()) {
            return 350;
        }
        switch ((RESTRICTION_TYPE)((Object)this.restrictionTypeDropDownChoice.getModelObject())) {
            case NONE: {
                return 450;
            }
            case OPTIONS: {
                return 600;
            }
            case RANGE: {
                return 500;
            }
        }
        return 400;
    }

    private void initOptionsContainer() {
        this.optionsContainer = new WebMarkupContainer("optionsContainer");
        this.optionsContainer.setOutputMarkupPlaceholderTag(true);
        this.optionsContainer.add(new Behavior[]{new Behavior(){

            public void onConfigure(Component component) {
                super.onConfigure(component);
                component.setVisible(AttributeTypeInfoEditPanel.this.restrictionTypeDropDownChoice.getModelObject() == RESTRICTION_TYPE.OPTIONS);
            }
        }});
        this.initOptionsListMultipleChoice();
        this.initNewOptionTextField();
        this.optionsContainer.add(new Component[]{this.optionsListMultipleChoice, this.createRemoveOptionButton(), this.newOptionTextField, this.createAddOptionButton()});
    }

    private void initOptionsListMultipleChoice() {
        ArrayList options = this.object.getOptions();
        if (options == null) {
            options = new ArrayList();
        }
        this.optionsListMultipleChoice = new ListMultipleChoice("options", (IModel)new Model(new ArrayList()), new ArrayList(options), String::valueOf);
        this.optionsListMultipleChoice.setOutputMarkupId(true);
    }

    private void initNewOptionTextField() {
        this.newOptionTextField = new TextField("newOption", (IModel)new Model());
        this.newOptionTextField.setOutputMarkupPlaceholderTag(true);
        this.newOptionTextField.setOutputMarkupId(true);
    }

    private AjaxButton createRemoveOptionButton() {
        return new AjaxButton("removeOption"){

            public void onSubmit(AjaxRequestTarget target) {
                Collection selection = (Collection)AttributeTypeInfoEditPanel.this.optionsListMultipleChoice.getModelObject();
                List choices = AttributeTypeInfoEditPanel.this.optionsListMultipleChoice.getChoices();
                choices.removeAll(selection);
                selection.clear();
                AttributeTypeInfoEditPanel.this.optionsListMultipleChoice.setModelObject((Object)selection);
                target.add(new Component[]{AttributeTypeInfoEditPanel.this.optionsListMultipleChoice});
            }
        };
    }

    private AjaxButton createAddOptionButton() {
        return new AjaxButton("addOption"){

            public void onSubmit(AjaxRequestTarget target) {
                String newOptionValue = AttributeTypeInfoEditPanel.this.newOptionTextField.getInput();
                if (newOptionValue != null && !newOptionValue.isBlank()) {
                    List choices = AttributeTypeInfoEditPanel.this.optionsListMultipleChoice.getChoices();
                    choices.add(newOptionValue);
                    AttributeTypeInfoEditPanel.this.newOptionTextField.setModelObject(null);
                    AttributeTypeInfoEditPanel.this.newOptionTextField.modelChanged();
                    target.add(new Component[]{AttributeTypeInfoEditPanel.this.newOptionTextField});
                    target.add(new Component[]{AttributeTypeInfoEditPanel.this.optionsListMultipleChoice});
                }
            }
        };
    }

    private void initRangeContainer() {
        this.rangeContainer = new WebMarkupContainer("rangeContainer");
        this.rangeContainer.setOutputMarkupPlaceholderTag(true);
        this.rangeContainer.add(new Behavior[]{new Behavior(){

            public void onConfigure(Component component) {
                super.onConfigure(component);
                component.setVisible(AttributeTypeInfoEditPanel.this.restrictionTypeDropDownChoice.getModelObject() == RESTRICTION_TYPE.RANGE);
            }
        }});
        this.initRangeTextFields();
        this.rangeContainer.add(new Component[]{this.rangeMinTextField, this.rangeMaxTextField});
    }

    private void initRangeTextFields() {
        Number minValue = 0;
        Number maxValue = 0;
        if (this.object.getRange() != null) {
            NumberRange range = this.object.getRange();
            range = range.castTo(this.object.getBinding());
            minValue = (Number)((Object)range.getMinValue());
            maxValue = (Number)((Object)range.getMaxValue());
        }
        this.rangeMinTextField = new NumberTextField("rangeMin", (IModel)new Model((Serializable)minValue), this.object.getBinding());
        this.rangeMinTextField.setOutputMarkupId(true);
        this.rangeMinTextField.setLabel((IModel)new StringResourceModel("AttributeTypeInfoEditPanel.minInclusive"));
        this.rangeMaxTextField = new NumberTextField("rangeMax", (IModel)new Model((Serializable)maxValue), this.object.getBinding());
        this.rangeMaxTextField.setOutputMarkupId(true);
        this.rangeMaxTextField.setLabel((IModel)new StringResourceModel("AttributeTypeInfoEditPanel.maxInclusive"));
    }

    private IFormValidator newOptionValidator() {
        return new IFormValidator(){

            public FormComponent<?>[] getDependentFormComponents() {
                if (AttributeTypeInfoEditPanel.this.restrictionTypeDropDownChoice.getModelObject() != RESTRICTION_TYPE.OPTIONS) {
                    return new FormComponent[0];
                }
                return new FormComponent[]{AttributeTypeInfoEditPanel.this.newOptionTextField};
            }

            public void validate(Form<?> form) {
                try {
                    String input = AttributeTypeInfoEditPanel.this.newOptionTextField.getInput();
                    if (input != null && !input.isBlank() && AttributeTypeInfoEditPanel.this.isAttributeTypeNumber()) {
                        Double.parseDouble(input);
                    }
                }
                catch (NumberFormatException ex) {
                    AttributeTypeInfoEditPanel.this.newOptionTextField.error((Serializable)((Object)new StringResourceModel("AttributeTypeInfoEditPanel.optionTypeNumberErrorMessage").getString()));
                }
            }
        };
    }

    private IFormValidator rangeValidator() {
        return new IFormValidator(){

            public FormComponent<?>[] getDependentFormComponents() {
                if (AttributeTypeInfoEditPanel.this.restrictionTypeDropDownChoice.getModelObject() != RESTRICTION_TYPE.RANGE) {
                    return new FormComponent[0];
                }
                return new FormComponent[]{AttributeTypeInfoEditPanel.this.rangeMinTextField, AttributeTypeInfoEditPanel.this.rangeMaxTextField};
            }

            public void validate(Form<?> form) {
                Number min = (Number)AttributeTypeInfoEditPanel.this.rangeMinTextField.getConvertedInput();
                Number max = (Number)AttributeTypeInfoEditPanel.this.rangeMaxTextField.getConvertedInput();
                if (min != null && max != null && min.doubleValue() > max.doubleValue()) {
                    AttributeTypeInfoEditPanel.this.rangeMaxTextField.error((Serializable)((Object)new StringResourceModel("AttributeTypeInfoEditPanel.rangeMinMaxErrorMessage").getString()));
                }
            }
        };
    }

    private FeedbackPanel createFeedbackPanel() {
        FeedbackPanel feedbackPanel = new FeedbackPanel("dialogFeedback");
        feedbackPanel.setOutputMarkupId(true);
        return feedbackPanel;
    }

    public void finalizeAttributeValues() {
        if (this.ifBindingHasBeenChanged()) {
            this.object.setBinding((Class)this.typeTextField.getModelObject());
        }
        switch ((RESTRICTION_TYPE)((Object)this.restrictionTypeDropDownChoice.getModelObject())) {
            case NONE: {
                this.object.setOptions(null);
                this.object.setRange(null);
                break;
            }
            case RANGE: {
                this.object.setOptions(null);
                this.object.setRange(this.createRangeFromRangeFields());
                break;
            }
            case OPTIONS: {
                this.object.setRange(null);
                this.object.setOptions(this.optionsListMultipleChoice.getChoices());
            }
        }
    }

    private boolean ifBindingHasBeenChanged() {
        return this.object.getBinding() != this.typeTextField.getModelObject();
    }

    private NumberRange<? extends Number> createRangeFromRangeFields() {
        Class type = (Class)this.typeTextField.getModelObject();
        Number min = (Number)this.rangeMinTextField.getConvertedInput();
        Number max = (Number)this.rangeMaxTextField.getConvertedInput();
        if (Byte.class.equals((Object)type)) {
            byte byteMin = min != null ? (byte)min.byteValue() : (byte)-128;
            byte byteMax = max != null ? (byte)max.byteValue() : (byte)127;
            return NumberRange.create((byte)byteMin, (byte)byteMax);
        }
        if (Short.class.equals((Object)type)) {
            short shortMin = min != null ? (short)min.shortValue() : (short)Short.MIN_VALUE;
            short shortMax = max != null ? (short)max.shortValue() : (short)Short.MAX_VALUE;
            return NumberRange.create((short)shortMin, (short)shortMax);
        }
        double doubleMin = min != null ? min.doubleValue() : Double.NEGATIVE_INFINITY;
        double doubleMax = max != null ? max.doubleValue() : Double.POSITIVE_INFINITY;
        NumberRange range = NumberRange.create((double)doubleMin, (double)doubleMax);
        return range.castTo(type);
    }

    static enum RESTRICTION_TYPE {
        NONE,
        OPTIONS,
        RANGE;

    }
}

