/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.ReuseIfModelsEqualStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.resource.AttributeTypeInfoEditPanel;
import org.geoserver.web.data.resource.ClassLabel;
import org.geoserver.web.data.resource.InternationalStringConverter;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.ReorderableTablePanel;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;

class AttributeTypeInfoEditor
extends Panel {
    static final Logger LOGGER = Logging.getLogger(AttributeTypeInfoEditor.class);
    private static final GeoServerDataProvider.Property<AttributeTypeInfo> NAME = new GeoServerDataProvider.BeanProperty<AttributeTypeInfo>("name");
    private static final GeoServerDataProvider.Property<AttributeTypeInfo> BINDING = new GeoServerDataProvider.BeanProperty<AttributeTypeInfo>("binding");
    private static final GeoServerDataProvider.Property<AttributeTypeInfo> DESCRIPTION = new GeoServerDataProvider.BeanProperty<AttributeTypeInfo>("description");
    private static final GeoServerDataProvider.PropertyPlaceholder<AttributeTypeInfo> DETAILS = new GeoServerDataProvider.PropertyPlaceholder("details");
    private static final GeoServerDataProvider.PropertyPlaceholder<AttributeTypeInfo> REMOVE = new GeoServerDataProvider.PropertyPlaceholder("remove");
    private static final GeoServerDataProvider.PropertyPlaceholder<AttributeTypeInfo> EDIT = new GeoServerDataProvider.PropertyPlaceholder("edit");
    private static final LoadableDetachableModel<List<GeoServerDataProvider.Property<AttributeTypeInfo>>> propertiesModel = new LoadableDetachableModel<List<GeoServerDataProvider.Property<AttributeTypeInfo>>>(){

        protected List<GeoServerDataProvider.Property<AttributeTypeInfo>> load() {
            return Arrays.asList(NAME, BINDING, DESCRIPTION, DETAILS, EDIT, REMOVE);
        }
    };
    private final ReorderableTablePanel<AttributeTypeInfo> table;
    private final GeoServerDialog editDialog;
    private final Component parent;

    public AttributeTypeInfoEditor(String id, IModel model, Component parent) {
        super(id, model);
        this.parent = parent;
        this.add(new Component[]{new AddAttributeLink()});
        this.add(new Component[]{new ResetLink()});
        List<AttributeTypeInfo> attributes = AttributeTypeInfoEditor.getAttributes(model, parent);
        this.table = new EditorTable(attributes, parent);
        this.table.setItemReuseStrategy((IItemReuseStrategy)new ReuseIfModelsEqualStrategy());
        this.table.setPageable(false);
        this.table.setFilterable(false);
        this.add(new Component[]{this.table});
        this.editDialog = new GeoServerDialog("dialog");
        this.add(new Component[]{this.editDialog});
    }

    private static List<AttributeTypeInfo> getAttributes(IModel model, Component parent) {
        FeatureTypeInfo typeInfo = (FeatureTypeInfo)model.getObject();
        List attributes = typeInfo.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            return AttributeTypeInfoEditor.loadNativeAttributes(typeInfo, parent);
        }
        if (attributes.stream().anyMatch(a -> a.getBinding() == null)) {
            List<AttributeTypeInfo> nativeAttributes = AttributeTypeInfoEditor.loadNativeAttributes(typeInfo, parent);
            Map<String, Class> bindings = nativeAttributes.stream().collect(Collectors.toMap(AttributeTypeInfo::getName, AttributeTypeInfo::getBinding));
            for (AttributeTypeInfo at : attributes) {
                if (at.getBinding() != null) continue;
                at.setBinding(bindings.get(at.getName()));
            }
        }
        return new ArrayList<AttributeTypeInfo>(attributes);
    }

    static List<AttributeTypeInfo> loadNativeAttributes(FeatureTypeInfo typeInfo, Component component) {
        try {
            Catalog catalog = GeoServerApplication.get().getCatalog();
            ResourcePool resourcePool = catalog.getResourcePool();
            return resourcePool.loadAttributes(typeInfo);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Grabbing the attribute list failed", e);
            String errorMessage = e.getMessage();
            if (e.getCause() instanceof SQLException) {
                errorMessage = e.getCause().getMessage();
            }
            String error = new ParamResourceModel("attributeListingFailed", component, errorMessage).getString();
            try {
                component.getPage().error((Serializable)((Object)error));
            }
            catch (Exception e1) {
                LOGGER.log(Level.SEVERE, "Grabbing the attribute list failed", e1.getMessage());
            }
            return Collections.emptyList();
        }
    }

    public Collection<? extends AttributeTypeInfo> getItems() {
        this.table.processInputs();
        return this.table.getItems();
    }

    private String composeDetailsText(AttributeTypeInfo attributeTypeInfo) {
        StringBuilder labelText = new StringBuilder();
        if (!attributeTypeInfo.getName().equals(attributeTypeInfo.getSource())) {
            labelText.append(new StringResourceModel("AttributeTypeInfoEditPanel.source").getString()).append(": ").append(attributeTypeInfo.getSource()).append("\n");
        }
        if (attributeTypeInfo.isNillable()) {
            labelText.append(new StringResourceModel("AttributeTypeInfoEditPanel.nillable").getString()).append(": true").append("\n");
        }
        if (attributeTypeInfo.getOptions() != null && !attributeTypeInfo.getOptions().isEmpty()) {
            labelText.append(new StringResourceModel("AttributeTypeInfoEditPanel.restrictionType.options").getString()).append(": ");
            Object collect = attributeTypeInfo.getOptions().stream().map(String::valueOf).collect(Collectors.joining(", "));
            if (((String)collect).length() > 75) {
                collect = ((String)collect).substring(0, 75) + "...";
            }
            labelText.append((String)collect).append("\n");
        }
        if (attributeTypeInfo.getRange() != null) {
            NumberRange range = attributeTypeInfo.getRange().castTo(attributeTypeInfo.getBinding());
            labelText.append(new StringResourceModel("AttributeTypeInfoEditPanel.restrictionType.range").getString()).append(": ").append(range).append("\n");
        }
        return labelText.toString();
    }

    private void openEditAttributeDialog(AjaxRequestTarget target, final IModel<AttributeTypeInfo> itemModel) {
        this.editDialog.setTitle((IModel<String>)new StringResourceModel("editAttribute"));
        this.editDialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){

            @Override
            protected Component getContents(String id) {
                return new AttributeTypeInfoEditPanel(id, (IModel<AttributeTypeInfo>)itemModel);
            }

            @Override
            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                AttributeTypeInfoEditPanel panel = (AttributeTypeInfoEditPanel)contents;
                panel.finalizeAttributeValues();
                return true;
            }

            @Override
            public void onClose(AjaxRequestTarget target) {
                target.add(new Component[]{AttributeTypeInfoEditor.this.table});
            }
        });
    }

    private class AddAttributeLink
    extends AjaxLink<LayerInfo> {
        public AddAttributeLink() {
            super("addAttribute");
        }

        public void onClick(AjaxRequestTarget target) {
            final AttributeTypeInfo newAttribute = GeoServerApplication.get().getCatalog().getFactory().createAttribute();
            AttributeTypeInfoEditor.this.editDialog.setTitle((IModel<String>)new StringResourceModel("addAttribute"));
            AttributeTypeInfoEditor.this.editDialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){

                @Override
                protected Component getContents(String id) {
                    return new AttributeTypeInfoEditPanel(id, (IModel<AttributeTypeInfo>)new Model((Serializable)newAttribute));
                }

                @Override
                protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                    AttributeTypeInfoEditPanel panel = (AttributeTypeInfoEditPanel)contents;
                    panel.finalizeAttributeValues();
                    AttributeTypeInfoEditor.this.table.getItems().add(newAttribute);
                    return true;
                }

                @Override
                public void onClose(AjaxRequestTarget target) {
                    target.add(new Component[]{AttributeTypeInfoEditor.this.table});
                }
            });
        }
    }

    private class ResetLink
    extends AjaxLink<LayerInfo> {
        public ResetLink() {
            super("resetAttributes");
        }

        public void onClick(AjaxRequestTarget target) {
            AttributeTypeInfoEditor.this.table.getItems().clear();
            FeatureTypeInfo typeInfo = (FeatureTypeInfo)AttributeTypeInfoEditor.this.getDefaultModelObject();
            AttributeTypeInfoEditor.this.table.getItems().addAll(AttributeTypeInfoEditor.loadNativeAttributes(typeInfo, AttributeTypeInfoEditor.this.parent));
            target.add(new Component[]{AttributeTypeInfoEditor.this.parent});
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            AjaxCallListener ajaxCallListener = new AjaxCallListener();
            String message = new ParamResourceModel("confirmReset", (Component)this, new Object[0]).getString();
            ajaxCallListener.onPrecondition((CharSequence)("return confirm('" + message + "');"));
            attributes.getAjaxCallListeners().add(ajaxCallListener);
        }
    }

    private class EditorTable
    extends ReorderableTablePanel<AttributeTypeInfo> {
        private final Component targetComponent;

        public EditorTable(List<AttributeTypeInfo> attributes, Component targetComponent) {
            super("table", AttributeTypeInfo.class, attributes, propertiesModel);
            this.targetComponent = targetComponent;
        }

        @Override
        protected Component getComponentForProperty(String id, final IModel<AttributeTypeInfo> itemModel, GeoServerDataProvider.Property<AttributeTypeInfo> property) {
            IModel<?> model = property.getModel(itemModel);
            if (property == NAME) {
                Fragment f = new Fragment(id, "name", this.getParent());
                Label name = new Label("name", model);
                f.add(new Component[]{name});
                return f;
            }
            if (property == BINDING) {
                Fragment f = new Fragment(id, "type", this.getParent());
                ClassLabel type = new ClassLabel(model);
                f.add(new Component[]{type});
                return f;
            }
            if (property == DESCRIPTION) {
                Fragment f = new Fragment(id, "description", this.getParent());
                Label description = new Label("description", model){

                    public <C> IConverter<C> getConverter(Class<C> type) {
                        return new InternationalStringConverter();
                    }
                };
                f.add(new Component[]{description});
                return f;
            }
            if (property == DETAILS) {
                return new MultiLineLabel(id, (IModel)new LoadableDetachableModel<String>(){

                    public String load() {
                        return AttributeTypeInfoEditor.this.composeDetailsText((AttributeTypeInfo)itemModel.getObject());
                    }
                });
            }
            if (property == EDIT) {
                PackageResourceReference icon = new PackageResourceReference(((Object)((Object)this)).getClass(), "../../img/icons/silk/pencil.png");
                return new ImageAjaxLink<Object>(id, icon){

                    @Override
                    protected void onClick(AjaxRequestTarget target) {
                        AttributeTypeInfoEditor.this.openEditAttributeDialog(target, (IModel<AttributeTypeInfo>)itemModel);
                    }
                };
            }
            if (property == REMOVE) {
                final AttributeTypeInfo entry = (AttributeTypeInfo)itemModel.getObject();
                PackageResourceReference icon = new PackageResourceReference(((Object)((Object)this)).getClass(), "../../img/icons/silk/delete.png");
                return new ImageAjaxLink<Object>(id, icon){

                    @Override
                    protected void onClick(AjaxRequestTarget target) {
                        EditorTable.this.getItems().remove(entry);
                        target.add(new Component[]{EditorTable.this.targetComponent});
                    }
                };
            }
            return null;
        }
    }
}

