/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.FormComponentFeedbackBorder;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.DataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DataLinkInfoImpl;

public class DataLinkEditor
extends Panel {
    private ListView<DataLinkInfo> links;
    private Label noData;
    private WebMarkupContainer table;

    public DataLinkEditor(String id, final IModel<ResourceInfo> resourceModel) {
        super(id, resourceModel);
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.table = new WebMarkupContainer("table");
        this.table.setOutputMarkupId(true);
        container.add(new Component[]{this.table});
        this.links = new ListView<DataLinkInfo>("links", (IModel)new PropertyModel(resourceModel, "dataLinks")){

            protected void populateItem(ListItem<DataLinkInfo> item) {
                item.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(item.getIndex() % 2 == 0 ? "even" : "odd")))});
                FormComponentFeedbackBorder urlBorder = new FormComponentFeedbackBorder("urlBorder");
                item.add(new Component[]{urlBorder});
                TextField format = new TextField("format", (IModel)new PropertyModel((Object)item.getModel(), "type"));
                format.setRequired(true);
                item.add(new Component[]{format});
                TextField url = new TextField("dataLinkURL", (IModel)new PropertyModel((Object)item.getModel(), "content"));
                url.add((IValidator)new UrlValidator());
                url.setRequired(true);
                urlBorder.add(new Component[]{url});
                AjaxLink<DataLinkInfo> link = new AjaxLink<DataLinkInfo>("removeLink", item.getModel()){

                    public void onClick(AjaxRequestTarget target) {
                        ResourceInfo ri = (ResourceInfo)resourceModel.getObject();
                        ri.getDataLinks().remove(this.getModelObject());
                        DataLinkEditor.this.updateLinksVisibility();
                        target.add(new Component[]{container});
                    }
                };
                item.add(new Component[]{link});
            }
        };
        this.links.setReuseItems(true);
        this.table.add(new Component[]{this.links});
        this.noData = new Label("noLinks", (IModel)new ResourceModel("noDataLinksSoFar"));
        container.add(new Component[]{this.noData});
        this.updateLinksVisibility();
        AjaxButton button = new AjaxButton("addlink"){

            protected void onSubmit(AjaxRequestTarget target) {
                ResourceInfo ri = (ResourceInfo)resourceModel.getObject();
                DataLinkInfo link = ri.getCatalog().getFactory().createDataLink();
                link.setType("text/plain");
                ri.getDataLinks().add(link);
                DataLinkEditor.this.updateLinksVisibility();
                target.add(new Component[]{container});
            }
        };
        this.add(new Component[]{button});
    }

    private void updateLinksVisibility() {
        ResourceInfo ri = (ResourceInfo)this.getDefaultModelObject();
        boolean anyLink = !ri.getDataLinks().isEmpty();
        this.table.setVisible(anyLink);
        this.noData.setVisible(!anyLink);
    }

    public static class UrlValidator
    implements IValidator<String> {
        public void validate(IValidatable<String> validatable) {
            String url = (String)validatable.getValue();
            if (url != null) {
                try {
                    DataLinkInfoImpl.validate((String)url);
                }
                catch (IllegalArgumentException ex) {
                    ValidationError err = new ValidationError("invalidDataLinkURL").addKey("invalidDataLinkURL").setVariable("url", (Object)url);
                    validatable.error((IValidationError)err);
                }
            }
        }
    }
}

