/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.AcceptableRange;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.ows.kvp.ElevationKvpParser;
import org.geoserver.ows.kvp.TimeParser;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.data.resource.PeriodEditor;
import org.geoserver.web.wicket.EnumChoiceRenderer;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.util.DateRange;
import org.geotools.util.DateTimeParser;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;

public abstract class DimensionEditorBase<T extends DimensionInfo>
extends FormComponentPanel<T> {
    static final Logger LOGGER = Logging.getLogger(DimensionEditorBase.class);
    List<DimensionPresentation> presentationModes;
    List<DimensionDefaultValueSetting.Strategy> defaultValueStrategies;
    private CheckBox enabled;
    private DropDownChoice<String> attribute;
    private DropDownChoice<String> endAttribute;
    private DropDownChoice<DimensionPresentation> presentation;
    private DropDownChoice<DimensionDefaultValueSetting.Strategy> defaultValueStrategy;
    private TextField<String> referenceValue;
    private TextField<String> units;
    private TextField<String> unitSymbol;
    private PeriodEditor resTime;
    private TextField<BigDecimal> resElevation;
    private final CheckBox nearestMatch;
    private final CheckBox rawNearestMatch;
    private final TextField<String> acceptableInterval;
    private final DropDownChoice<DimensionInfo.NearestFailBehavior> nearestFailBehavior;
    boolean time;
    private Class<?> originalType;
    private ResourceInfo resource;
    private final WebMarkupContainer resolutions;
    private final WebMarkupContainer unitsContainer;
    private TextField<String> startField;
    private TextField<String> endField;

    public DimensionEditorBase(String id, IModel<T> model, ResourceInfo resource, Class<?> type) {
        this(id, model, resource, type, false, false);
    }

    public DimensionEditorBase(String id, IModel<T> model, ResourceInfo resource, Class<?> type, boolean editNearestMatch, boolean editRawNearestMatch) {
        super(id, model);
        this.originalType = type;
        this.resource = resource;
        final WebMarkupContainer configsContainer = new WebMarkupContainer("configContainer");
        configsContainer.setOutputMarkupId(true);
        this.add(new Component[]{configsContainer});
        final WebMarkupContainer configs = new WebMarkupContainer("configs");
        configs.setOutputMarkupId(true);
        configs.setVisible(((DimensionInfo)this.getModelObject()).isEnabled());
        configsContainer.add(new Component[]{configs});
        PropertyModel enabledModel = new PropertyModel(model, "enabled");
        this.enabled = new CheckBox("enabled", (IModel)enabledModel);
        this.add(new Component[]{this.enabled});
        this.enabled.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("click"){

            protected void onUpdate(AjaxRequestTarget target) {
                Boolean visile = (Boolean)DimensionEditorBase.this.enabled.getModelObject();
                configs.setVisible(visile.booleanValue());
                target.add(new Component[]{configsContainer});
            }
        }});
        Label noAttributeMessage = new Label("noAttributeMsg", (Serializable)((Object)""));
        this.add(new Component[]{noAttributeMessage});
        WebMarkupContainer attContainer = new WebMarkupContainer("attributeContainer");
        configs.add(new Component[]{attContainer});
        List<String> attributes = this.getAttributesOfType(resource, type);
        this.attribute = new DropDownChoice("attribute", (IModel)new PropertyModel(model, "attribute"), attributes);
        this.attribute.setOutputMarkupId(true);
        this.attribute.setRequired(true);
        attContainer.add(new Component[]{this.attribute});
        this.attribute.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                DimensionEditorBase.this.presentation.setChoices(DimensionEditorBase.this.getPresentationModes());
                DimensionEditorBase.this.updateTypeDependentStates();
                target.add(new Component[]{DimensionEditorBase.this.resolutions});
                target.add(new Component[]{DimensionEditorBase.this.presentation});
            }
        }});
        ArrayList<String> endAttributes = new ArrayList<String>(attributes);
        this.initializeEndAttributesValues(endAttributes);
        this.endAttribute = new DropDownChoice("endAttribute", (IModel)new PropertyModel(model, "endAttribute"), endAttributes);
        this.endAttribute.setOutputMarkupId(true);
        this.endAttribute.setRequired(false);
        attContainer.add(new Component[]{this.endAttribute});
        if (resource instanceof FeatureTypeInfo) {
            if (attributes.isEmpty()) {
                this.disableDimension(this.getAttributeType(), configs, noAttributeMessage);
            } else {
                noAttributeMessage.setVisible(false);
            }
        } else if (resource instanceof CoverageInfo) {
            CoverageInfo info = (CoverageInfo)resource;
            attContainer.setVisible(false);
            this.attribute.setRequired(false);
            try {
                String time;
                GridCoverageReader reader = info.getGridCoverageReader(null, null);
                if (Number.class.isAssignableFrom(this.getAttributeType())) {
                    String elev = reader.getMetadataValue("HAS_ELEVATION_DOMAIN");
                    if (!Boolean.parseBoolean(elev)) {
                        this.disableDimension(this.getAttributeType(), configs, noAttributeMessage);
                    }
                } else if (Date.class.isAssignableFrom(this.getAttributeType()) && !Boolean.parseBoolean(time = reader.getMetadataValue("HAS_TIME_DOMAIN"))) {
                    this.disableDimension(this.getAttributeType(), configs, noAttributeMessage);
                }
            }
            catch (IOException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        this.unitsContainer = new WebMarkupContainer("unitsContainer");
        configs.add(new Component[]{this.unitsContainer});
        PropertyModel uModel = new PropertyModel(model, "units");
        this.units = new TextField("units", (IModel)uModel);
        this.unitsContainer.add(new Component[]{this.units});
        PropertyModel usModel = new PropertyModel(model, "unitSymbol");
        this.unitSymbol = new TextField("unitSymbol", (IModel)usModel);
        this.unitsContainer.add(new Component[]{this.unitSymbol});
        if ("elevation".equals(id) && uModel.getObject() == null) {
            uModel.setObject((Object)"EPSG:5030");
            usModel.setObject((Object)"m");
        }
        final WebMarkupContainer resContainer = new WebMarkupContainer("resolutionContainer");
        resContainer.setOutputMarkupId(true);
        configs.add(new Component[]{resContainer});
        this.resolutions = new WebMarkupContainer("resolutions");
        this.resolutions.setVisible(((DimensionInfo)model.getObject()).getPresentation() == DimensionPresentation.DISCRETE_INTERVAL);
        this.resolutions.setOutputMarkupId(true);
        resContainer.add(new Component[]{this.resolutions});
        this.presentationModes = this.getPresentationModes();
        this.presentation = new DropDownChoice("presentation", (IModel)new PropertyModel(model, "presentation"), this.presentationModes, (IChoiceRenderer)new PresentationModeRenderer());
        configs.add(new Component[]{this.presentation});
        this.presentation.setOutputMarkupId(true);
        this.presentation.setRequired(true);
        this.presentation.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                boolean visible = DimensionEditorBase.this.presentation.getModelObject() == DimensionPresentation.DISCRETE_INTERVAL;
                DimensionEditorBase.this.resolutions.setVisible(visible);
                target.add(new Component[]{resContainer});
                boolean listSelected = DimensionEditorBase.this.presentation.getModelObject() == DimensionPresentation.LIST;
                String containerVisible = listSelected ? "hidden" : "";
                DimensionEditorBase.this.startField.getParent().add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)containerVisible))});
                if (listSelected) {
                    DimensionEditorBase.this.startField.setModelValue(new String[0]);
                    DimensionEditorBase.this.startField.setRequired(false);
                    DimensionEditorBase.this.endField.setModelValue(new String[0]);
                    DimensionEditorBase.this.endField.setRequired(false);
                }
                DimensionEditorBase.this.startField.setVisible(!listSelected);
                DimensionEditorBase.this.endField.setVisible(!listSelected);
                target.add(new Component[]{DimensionEditorBase.this.startField.getParent()});
            }
        }});
        PropertyModel rmodel = new PropertyModel(model, "resolution");
        this.resTime = new PeriodEditor("resTime", (IModel<BigDecimal>)rmodel);
        this.resolutions.add(new Component[]{this.resTime});
        this.resElevation = new TextField("resElevation", (IModel)rmodel);
        this.resolutions.add(new Component[]{this.resElevation});
        this.updateTypeDependentStates();
        DimensionDefaultValueSetting defValueSetting = ((DimensionInfo)model.getObject()).getDefaultValue();
        if (defValueSetting == null) {
            defValueSetting = new DimensionDefaultValueSetting();
            ((DimensionInfo)model.getObject()).setDefaultValue(defValueSetting);
        }
        final WebMarkupContainer defValueContainer = new WebMarkupContainer("defaultValueContainer");
        defValueContainer.setOutputMarkupId(true);
        configs.add(new Component[]{defValueContainer});
        final WebMarkupContainer referenceValueContainer = new WebMarkupContainer("referenceValueContainer");
        referenceValueContainer.setOutputMarkupId(true);
        referenceValueContainer.setVisible(defValueSetting.getStrategyType() == DimensionDefaultValueSetting.Strategy.FIXED || defValueSetting.getStrategyType() == DimensionDefaultValueSetting.Strategy.NEAREST);
        defValueContainer.add(new Component[]{referenceValueContainer});
        this.defaultValueStrategies = new ArrayList<DimensionDefaultValueSetting.Strategy>(Arrays.asList(DimensionDefaultValueSetting.Strategy.values()));
        PropertyModel strategyModel = new PropertyModel((Object)((DimensionInfo)model.getObject()).getDefaultValue(), "strategy");
        this.defaultValueStrategy = new DropDownChoice("strategy", (IModel)strategyModel, this.defaultValueStrategies, (IChoiceRenderer)new DefaultValueStrategyRenderer());
        configs.add(new Component[]{this.defaultValueStrategy});
        this.defaultValueStrategy.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                boolean visible = DimensionEditorBase.this.defaultValueStrategy.getModelObject() == DimensionDefaultValueSetting.Strategy.FIXED || DimensionEditorBase.this.defaultValueStrategy.getModelObject() == DimensionDefaultValueSetting.Strategy.NEAREST;
                referenceValueContainer.setVisible(visible);
                target.add(new Component[]{defValueContainer});
            }
        }});
        defValueContainer.add(new Component[]{this.defaultValueStrategy});
        final Label refValueValidationMessage = new Label("refValueValidationMsg", (Serializable)((Object)""));
        refValueValidationMessage.setVisible(false);
        PropertyModel refValueModel = new PropertyModel((Object)((DimensionInfo)model.getObject()).getDefaultValue(), "referenceValue");
        this.referenceValue = new TextField("referenceValue", (IModel)refValueModel);
        this.referenceValue.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                refValueValidationMessage.setDefaultModelObject(null);
                refValueValidationMessage.setVisible(false);
                target.add(new Component[]{referenceValueContainer});
            }

            protected void onError(AjaxRequestTarget target, RuntimeException e) {
                super.onError(target, e);
                if (DimensionEditorBase.this.referenceValue.hasErrorMessage()) {
                    refValueValidationMessage.setDefaultModelObject((Object)DimensionEditorBase.this.referenceValue.getFeedbackMessages().first());
                    refValueValidationMessage.setVisible(true);
                }
                target.add(new Component[]{referenceValueContainer});
            }
        }});
        this.referenceValue.add((IValidator)new ReferenceValueValidator(id, (IModel<DimensionDefaultValueSetting.Strategy>)strategyModel));
        referenceValueContainer.add(new Component[]{this.referenceValue});
        referenceValueContainer.add(new Component[]{refValueValidationMessage});
        if ("time".equals(id) && refValueModel.getObject() == null && strategyModel.getObject() == DimensionDefaultValueSetting.Strategy.NEAREST) {
            refValueModel.setObject((Object)DimensionDefaultValueSetting.TIME_CURRENT);
        }
        WebMarkupContainer nearestMatchContainer = new WebMarkupContainer("nearestMatchContainer");
        configs.add(new Component[]{nearestMatchContainer});
        nearestMatchContainer.setVisible(editNearestMatch);
        this.nearestMatch = new CheckBox("nearestMatchEnabled", (IModel)new PropertyModel(model, "nearestMatchEnabled"));
        nearestMatchContainer.add(new Component[]{this.nearestMatch});
        boolean isNearestMatchEnabled = ((DimensionInfo)model.getObject()).isNearestMatchEnabled();
        WebMarkupContainer rawNearestMatchContainer = new WebMarkupContainer("rawNearestMatch");
        this.rawNearestMatch = new CheckBox("rawNearestMatchEnabled", (IModel)new PropertyModel(model, "rawNearestMatchEnabled"));
        rawNearestMatchContainer.add(new Component[]{this.rawNearestMatch});
        nearestMatchContainer.add(new Component[]{rawNearestMatchContainer});
        final WebMarkupContainer acceptableIntervalEditor = new WebMarkupContainer("acceptableIntervalEditor");
        acceptableIntervalEditor.setVisible(isNearestMatchEnabled);
        final WebMarkupContainer failedMatchBehaviorContainer = new WebMarkupContainer("failedMatchBehaviorContainer");
        failedMatchBehaviorContainer.setVisible(isNearestMatchEnabled);
        nearestMatchContainer.add(new Component[]{failedMatchBehaviorContainer});
        ResourceInfo resourceImpl = (ResourceInfo)ModificationProxy.unwrap((Object)resource);
        final boolean rawNearestIsSupported = resourceImpl instanceof CoverageInfo;
        if (!rawNearestIsSupported) {
            rawNearestMatchContainer.setVisible(rawNearestIsSupported);
            this.rawNearestMatch.setModelObject((Object)false);
        }
        nearestMatchContainer.add(new Component[]{acceptableIntervalEditor});
        this.nearestMatch.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("click"){

            protected void onUpdate(AjaxRequestTarget target) {
                DimensionEditorBase.this.updateAccetptedInterval(target, acceptableIntervalEditor, failedMatchBehaviorContainer, configsContainer, rawNearestIsSupported);
            }
        }});
        this.rawNearestMatch.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("click"){

            protected void onUpdate(AjaxRequestTarget target) {
                DimensionEditorBase.this.updateAccetptedInterval(target, acceptableIntervalEditor, failedMatchBehaviorContainer, configsContainer, rawNearestIsSupported);
            }
        }});
        this.acceptableInterval = new TextField("acceptableInterval", (IModel)new PropertyModel(model, "acceptableInterval"));
        acceptableIntervalEditor.add(new Component[]{this.acceptableInterval});
        this.acceptableInterval.add((IValidator & Serializable)validatable -> {
            try {
                AcceptableRange.getAcceptableRange((String)((String)validatable.getValue()), this.getAttributeType());
            }
            catch (Exception e) {
                String messageKey = "invalidAcceptableInterval";
                validatable.error((IValidationError)new ValidationError(messageKey).addKey(messageKey).setVariable("actual", validatable.getValue()));
            }
        });
        List<DimensionInfo.NearestFailBehavior> nearestFailBehaviorList = Arrays.asList(DimensionInfo.NearestFailBehavior.IGNORE, DimensionInfo.NearestFailBehavior.EXCEPTION);
        this.nearestFailBehavior = new DropDownChoice("nearestFailBehavior", (IModel)new PropertyModel(model, "nearestFailBehavior"), nearestFailBehaviorList);
        this.nearestFailBehavior.setChoiceRenderer((IChoiceRenderer)new EnumChoiceRenderer((Component)this.nearestFailBehavior));
        this.nearestFailBehavior.setNullValid(true);
        failedMatchBehaviorContainer.add(new Component[]{this.nearestFailBehavior});
        final WebMarkupContainer startEndContainer = new WebMarkupContainer("startEndContainer");
        startEndContainer.setOutputMarkupId(true);
        String containerVisibility = this.presentation.getModelObject() == DimensionPresentation.LIST ? "hidden" : "";
        startEndContainer.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)containerVisibility))});
        configs.add(new Component[]{startEndContainer});
        PropertyModel sfModel = new PropertyModel(model, "startValue");
        PropertyModel efModel = new PropertyModel(model, "endValue");
        this.startField = new TextField("startValue", (IModel)sfModel);
        this.endField = new TextField("endValue", (IModel)efModel);
        this.startField.setRequired(!this.endField.getValue().isEmpty());
        this.endField.setRequired(!this.startField.getValue().isEmpty());
        final Label startValueValidationMessage = new Label("startValueValidationMsg", (Serializable)((Object)""));
        startValueValidationMessage.setVisible(false);
        final Label endValueValidationMessage = new Label("endValueValidationMsg", (Serializable)((Object)""));
        endValueValidationMessage.setVisible(false);
        this.startField.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                boolean isEmpty = DimensionEditorBase.this.startField.getValue().isEmpty();
                DimensionEditorBase.this.endField.setRequired(!isEmpty);
                startValueValidationMessage.setDefaultModelObject(null);
                startValueValidationMessage.setVisible(false);
                if (isEmpty) {
                    DimensionEditorBase.this.endField.getFeedbackMessages().clear();
                    endValueValidationMessage.setDefaultModelObject(null);
                    endValueValidationMessage.setVisible(false);
                }
                target.add(new Component[]{startEndContainer});
            }

            protected void onError(AjaxRequestTarget target, RuntimeException e) {
                if (DimensionEditorBase.this.startField.getValue().isEmpty() && DimensionEditorBase.this.endField.getValue().isEmpty()) {
                    DimensionEditorBase.this.startField.setRequired(false);
                    DimensionEditorBase.this.endField.setRequired(false);
                    DimensionEditorBase.this.startField.getFeedbackMessages().clear();
                    DimensionEditorBase.this.endField.getFeedbackMessages().clear();
                } else {
                    super.onError(target, e);
                    if (DimensionEditorBase.this.startField.hasErrorMessage()) {
                        startValueValidationMessage.setDefaultModelObject((Object)DimensionEditorBase.this.startField.getFeedbackMessages().first());
                        startValueValidationMessage.setVisible(true);
                    }
                }
                target.add(new Component[]{startEndContainer});
            }
        }});
        this.startField.add((IValidator)new StartEndValueValidator(id));
        startEndContainer.add(new Component[]{this.startField});
        startEndContainer.add(new Component[]{startValueValidationMessage});
        this.endField.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                DimensionEditorBase.this.startField.setRequired(!DimensionEditorBase.this.endField.getValue().isEmpty());
                endValueValidationMessage.setDefaultModelObject(null);
                endValueValidationMessage.setVisible(false);
                target.add(new Component[]{startEndContainer});
            }

            protected void onError(AjaxRequestTarget target, RuntimeException e) {
                if (DimensionEditorBase.this.startField.getValue().isEmpty() && DimensionEditorBase.this.endField.getValue().isEmpty()) {
                    DimensionEditorBase.this.startField.setRequired(false);
                    DimensionEditorBase.this.endField.setRequired(false);
                    DimensionEditorBase.this.startField.getFeedbackMessages().clear();
                    DimensionEditorBase.this.endField.getFeedbackMessages().clear();
                } else {
                    super.onError(target, e);
                    if (DimensionEditorBase.this.endField.hasErrorMessage()) {
                        endValueValidationMessage.setDefaultModelObject((Object)DimensionEditorBase.this.endField.getFeedbackMessages().first());
                        endValueValidationMessage.setVisible(true);
                    }
                }
                target.add(new Component[]{startEndContainer});
            }
        }});
        this.endField.add((IValidator)new StartEndValueValidator(id));
        startEndContainer.add(new Component[]{this.endField});
        startEndContainer.add(new Component[]{endValueValidationMessage});
        this.initComponents();
    }

    protected void updateAccetptedInterval(AjaxRequestTarget target, WebMarkupContainer acceptableIntervalEditor, WebMarkupContainer failedMatchBehaviorContainer, WebMarkupContainer configsContainer, boolean rawNearestIsSupported) {
        Boolean nearestEnabled = (Boolean)this.nearestMatch.getModelObject();
        Boolean rawNearestEnabled = rawNearestIsSupported && (Boolean)this.rawNearestMatch.getModelObject() != false;
        boolean visible = Boolean.TRUE.equals(nearestEnabled != false || rawNearestEnabled != false);
        acceptableIntervalEditor.setVisible(visible);
        failedMatchBehaviorContainer.setVisible(visible);
        target.add(new Component[]{configsContainer});
    }

    protected void updateTypeDependentStates() {
        this.time = Date.class.isAssignableFrom(this.getAttributeType());
        if (this.time) {
            this.resElevation.setVisible(false);
            this.resElevation.setRequired(false);
            this.resTime.setVisible(true);
            this.resTime.setRequired(true);
            this.unitsContainer.setVisible(false);
        } else if (String.class.isAssignableFrom(this.getAttributeType()) || Boolean.class.isAssignableFrom(this.getAttributeType())) {
            this.resTime.setVisible(false);
            this.resTime.setRequired(false);
            this.resElevation.setVisible(false);
            this.resElevation.setRequired(false);
        } else {
            this.resTime.setVisible(false);
            this.resTime.setRequired(false);
            this.resElevation.setRequired(true);
            this.resElevation.setVisible(true);
        }
    }

    protected void initializeEndAttributesValues(List<String> endAttributes) {
        endAttributes.add(0, "-");
    }

    public void disablePresentationMode(DimensionPresentation mode) {
        this.presentationModes.remove(mode);
        if (this.presentationModes.size() <= 1) {
            this.presentation.setModelObject((Object)this.presentationModes.get(0));
            this.presentation.setEnabled(false);
        }
    }

    private void disableDimension(Class<?> type, WebMarkupContainer configs, Label noAttributeMessage) {
        this.enabled.setEnabled(false);
        this.enabled.setModelObject((Object)false);
        configs.setVisible(false);
        ParamResourceModel typeName = new ParamResourceModel("AttributeType." + type.getSimpleName(), null, new Object[0]);
        ParamResourceModel error = new ParamResourceModel("missingAttribute", (Component)this, typeName.getString());
        noAttributeMessage.setDefaultModelObject((Object)error.getString());
    }

    public boolean processChildren() {
        return true;
    }

    public void convertInput() {
        if (this.resetDimensionDataOnDisabled() && !((Boolean)this.enabled.getModelObject()).booleanValue()) {
            this.setConvertedInput(this.infoOf());
        } else {
            this.convertDimensionInput();
        }
    }

    protected boolean resetDimensionDataOnDisabled() {
        return true;
    }

    protected void convertDimensionInput() {
        DimensionInfo info = this.infoOf((DimensionInfo)this.getModelObject());
        info.setEnabled(((Boolean)this.enabled.getModelObject()).booleanValue());
        this.attribute.processInput();
        this.endAttribute.processInput();
        info.setAttribute((String)this.attribute.getModelObject());
        String endAttributeValue = (String)this.endAttribute.getModelObject();
        if ("-".equals(endAttributeValue)) {
            endAttributeValue = null;
        }
        info.setEndAttribute(endAttributeValue);
        this.units.processInput();
        String unitsValue = (String)this.units.getModelObject();
        if ("time".equals(this.getId())) {
            unitsValue = "ISO8601";
        } else if (unitsValue == null) {
            unitsValue = "";
        }
        info.setUnits(unitsValue);
        this.unitSymbol.processInput();
        info.setUnitSymbol((String)this.unitSymbol.getModelObject());
        info.setPresentation((DimensionPresentation)this.presentation.getModelObject());
        if (info.getPresentation() == DimensionPresentation.DISCRETE_INTERVAL) {
            if (this.time) {
                this.resTime.processInput();
                info.setResolution((BigDecimal)this.resTime.getModelObject());
            } else {
                this.resElevation.processInput();
                info.setResolution((BigDecimal)this.resElevation.getModelObject());
            }
        }
        DimensionDefaultValueSetting defValueSetting = new DimensionDefaultValueSetting();
        this.defaultValueStrategy.processInput();
        defValueSetting.setStrategyType((DimensionDefaultValueSetting.Strategy)this.defaultValueStrategy.getModelObject());
        if (defValueSetting.getStrategyType() == DimensionDefaultValueSetting.Strategy.FIXED || defValueSetting.getStrategyType() == DimensionDefaultValueSetting.Strategy.NEAREST) {
            this.referenceValue.processInput();
            if (this.referenceValue.hasErrorMessage()) {
                LOGGER.log(Level.SEVERE, "About to accept erroneous value " + (String)this.referenceValue.getModelObject());
            }
            defValueSetting.setReferenceValue((String)this.referenceValue.getModelObject());
        }
        if (defValueSetting.getStrategyType() != DimensionDefaultValueSetting.Strategy.BUILTIN) {
            info.setDefaultValue(defValueSetting);
        } else {
            info.setDefaultValue(null);
        }
        this.nearestMatch.processInput();
        this.rawNearestMatch.processInput();
        this.acceptableInterval.processInput();
        this.nearestFailBehavior.processInput();
        if (this.nearestMatch.isVisible() && ((Boolean)this.nearestMatch.getModelObject()).booleanValue()) {
            info.setNearestMatchEnabled(true);
            info.setAcceptableInterval((String)this.acceptableInterval.getModelObject());
            info.setNearestFailBehavior((DimensionInfo.NearestFailBehavior)this.nearestFailBehavior.getModelObject());
        } else {
            info.setNearestMatchEnabled(false);
            info.setAcceptableInterval(null);
        }
        if (this.rawNearestMatch.isVisible() && ((Boolean)this.rawNearestMatch.getModelObject()).booleanValue()) {
            info.setRawNearestMatchEnabled(true);
        } else {
            info.setRawNearestMatchEnabled(false);
        }
        info.setStartValue(this.startField.getValue());
        info.setEndValue(this.endField.getValue());
        this.startField.processInput();
        this.endField.processInput();
        this.convertInputExtensions(info);
        this.setConvertedInput(info);
    }

    protected void convertInputExtensions(T info) {
    }

    List<String> getAttributesOfType(ResourceInfo resource, Class<?> type) {
        ArrayList<String> result = new ArrayList<String>();
        if (resource instanceof FeatureTypeInfo) {
            FeatureTypeInfo ft = (FeatureTypeInfo)resource;
            try {
                for (PropertyDescriptor pd : ft.getFeatureType().getDescriptors()) {
                    if (!type.isAssignableFrom(pd.getType().getBinding())) continue;
                    result.add(pd.getName().getLocalPart());
                }
            }
            catch (IOException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        return result;
    }

    Class<?> getAttributeType(ResourceInfo resource, String name) {
        if (resource instanceof FeatureTypeInfo) {
            FeatureTypeInfo ft = (FeatureTypeInfo)resource;
            try {
                PropertyDescriptor descriptor = ft.getFeatureType().getDescriptor(name);
                if (descriptor != null) {
                    return descriptor.getType().getBinding();
                }
            }
            catch (IOException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        return Serializable.class;
    }

    protected Class<?> getAttributeType() {
        if (Serializable.class.equals(this.originalType)) {
            if (this.attribute == null) {
                DimensionInfo info = (DimensionInfo)this.getDefaultModelObject();
                if (StringUtils.isNotBlank((CharSequence)info.getAttribute())) {
                    return this.getAttributeType(this.resource, info.getAttribute());
                }
            } else {
                return this.getAttributeType(this.resource, this.attribute.getDefaultModelObjectAsString());
            }
        }
        return this.originalType;
    }

    List<DimensionPresentation> getPresentationModes() {
        this.presentationModes = new ArrayList<DimensionPresentation>(Arrays.asList(DimensionPresentation.values()));
        if (String.class.isAssignableFrom(this.getAttributeType()) || Boolean.class.isAssignableFrom(this.getAttributeType())) {
            this.presentationModes.remove(DimensionPresentation.DISCRETE_INTERVAL);
            this.presentationModes.remove(DimensionPresentation.CONTINUOUS_INTERVAL);
        }
        return this.presentationModes;
    }

    protected abstract T infoOf();

    protected abstract T infoOf(T var1);

    protected void initComponents() {
    }

    public class PresentationModeRenderer
    extends ChoiceRenderer<DimensionPresentation> {
        public Object getDisplayValue(DimensionPresentation object) {
            return new ParamResourceModel(object.name(), (Component)DimensionEditorBase.this, new Object[0]).getString();
        }

        public String getIdValue(DimensionPresentation object, int index) {
            return String.valueOf(object.ordinal());
        }
    }

    public class DefaultValueStrategyRenderer
    extends ChoiceRenderer<DimensionDefaultValueSetting.Strategy> {
        public Object getDisplayValue(DimensionDefaultValueSetting.Strategy object) {
            return new ParamResourceModel(object.name(), (Component)DimensionEditorBase.this, new Object[0]).getString();
        }

        public String getIdValue(DimensionDefaultValueSetting.Strategy object, int index) {
            return String.valueOf(object.ordinal());
        }
    }

    public static class ReferenceValueValidator
    implements IValidator<String> {
        String dimension;
        IModel<DimensionDefaultValueSetting.Strategy> strategyModel;

        public ReferenceValueValidator(String dimensionId, IModel<DimensionDefaultValueSetting.Strategy> strategyModel) {
            this.dimension = dimensionId;
            this.strategyModel = strategyModel;
        }

        public void validate(IValidatable<String> value) {
            String stringValue = (String)value.getValue();
            if ((this.strategyModel.getObject() == DimensionDefaultValueSetting.Strategy.FIXED || this.strategyModel.getObject() == DimensionDefaultValueSetting.Strategy.NEAREST) && stringValue == null) {
                value.error((IValidationError)new ValidationError("emptyReferenceValue").addKey("emptyReferenceValue"));
            } else if (this.dimension.equals("time")) {
                if (!this.isValidTimeReference(stringValue, (DimensionDefaultValueSetting.Strategy)this.strategyModel.getObject())) {
                    String messageKey = this.strategyModel.getObject() == DimensionDefaultValueSetting.Strategy.NEAREST ? "invalidNearestTimeReferenceValue" : "invalidTimeReferenceValue";
                    value.error((IValidationError)new ValidationError(messageKey).addKey(messageKey));
                }
            } else if (this.dimension.equals("elevation") && !this.isValidElevationReference(stringValue)) {
                value.error((IValidationError)new ValidationError("invalidElevationReferenceValue").addKey("invalidElevationReferenceValue"));
            }
        }

        private boolean isValidElevationReference(String stringValue) {
            try {
                ElevationKvpParser parser = (ElevationKvpParser)GeoServerExtensions.bean(ElevationKvpParser.class);
                List values = (List)parser.parse(stringValue);
                return values.size() == 1;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Invalid elevation value " + stringValue, e);
                }
                return false;
            }
        }

        private boolean isValidTimeReference(String stringValue, DimensionDefaultValueSetting.Strategy strategy) {
            try {
                TimeParser parser = new TimeParser();
                List values = (List)parser.parse(stringValue);
                if (strategy == DimensionDefaultValueSetting.Strategy.FIXED) {
                    return values.size() == 1;
                }
                if (strategy == DimensionDefaultValueSetting.Strategy.NEAREST) {
                    return values.size() == 1 && !(values.get(0) instanceof Range);
                }
                return false;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, "Invalid time value " + stringValue, e);
                }
                return false;
            }
        }
    }

    public static class StartEndValueValidator
    implements IValidator<String> {
        String dimension;

        public StartEndValueValidator(String dimensionId) {
            this.dimension = dimensionId;
        }

        public void validate(IValidatable<String> value) {
            boolean valid = false;
            String errorKey = "invalidStartOrEndDate";
            DateTimeParser dateTimeParser = new DateTimeParser(-1, 1);
            Date date = null;
            if (this.dimension.equals("time")) {
                String timeValue = (String)value.getValue();
                try {
                    Object dateObject = ((List)dateTimeParser.parse(timeValue)).get(0);
                    if (dateObject instanceof DateRange) {
                        throw new ParseException("Invalid date: " + String.valueOf(dateObject), 0);
                    }
                    date = (Date)dateObject;
                }
                catch (ParseException e) {
                    LOGGER.log(Level.WARNING, "Failed to parse the datetime string. The value is possibly invalid", e);
                }
                if (date != null || timeValue.equalsIgnoreCase("present")) {
                    valid = true;
                }
            } else if (this.dimension.equals("elevation")) {
                String elevationValue = (String)value.getValue();
                errorKey = "invalidStartOrEndElevation";
                try {
                    Double.parseDouble(elevationValue);
                    valid = true;
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.WARNING, "Failed to parse the elevation start or end value. The value is not numeric", e);
                }
            } else if (this.dimension.equals("customVectorEditor")) {
                String customValue = (String)value.getValue();
                errorKey = "invalidStartOrEndCustom";
                try {
                    date = (Date)((List)dateTimeParser.parse(customValue)).get(0);
                }
                catch (ParseException e) {
                    LOGGER.log(Level.WARNING, "Failed to parse the custom value as a date", e);
                    try {
                        Double.parseDouble(customValue);
                        valid = true;
                    }
                    catch (NumberFormatException e2) {
                        LOGGER.log(Level.WARNING, "Failed to parse the custom start or end value. The value is not numeric", e2);
                    }
                }
                if (date != null || customValue.equalsIgnoreCase("present")) {
                    valid = true;
                }
            }
            if (!valid) {
                PropertyModel pModel = (PropertyModel)value.getModel();
                String propertyExpression = pModel.getPropertyExpression();
                String valuePrefix = propertyExpression.split("Value")[0];
                value.error((IValidationError)new ValidationError(errorKey).addKey(errorKey).setVariable("valuePrefix", (Object)StringUtils.capitalize((String)valuePrefix)));
            }
        }
    }
}

