/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geotools.util.Utilities;

public class VectorCustomDimensionEntry
implements DimensionInfo {
    private String key;
    private String formerKey;
    private DimensionInfo dimensionInfo;

    public VectorCustomDimensionEntry() {
        this.dimensionInfo = new DimensionInfoImpl();
    }

    public VectorCustomDimensionEntry(Map.Entry<String, DimensionInfo> entry) {
        Utilities.ensureArgumentNonNull((String)"entry", entry);
        Utilities.ensureArgumentNonNull((String)"entry.key", (Object)entry.getKey());
        Utilities.ensureArgumentNonNull((String)"entry.value", (Object)entry.getValue());
        this.key = entry.getKey();
        this.formerKey = entry.getKey();
        this.dimensionInfo = entry.getValue();
    }

    public VectorCustomDimensionEntry(VectorCustomDimensionEntry entry) {
        Utilities.ensureArgumentNonNull((String)"entry", (Object)entry);
        Utilities.ensureArgumentNonNull((String)"entry.dimensionInfo", (Object)entry.getDimensionInfo());
        this.dimensionInfo = new DimensionInfoImpl(entry.getDimensionInfo());
        this.key = entry.getKey();
        this.formerKey = entry.getFormerKey();
    }

    public boolean isEnabled() {
        return this.dimensionInfo.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.dimensionInfo.setEnabled(enabled);
    }

    public String getAttribute() {
        return this.dimensionInfo.getAttribute();
    }

    public void setAttribute(String attribute) {
        this.dimensionInfo.setAttribute(attribute);
    }

    public String getEndAttribute() {
        return this.dimensionInfo.getEndAttribute();
    }

    public void setEndAttribute(String attribute) {
        this.dimensionInfo.setEndAttribute(attribute);
    }

    public DimensionPresentation getPresentation() {
        return this.dimensionInfo.getPresentation();
    }

    public void setPresentation(DimensionPresentation presentation) {
        this.dimensionInfo.setPresentation(presentation);
    }

    public BigDecimal getResolution() {
        return this.dimensionInfo.getResolution();
    }

    public void setResolution(BigDecimal resolution) {
        this.dimensionInfo.setResolution(resolution);
    }

    public String getUnits() {
        return this.dimensionInfo.getUnits();
    }

    public void setUnits(String units) {
        this.dimensionInfo.setUnits(units);
    }

    public String getUnitSymbol() {
        return this.dimensionInfo.getUnitSymbol();
    }

    public void setUnitSymbol(String unitSymbol) {
        this.dimensionInfo.setUnitSymbol(unitSymbol);
    }

    public DimensionDefaultValueSetting getDefaultValue() {
        return this.dimensionInfo.getDefaultValue();
    }

    public void setDefaultValue(DimensionDefaultValueSetting defaultValue) {
        this.dimensionInfo.setDefaultValue(defaultValue);
    }

    public boolean isNearestMatchEnabled() {
        return this.dimensionInfo.isNearestMatchEnabled();
    }

    public void setNearestMatchEnabled(boolean nearestMatch) {
        this.dimensionInfo.setNearestMatchEnabled(nearestMatch);
    }

    public String getAcceptableInterval() {
        return this.dimensionInfo.getAcceptableInterval();
    }

    public void setAcceptableInterval(String acceptableInterval) {
        this.dimensionInfo.setAcceptableInterval(acceptableInterval);
    }

    public String getStartValue() {
        return this.dimensionInfo.getStartValue();
    }

    public void setStartValue(String startValue) {
        this.dimensionInfo.setStartValue(startValue);
    }

    public String getEndValue() {
        return this.dimensionInfo.getEndValue();
    }

    public void setEndValue(String endValue) {
        this.dimensionInfo.setEndValue(endValue);
    }

    public DimensionInfo.NearestFailBehavior getNearestFailBehavior() {
        return this.dimensionInfo.getNearestFailBehavior();
    }

    public void setNearestFailBehavior(DimensionInfo.NearestFailBehavior matchBehavior) {
        this.dimensionInfo.setNearestFailBehavior(matchBehavior);
    }

    public boolean isRawNearestMatchEnabled() {
        return false;
    }

    public void setRawNearestMatchEnabled(boolean rawNearestMatch) {
        this.dimensionInfo.setRawNearestMatchEnabled(false);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getFormerKey() {
        return this.formerKey;
    }

    public void setFormerKey(String formerKey) {
        this.formerKey = formerKey;
    }

    public DimensionInfo getDimensionInfo() {
        return this.dimensionInfo;
    }

    public void setDimensionInfo(DimensionInfo dimensionInfo) {
        this.dimensionInfo = dimensionInfo;
    }

    public String getKeyNoPrefixed() {
        return this.key.replaceFirst("dim_", "");
    }

    public void setKeyNoPrefixed(String key) {
        this.key = "dim_" + key;
    }

    public boolean hasModifiedKey() {
        return !Objects.equals(this.key, this.formerKey);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimensionInfo == null ? 0 : this.dimensionInfo.hashCode());
        result = 31 * result + (this.formerKey == null ? 0 : this.formerKey.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VectorCustomDimensionEntry other = (VectorCustomDimensionEntry)obj;
        if (this.dimensionInfo == null ? other.dimensionInfo != null : !this.dimensionInfo.equals(other.dimensionInfo)) {
            return false;
        }
        if (this.formerKey == null ? other.formerKey != null : !this.formerKey.equals(other.formerKey)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }
}

