/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.GeoserverAjaxSubmitLink;
import org.geoserver.web.data.store.NamespaceParamModel;
import org.geoserver.web.data.store.StoreEditPanel;
import org.geoserver.web.data.store.StoreExtensionPoints;
import org.geoserver.web.data.store.StoreNameValidator;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.data.store.panel.CheckBoxParamPanel;
import org.geoserver.web.data.store.panel.NamespacePanel;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.data.store.panel.WorkspacePanel;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.util.logging.Logging;

abstract class AbstractDataAccessPage
extends GeoServerSecuredPage {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.data.store");
    protected WorkspacePanel workspacePanel;
    protected StoreEditPanel storeEditPanel;

    protected void initUI(DataStoreInfo storeInfo) throws IllegalArgumentException {
        DataAccessFactory dsFactory;
        if (storeInfo.getWorkspace() == null) {
            throw new IllegalArgumentException("Workspace not provided");
        }
        Catalog catalog = this.getCatalog();
        ResourcePool resourcePool = catalog.getResourcePool();
        try {
            dsFactory = resourcePool.getDataStoreFactory(storeInfo);
        }
        catch (IOException e) {
            Object msg = new ResourceModel("AbstractDataAccessPage.cantGetDataStoreFactory").getObject();
            msg = (String)msg + ": " + e.getMessage();
            throw new IllegalArgumentException((String)msg);
        }
        if (dsFactory == null) {
            String msg = new ResourceModel("AbstractDataAccessPage.cantGetDataStoreFactory").getObject();
            throw new IllegalArgumentException(msg);
        }
        CompoundPropertyModel model = new CompoundPropertyModel((Object)storeInfo);
        final Form paramsForm = new Form("dataStoreForm", (IModel)model);
        this.add(new Component[]{paramsForm});
        paramsForm.add(new Component[]{new Label("storeType", (Serializable)((Object)dsFactory.getDisplayName()))});
        paramsForm.add(new Component[]{new Label("storeTypeDescription", (Serializable)((Object)dsFactory.getDescription()))});
        this.workspacePanel = new WorkspacePanel("workspacePanel", (IModel<WorkspaceInfo>)new PropertyModel((Object)model, "workspace"), (IModel<String>)new ResourceModel("workspace", "Workspace"), true);
        paramsForm.add(new Component[]{this.workspacePanel});
        TextParamPanel dataStoreNamePanel = new TextParamPanel("dataStoreNamePanel", new PropertyModel((Object)model, "name"), (IModel<String>)new ResourceModel("AbstractDataAccessPage.dataSrcName", "Data Source Name"), true, (IValidator<T>[])new IValidator[0]);
        paramsForm.add(new Component[]{dataStoreNamePanel});
        paramsForm.add(new Component[]{new TextParamPanel("dataStoreDescriptionPanel", new PropertyModel((Object)model, "description"), (IModel<String>)new ResourceModel("AbstractDataAccessPage.description", "Description"), false, (IValidator<T>[])new IValidator[0])});
        paramsForm.add(new Component[]{new CheckBoxParamPanel("dataStoreEnabledPanel", (IModel<Boolean>)new PropertyModel((Object)model, "enabled"), (IModel)new ResourceModel("enabled", "Enabled"))});
        paramsForm.add(new Component[]{new CheckBoxParamPanel("disableOnConnFailurePanel", (IModel<Boolean>)new PropertyModel((Object)model, "disableOnConnFailure"), (IModel)new ResourceModel("AbstractDataAccessPage.disableOnConnFailure", "Autodisable on connection failure"))});
        GeoServerApplication app = this.getGeoServerApplication();
        this.storeEditPanel = StoreExtensionPoints.getStoreEditPanel("parametersPanel", paramsForm, (StoreInfo)storeInfo, app);
        paramsForm.add(new Component[]{this.storeEditPanel});
        paramsForm.add(new Component[]{new FeedbackPanel("feedback")});
        String dataStoreInfoId = storeInfo.getId();
        StoreNameValidator storeNameValidator = new StoreNameValidator(this.workspacePanel.getFormComponent(), dataStoreNamePanel.getFormComponent(), dataStoreInfoId);
        paramsForm.add((IFormValidator)storeNameValidator);
        paramsForm.add(new Component[]{new BookmarkablePageLink("cancel", StorePage.class)});
        paramsForm.add(new Component[]{new AjaxSubmitLink("save", paramsForm){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{paramsForm});
            }

            protected void onSubmit(AjaxRequestTarget target) {
                try {
                    DataStoreInfo dataStore = (DataStoreInfo)this.getForm().getModelObject();
                    AbstractDataAccessPage.this.onSaveDataStore(dataStore, target, true);
                }
                catch (IllegalArgumentException e) {
                    paramsForm.error((Serializable)((Object)e.getMessage()));
                    target.add(new Component[]{paramsForm});
                }
            }
        }});
        paramsForm.add(new Component[]{this.applyLink(paramsForm)});
        this.makeNamespaceSyncUpWithWorkspace(paramsForm);
    }

    private GeoserverAjaxSubmitLink applyLink(final Form paramsForm) {
        return new GeoserverAjaxSubmitLink("apply", paramsForm, this){

            @Override
            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{paramsForm});
            }

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target) {
                try {
                    DataStoreInfo info = (DataStoreInfo)this.getForm().getModelObject();
                    AbstractDataAccessPage.this.onSaveDataStore(info, target, false);
                }
                catch (IllegalArgumentException e) {
                    paramsForm.error((Serializable)((Object)e.getMessage()));
                    target.add(new Component[]{paramsForm});
                }
            }
        };
    }

    protected abstract void onSaveDataStore(DataStoreInfo var1, AjaxRequestTarget var2, boolean var3) throws IllegalArgumentException;

    private void makeNamespaceSyncUpWithWorkspace(final Form paramsForm) {
        final DropDownChoice wsDropDown = (DropDownChoice)this.workspacePanel.getFormComponent();
        wsDropDown.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;
            private NamespaceParamModel namespaceModel;
            private NamespacePanel namespacePanel;
            private boolean namespaceLookupOccurred;

            protected void onUpdate(AjaxRequestTarget target) {
                if (!this.namespaceLookupOccurred) {
                    Component paramsPanel = AbstractDataAccessPage.this.get("dataStoreForm:parametersPanel");
                    this.namespacePanel = AbstractDataAccessPage.this.findNamespacePanel((MarkupContainer)paramsPanel);
                    if (this.namespacePanel == null) {
                        DataAccessFactory.Param[] dsParams;
                        DataAccessFactory dsFactory;
                        IModel model = paramsForm.getModel();
                        DataStoreInfo info = (DataStoreInfo)model.getObject();
                        Catalog catalog = AbstractDataAccessPage.this.getCatalog();
                        ResourcePool resourcePool = catalog.getResourcePool();
                        try {
                            dsFactory = resourcePool.getDataStoreFactory(info);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        for (DataAccessFactory.Param p : dsParams = dsFactory.getParametersInfo()) {
                            if (!"namespace".equals(p.getName())) continue;
                            PropertyModel paramsModel = new PropertyModel((Object)model, "connectionParameters");
                            this.namespaceModel = new NamespaceParamModel((IModel<Map<String, Serializable>>)paramsModel, "namespace");
                            break;
                        }
                    }
                    this.namespaceLookupOccurred = true;
                }
                WorkspaceInfo ws = (WorkspaceInfo)wsDropDown.getModelObject();
                String prefix = ws.getName();
                NamespaceInfo namespaceInfo = AbstractDataAccessPage.this.getCatalog().getNamespaceByPrefix(prefix);
                if (this.namespacePanel != null) {
                    this.namespacePanel.setDefaultModelObject(namespaceInfo);
                    target.add(new Component[]{this.namespacePanel.getFormComponent()});
                } else if (this.namespaceModel != null) {
                    this.namespaceModel.setObject(namespaceInfo);
                }
            }
        }});
    }

    private NamespacePanel findNamespacePanel(MarkupContainer c) {
        for (Component component : c) {
            MarkupContainer container;
            NamespacePanel panel;
            Component child = component;
            if (child instanceof NamespacePanel) {
                NamespacePanel panel1 = (NamespacePanel)child;
                return panel1;
            }
            if (!(child instanceof MarkupContainer) || (panel = this.findNamespacePanel(container = (MarkupContainer)child)) == null) continue;
            return panel;
        }
        return null;
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }
}

