/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.security.impl.FileSandboxEnforcer;
import org.geoserver.web.data.store.AbstractCoverageStorePage;
import org.geoserver.web.data.store.CheckExistingResourcesInWorkspaceValidator;
import org.geoserver.web.data.store.StoreConnectionFailedInformationPanel;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.api.coverage.grid.GridCoverageReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.util.factory.GeoTools;

public class CoverageStoreEditPage
extends AbstractCoverageStorePage {
    public static final String STORE_NAME = "storeName";
    public static final String WS_NAME = "wsName";
    private GeoServerDialog dialog;

    public CoverageStoreEditPage(PageParameters parameters) {
        String wsName = parameters.get(WS_NAME).toOptionalString();
        String storeName = parameters.get(STORE_NAME).toString();
        CoverageStoreInfo csi = this.getCatalog().getCoverageStoreByName(wsName, storeName);
        if (csi == null) {
            this.getSession().error((Serializable)((Object)new ParamResourceModel("CoverageStoreEditPage.notFound", (Component)this, storeName, wsName).getString()));
            this.doReturn(StorePage.class);
            return;
        }
        this.initUI(csi);
    }

    public CoverageStoreEditPage(String storeId) throws IllegalArgumentException {
        Catalog catalog = this.getCatalog();
        CoverageStoreInfo store = catalog.getCoverageStore(storeId);
        if (store == null) {
            throw new IllegalArgumentException("Cannot find coverage store " + storeId);
        }
        this.initUI(store);
    }

    public CoverageStoreEditPage(CoverageStoreInfo store) throws IllegalArgumentException {
        this.initUI(store);
    }

    @Override
    void initUI(CoverageStoreInfo store) {
        this.dialog = new GeoServerDialog("dialog");
        this.add(new Component[]{this.dialog});
        super.initUI(store);
        if (store.getId() != null) {
            String workspaceId = store.getWorkspace().getId();
            this.workspacePanel.getFormComponent().add((IValidator)new CheckExistingResourcesInWorkspaceValidator(store.getId(), workspaceId));
        }
    }

    @Override
    protected final void onSave(CoverageStoreInfo info, AjaxRequestTarget requestTarget, boolean doReturn) throws IllegalArgumentException {
        if (null == info.getType()) {
            throw new IllegalArgumentException("Coverage type has not been set");
        }
        Catalog catalog = this.getCatalog();
        ResourcePool resourcePool = catalog.getResourcePool();
        resourcePool.clear(info);
        if (info.isEnabled()) {
            LOGGER.finer("Store " + info.getName() + " is enabled, verifying factory availability before saving it...");
            AbstractGridFormat gridFormat = resourcePool.getGridCoverageFormat(info);
            if (gridFormat == null) {
                throw new IllegalArgumentException("No grid format found capable of connecting to the provided URL. To save the store disable it, and check the required libraries are in place");
            }
            try {
                GridCoverageReader reader = resourcePool.getGridCoverageReader(info, GeoTools.getDefaultHints());
                LOGGER.info("Connection to store " + info.getName() + " validated. Got a " + reader.getClass().getName() + ". Saving store");
                if (!this.doSaveStore(info)) {
                    return;
                }
                if (doReturn) {
                    this.doReturn(StorePage.class);
                }
            }
            catch (IOException | RuntimeException e) {
                this.confirmSaveOnConnectionFailure(info, requestTarget, e);
            }
        } else {
            if (!this.doSaveStore(info)) {
                return;
            }
            if (doReturn) {
                this.doReturn(StorePage.class);
            }
        }
    }

    private void confirmSaveOnConnectionFailure(final CoverageStoreInfo info, AjaxRequestTarget requestTarget, Exception error) {
        final String exceptionMessage = error.getMessage();
        this.dialog.showOkCancel(requestTarget, new GeoServerDialog.DialogDelegate(){
            boolean accepted = false;

            @Override
            protected Component getContents(String id) {
                return new StoreConnectionFailedInformationPanel(id, info.getName(), exceptionMessage);
            }

            @Override
            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                CoverageStoreEditPage.this.doSaveStore(info);
                this.accepted = true;
                return true;
            }

            @Override
            protected boolean onCancel(AjaxRequestTarget target) {
                return true;
            }

            @Override
            public void onClose(AjaxRequestTarget target) {
                if (this.accepted) {
                    CoverageStoreEditPage.this.doReturn(StorePage.class);
                }
            }
        });
    }

    protected boolean doSaveStore(CoverageStoreInfo info) {
        try {
            Catalog catalog = this.getCatalog();
            String prefix = info.getWorkspace().getName();
            NamespaceInfo namespace = catalog.getNamespaceByPrefix(prefix);
            List alreadyConfigured = catalog.getResourcesByStore((StoreInfo)info, CoverageInfo.class);
            for (CoverageInfo coverage : alreadyConfigured) {
                coverage.setNamespace(namespace);
            }
            ResourcePool resourcePool = catalog.getResourcePool();
            resourcePool.clear(info);
            CoverageStoreInfo expandedStore = resourcePool.clone(info, true);
            catalog.validate((StoreInfo)expandedStore, false).throwIfInvalid();
            catalog.save((StoreInfo)info);
            for (CoverageInfo coverage : alreadyConfigured) {
                catalog.save((ResourceInfo)coverage);
            }
            LOGGER.finer("Saved store " + info.getName());
        }
        catch (FileSandboxEnforcer.SandboxException e) {
            this.error((Serializable)((Object)new ParamResourceModel("sandboxError", (Component)this, e.getFile().getAbsolutePath()).getString()));
            return false;
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Saving the store for " + info.getURL(), e);
            throw new IllegalArgumentException("Unable to save the store: " + e.getMessage());
        }
        return true;
    }
}

