/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.store.CoverageStoreEditPage;
import org.geoserver.web.data.store.DataAccessEditPage;
import org.geoserver.web.data.store.StoreProvider;
import org.geoserver.web.data.store.WMSStoreEditPage;
import org.geoserver.web.data.store.WMTSStoreEditPage;
import org.geoserver.web.data.workspace.WorkspaceEditPage;
import org.geoserver.web.wicket.CachingImage;
import org.geoserver.web.wicket.ConfirmationAjaxLink;
import org.geoserver.web.wicket.DateTimeLabel;
import org.geoserver.web.wicket.GSModalWindow;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleBookmarkableLink;

public class StorePanel
extends GeoServerTablePanel<StoreInfo> {
    private static final long serialVersionUID = 5957961031378924960L;
    private GSModalWindow popupWindow = new GSModalWindow("popupWindow");

    public StorePanel(String id, StoreProvider provider, boolean selectable) {
        super(id, provider, selectable);
        this.add(new Component[]{this.popupWindow});
    }

    private Catalog getCatalog() {
        return GeoServerApplication.get().getCatalog();
    }

    @Override
    protected Component getComponentForProperty(String id, IModel<StoreInfo> itemModel, GeoServerDataProvider.Property<StoreInfo> property) {
        CatalogIconFactory icons = CatalogIconFactory.get();
        if (property == StoreProvider.DATA_TYPE) {
            StoreInfo storeInfo = (StoreInfo)itemModel.getObject();
            PackageResourceReference storeIcon = icons.getStoreIcon(storeInfo);
            Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)this);
            f.add(new Component[]{new CachingImage("storeIcon", (ResourceReference)storeIcon, new ResourceReference[0])});
            return f;
        }
        if (property == StoreProvider.WORKSPACE) {
            return this.workspaceLink(id, itemModel);
        }
        if (property == StoreProvider.NAME) {
            return this.storeNameLink(id, itemModel);
        }
        if (property == StoreProvider.ENABLED) {
            StoreInfo storeInfo = (StoreInfo)itemModel.getObject();
            PackageResourceReference enabledIcon = storeInfo.isEnabled() ? icons.getEnabledIcon() : icons.getDisabledIcon();
            Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)this);
            f.add(new Component[]{new CachingImage("storeIcon", (ResourceReference)enabledIcon, new ResourceReference[0])});
            return f;
        }
        if (property == StoreProvider.MODIFIED_TIMESTAMP) {
            return new DateTimeLabel(id, StoreProvider.MODIFIED_TIMESTAMP.getModel(itemModel));
        }
        if (property == StoreProvider.CREATED_TIMESTAMP) {
            return new DateTimeLabel(id, StoreProvider.CREATED_TIMESTAMP.getModel(itemModel));
        }
        if (property == StoreProvider.MODIFIED_BY) {
            return new Label(id, StoreProvider.MODIFIED_BY.getModel(itemModel));
        }
        return null;
    }

    private Component storeNameLink(String id, IModel<StoreInfo> itemModel) {
        String wsName = (String)StoreProvider.WORKSPACE.getModel(itemModel).getObject();
        IModel<?> storeNameModel = StoreProvider.NAME.getModel(itemModel);
        String storeName = (String)storeNameModel.getObject();
        StoreInfo store = this.getCatalog().getStoreByName(wsName, storeName, StoreInfo.class);
        if (store instanceof DataStoreInfo) {
            return new SimpleBookmarkableLink(id, DataAccessEditPage.class, storeNameModel, "storeName", storeName, "wsName", wsName);
        }
        if (store instanceof CoverageStoreInfo) {
            return new SimpleBookmarkableLink(id, CoverageStoreEditPage.class, storeNameModel, "storeName", storeName, "wsName", wsName);
        }
        if (store instanceof WMSStoreInfo) {
            return new SimpleBookmarkableLink(id, WMSStoreEditPage.class, storeNameModel, "storeName", storeName, "wsName", wsName);
        }
        if (store instanceof WMTSStoreInfo) {
            return new SimpleBookmarkableLink(id, WMTSStoreEditPage.class, storeNameModel, "storeName", storeName, "wsName", wsName);
        }
        throw new RuntimeException("Don't know what to do with this store " + String.valueOf(store));
    }

    private Component workspaceLink(String id, IModel<StoreInfo> itemModel) {
        IModel<?> nameModel = StoreProvider.WORKSPACE.getModel(itemModel);
        return new SimpleBookmarkableLink(id, WorkspaceEditPage.class, nameModel, "name", (String)nameModel.getObject());
    }

    protected Component removeLink(String id, final IModel itemModel) {
        StoreInfo info = (StoreInfo)itemModel.getObject();
        ResourceModel resRemove = new ResourceModel("removeStore", "Remove");
        ParamResourceModel confirmRemove = new ParamResourceModel("confirmRemoveStoreX", (Component)this, info.getName());
        ConfirmationAjaxLink<Object> linkPanel = new ConfirmationAjaxLink<Object>(id, null, (IModel)resRemove, (IModel)confirmRemove){

            @Override
            public void onClick(AjaxRequestTarget target) {
                StorePanel.this.getCatalog().remove((StoreInfo)itemModel.getObject());
                target.add(new Component[]{StorePanel.this});
            }
        };
        return linkPanel;
    }
}

