/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.factory.CommonFactoryFinder;

public class StoreProvider
extends GeoServerDataProvider<StoreInfo> {
    static final GeoServerDataProvider.Property<StoreInfo> DATA_TYPE = new GeoServerDataProvider.AbstractProperty<StoreInfo>("datatype"){

        @Override
        public IModel<String> getModel(IModel<StoreInfo> itemModel) {
            return (IModel & Serializable)() -> {
                StoreInfo si = (StoreInfo)itemModel.getObject();
                return (String)this.getPropertyValue(si);
            };
        }

        @Override
        public Object getPropertyValue(StoreInfo item) {
            if (item instanceof DataStoreInfo) {
                return "vector";
            }
            return "raster";
        }
    };
    static final GeoServerDataProvider.Property<StoreInfo> WORKSPACE = new GeoServerDataProvider.BeanProperty<StoreInfo>("workspace", "workspace.name");
    static final GeoServerDataProvider.Property<StoreInfo> NAME = new GeoServerDataProvider.BeanProperty<StoreInfo>("name", "name");
    static final GeoServerDataProvider.Property<StoreInfo> TYPE = new GeoServerDataProvider.AbstractProperty<StoreInfo>("type"){

        @Override
        public Object getPropertyValue(StoreInfo item) {
            String type = item.getType();
            if (type != null) {
                return type;
            }
            try {
                CoverageStoreInfo info;
                AbstractGridFormat format;
                ResourcePool resourcePool = item.getCatalog().getResourcePool();
                if (item instanceof DataStoreInfo) {
                    DataStoreInfo dsInfo = (DataStoreInfo)item;
                    DataAccessFactory factory = resourcePool.getDataStoreFactory(dsInfo);
                    if (factory != null) {
                        return factory.getDisplayName();
                    }
                } else if (item instanceof CoverageStoreInfo && (format = resourcePool.getGridCoverageFormat(info = (CoverageStoreInfo)item)) != null) {
                    return format.getName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "?";
        }
    };
    static final GeoServerDataProvider.Property<StoreInfo> ENABLED = new GeoServerDataProvider.BeanProperty<StoreInfo>("enabled", "enabled");
    static final GeoServerDataProvider.Property<StoreInfo> MODIFIED_TIMESTAMP = new GeoServerDataProvider.BeanProperty<StoreInfo>("datemodfied", "dateModified");
    static final GeoServerDataProvider.Property<StoreInfo> CREATED_TIMESTAMP = new GeoServerDataProvider.BeanProperty<StoreInfo>("datecreated", "dateCreated");
    static final GeoServerDataProvider.Property<StoreInfo> MODIFIED_BY = new GeoServerDataProvider.BeanProperty<StoreInfo>("modifiedby", "modifiedBy");
    static final List<GeoServerDataProvider.Property<StoreInfo>> PROPERTIES = Arrays.asList(DATA_TYPE, WORKSPACE, NAME, TYPE, ENABLED);
    WorkspaceInfo workspace;

    public StoreProvider() {
        this(null);
    }

    public StoreProvider(WorkspaceInfo workspace) {
        this.workspace = workspace;
    }

    @Override
    protected List<StoreInfo> getItems() {
        throw new UnsupportedOperationException("This method should not be being called! We use the catalog streaming API");
    }

    @Override
    protected List<GeoServerDataProvider.Property<StoreInfo>> getProperties() {
        String trackUser;
        List<GeoServerDataProvider.Property<StoreInfo>> modifiedPropertiesList = PROPERTIES.stream().map(c -> c).collect(Collectors.toList());
        if (GeoServerApplication.get().getGeoServer().getSettings().isShowCreatedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(CREATED_TIMESTAMP);
        }
        if (GeoServerApplication.get().getGeoServer().getSettings().isShowModifiedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(MODIFIED_TIMESTAMP);
        }
        if ((trackUser = GeoServerExtensions.getProperty((String)"TRACK_USER")) == null && GeoServerApplication.get().getGeoServer().getSettings().isShowModifiedUserInAdminList() || Boolean.parseBoolean(trackUser)) {
            modifiedPropertiesList.add(MODIFIED_BY);
        }
        return modifiedPropertiesList;
    }

    @Override
    protected Comparator<StoreInfo> getComparator(SortParam sort) {
        return super.getComparator(sort);
    }

    @Override
    public IModel<StoreInfo> newModel(StoreInfo object) {
        return new StoreInfoDetachableModel(object);
    }

    @Override
    public long size() {
        Filter filter = this.getFilter();
        filter = this.getWorkspaceFilter(filter);
        int count = this.getCatalog().count(StoreInfo.class, filter);
        return count;
    }

    @Override
    public int fullSize() {
        Filter filter = Predicates.acceptAll();
        filter = this.getWorkspaceFilter(filter);
        int count = this.getCatalog().count(StoreInfo.class, filter);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<StoreInfo> iterator(long first, long count) {
        Iterator<StoreInfo> iterator = this.filteredItems(first, count);
        if (iterator instanceof CloseableIterator) {
            try {
                Iterator<StoreInfo> iterator2 = Lists.newArrayList(iterator).iterator();
                return iterator2;
            }
            finally {
                CloseableIteratorAdapter.close(iterator);
            }
        }
        return iterator;
    }

    private Iterator<StoreInfo> filteredItems(long first, long count) {
        Catalog catalog = this.getCatalog();
        SortParam sort = this.getSort();
        GeoServerDataProvider.Property property = this.getProperty(sort);
        SortBy sortOrder = null;
        if (sort != null) {
            if (property instanceof GeoServerDataProvider.BeanProperty) {
                String sortProperty = ((GeoServerDataProvider.BeanProperty)property).getPropertyPath();
                sortOrder = Predicates.sortBy((String)sortProperty, (boolean)sort.isAscending());
            } else if (property == ENABLED) {
                sortOrder = Predicates.sortBy((String)"enabled", (boolean)sort.isAscending());
            } else if (property == TYPE) {
                sortOrder = Predicates.sortBy((String)"type", (boolean)sort.isAscending());
            }
        } else {
            sortOrder = Predicates.sortBy((String)"name", (boolean)true);
        }
        Filter filter = this.getWorkspaceFilter(this.getFilter());
        CloseableIterator items = catalog.list(StoreInfo.class, filter, Integer.valueOf((int)first), Integer.valueOf((int)count), sortOrder);
        return items;
    }

    private Filter getWorkspaceFilter(Filter filter) {
        if (this.workspace != null) {
            FilterFactory ff = CommonFactoryFinder.getFilterFactory();
            Equals workspaceFilter = ff.equal((Expression)ff.property("workspace.id"), (Expression)ff.literal((Object)this.workspace.getId()));
            filter = ff.and(filter, (Filter)workspaceFilter);
        }
        return filter;
    }

    static class StoreInfoDetachableModel
    extends LoadableDetachableModel<StoreInfo> {
        private static final long serialVersionUID = -6829878983583733186L;
        String id;

        public StoreInfoDetachableModel(StoreInfo store) {
            super((Object)store);
            this.id = store.getId();
        }

        protected StoreInfo load() {
            Catalog catalog = GeoServerApplication.get().getCatalog();
            return catalog.getStore(this.id, StoreInfo.class);
        }
    }
}

