/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.web.data.store.AbstractWMTSStorePage;
import org.geoserver.web.data.store.StoreConnectionFailedInformationPanel;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geotools.ows.wmts.WebMapTileServer;

public class WMTSStoreEditPage
extends AbstractWMTSStorePage {
    public static final String STORE_NAME = "storeName";
    public static final String WS_NAME = "wsName";

    public WMTSStoreEditPage(PageParameters parameters) {
        String wsName = parameters.get(WS_NAME).toOptionalString();
        String storeName = parameters.get(STORE_NAME).toString();
        WMTSStoreInfo store = (WMTSStoreInfo)this.getCatalog().getStoreByName(wsName, storeName, WMTSStoreInfo.class);
        this.initUI(store);
    }

    public WMTSStoreEditPage(WMTSStoreInfo store) {
        this.initUI(store);
    }

    @Override
    protected void onSave(WMTSStoreInfo info, AjaxRequestTarget target) throws IllegalArgumentException {
        if (!info.isEnabled()) {
            this.doSaveStore(info);
        } else {
            try {
                this.getCatalog().getResourcePool().clear(info);
                WebMapTileServer wmts = this.getCatalog().getResourcePool().getWebMapTileServer(info);
                wmts.getCapabilities();
                this.doSaveStore(info);
            }
            catch (Exception e) {
                this.confirmSaveOnConnectionFailure(info, target, e);
            }
        }
    }

    protected void doSaveStore(WMTSStoreInfo info) {
        Catalog catalog = this.getCatalog();
        WMTSStoreInfo expandedStore = catalog.getResourcePool().clone(info, true);
        this.getCatalog().validate((StoreInfo)expandedStore, false).throwIfInvalid();
        this.getCatalog().save((StoreInfo)info);
        this.doReturn(StorePage.class);
    }

    private void confirmSaveOnConnectionFailure(final WMTSStoreInfo info, AjaxRequestTarget requestTarget, Exception error) {
        this.getCatalog().getResourcePool().clear(info);
        String message = error.getMessage();
        if (message == null && error.getCause() != null) {
            message = error.getCause().getMessage();
        }
        final String exceptionMessage = message;
        this.dialog.showOkCancel(requestTarget, new GeoServerDialog.DialogDelegate(){
            boolean accepted = false;

            @Override
            protected Component getContents(String id) {
                return new StoreConnectionFailedInformationPanel(id, info.getName(), exceptionMessage);
            }

            @Override
            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                WMTSStoreEditPage.this.doSaveStore(info);
                this.accepted = true;
                return true;
            }

            @Override
            protected boolean onCancel(AjaxRequestTarget target) {
                return true;
            }

            @Override
            public void onClose(AjaxRequestTarget target) {
                if (this.accepted) {
                    WMTSStoreEditPage.this.doReturn(StorePage.class);
                }
            }
        });
    }
}

