/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import com.google.common.collect.Streams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Objects;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.SettingsInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.workspace.WorkspaceDetachableModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;

public class WorkspaceProvider
extends GeoServerDataProvider<WorkspaceInfo> {
    private static final long serialVersionUID = -2464073552094977958L;
    public static GeoServerDataProvider.Property<WorkspaceInfo> NAME = new GeoServerDataProvider.BeanProperty<WorkspaceInfo>("name", "name");
    public static GeoServerDataProvider.Property<WorkspaceInfo> DEFAULT = new GeoServerDataProvider.AbstractProperty<WorkspaceInfo>("default"){
        private static final long serialVersionUID = 7732697329315316826L;

        @Override
        public Object getPropertyValue(WorkspaceInfo item) {
            return WorkspaceProvider.isDefaultWorkspace(item);
        }
    };
    public static GeoServerDataProvider.Property<WorkspaceInfo> ISOLATED = new GeoServerDataProvider.BeanProperty<WorkspaceInfo>("isolated", "isolated");
    static List<GeoServerDataProvider.Property<WorkspaceInfo>> PROPERTIES = List.of(NAME, DEFAULT, ISOLATED);
    public static final GeoServerDataProvider.Property<WorkspaceInfo> MODIFIED_TIMESTAMP = new GeoServerDataProvider.BeanProperty<WorkspaceInfo>("datemodfied", "dateModified");
    public static final GeoServerDataProvider.Property<WorkspaceInfo> CREATED_TIMESTAMP = new GeoServerDataProvider.BeanProperty<WorkspaceInfo>("datecreated", "dateCreated");
    static final GeoServerDataProvider.Property<WorkspaceInfo> MODIFIED_BY = new GeoServerDataProvider.BeanProperty<WorkspaceInfo>("modifiedby", "modifiedBy");

    public WorkspaceProvider() {
        this.setSort(NAME.getName(), SortOrder.ASCENDING);
    }

    @Override
    protected List<WorkspaceInfo> getItems() {
        throw new UnsupportedOperationException("This method should not be being called! We use the catalog streaming API");
    }

    @Override
    public long size() {
        Filter filter = this.getFilter();
        int count = this.getCatalog().count(WorkspaceInfo.class, filter);
        return count;
    }

    @Override
    public int fullSize() {
        Filter filter = Predicates.acceptAll();
        int count = this.getCatalog().count(WorkspaceInfo.class, filter);
        return count;
    }

    @Override
    public Iterator<WorkspaceInfo> iterator(long first, long count) {
        LinkedList list;
        this.validate(first, count);
        Catalog catalog = this.getCatalog();
        SortParam sort = this.getSort();
        GeoServerDataProvider.Property property = this.getProperty(sort);
        Filter filter = this.getFilter();
        WorkspaceInfo defaultWorkspace = catalog.getDefaultWorkspace();
        SortBy sortOrder = null;
        if (property instanceof GeoServerDataProvider.BeanProperty) {
            String sortProperty = ((GeoServerDataProvider.BeanProperty)property).getPropertyPath();
            sortOrder = Predicates.sortBy((String)sortProperty, (boolean)sort.isAscending());
        } else if (property == DEFAULT) {
            if (null != defaultWorkspace && filter.evaluate((Object)defaultWorkspace)) {
                Filter excludeDefault = Predicates.notEqual((String)"id", (Object)defaultWorkspace.getId());
                filter = Predicates.and((Filter)excludeDefault, (Filter)filter);
            } else {
                defaultWorkspace = null;
            }
        } else if (null != property) {
            throw new IllegalStateException("Unknown sort property " + String.valueOf(property));
        }
        try (CloseableIterator items = catalog.list(WorkspaceInfo.class, filter, Integer.valueOf((int)first), Integer.valueOf((int)count), sortOrder);){
            Stream<WorkspaceInfo> stream = Streams.stream((Iterator)items);
            if (null != defaultWorkspace) {
                WorkspaceInfo def = defaultWorkspace;
                stream = stream.map(item -> WorkspaceProvider.decorateDefault(def, item));
            }
            list = stream.collect(Collectors.toCollection(LinkedList::new));
        }
        if (property == DEFAULT && defaultWorkspace != null) {
            if (sort.isAscending()) {
                list.addFirst(defaultWorkspace);
            } else {
                list.addLast(defaultWorkspace);
            }
        }
        return list.iterator();
    }

    @Override
    protected List<GeoServerDataProvider.Property<WorkspaceInfo>> getProperties() {
        String trackUser;
        ArrayList<GeoServerDataProvider.Property<WorkspaceInfo>> modifiedPropertiesList = new ArrayList<GeoServerDataProvider.Property<WorkspaceInfo>>(PROPERTIES);
        SettingsInfo settings = this.getSettings();
        if (settings.isShowCreatedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(CREATED_TIMESTAMP);
        }
        if (settings.isShowModifiedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(MODIFIED_TIMESTAMP);
        }
        if ((trackUser = GeoServerExtensions.getProperty((String)"TRACK_USER")) == null && GeoServerApplication.get().getGeoServer().getSettings().isShowModifiedUserInAdminList() || Boolean.parseBoolean(trackUser)) {
            modifiedPropertiesList.add(MODIFIED_BY);
        }
        return modifiedPropertiesList;
    }

    protected SettingsInfo getSettings() {
        return GeoServerApplication.get().getGeoServer().getSettings();
    }

    @Override
    protected IModel<WorkspaceInfo> newModel(WorkspaceInfo object) {
        return new WorkspaceDetachableModel(object);
    }

    private void validate(Long first, Long count) {
        if (first > Integer.MAX_VALUE || first < Integer.MIN_VALUE || count > Integer.MAX_VALUE || count < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
    }

    static WorkspaceInfo decorateDefault(WorkspaceInfo defaultWorkspace, WorkspaceInfo item) {
        if (Objects.equal((Object)defaultWorkspace.getId(), (Object)item.getId())) {
            item = (WorkspaceInfo)ModificationProxy.create((Object)((WorkspaceInfo)ModificationProxy.unwrap((Object)item)), WorkspaceInfo.class);
            item.getMetadata().put("defaultWorkspace", (Serializable)Boolean.TRUE);
        }
        return item;
    }

    static boolean isDefaultWorkspace(WorkspaceInfo item) {
        return Boolean.TRUE.equals(item.getMetadata().get((Object)"defaultWorkspace"));
    }
}

