/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.AccessMode;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.security.DataAccessRuleInfo;
import org.geoserver.web.spring.security.GeoServerSession;
import org.springframework.security.core.GrantedAuthority;

public class AccessDataRuleInfoManager {
    private DataAccessRuleDAO dao = DataAccessRuleDAO.get();
    static List<AccessMode> MODES = Arrays.asList(AccessMode.READ, AccessMode.WRITE, AccessMode.ADMIN);

    public GeoServerSecurityManager getSecurityManager() {
        return GeoServerApplication.get().getSecurityManager();
    }

    public Set<String> getAvailableRoles() {
        try {
            return this.getSecurityManager().getRolesForAccessControl().stream().map(r -> r.getAuthority()).collect(Collectors.toSet());
        }
        catch (IOException ioex) {
            return null;
        }
    }

    public String getWorkspaceName(CatalogInfo info) {
        if (info instanceof WorkspaceInfo) {
            WorkspaceInfo workspaceInfo = (WorkspaceInfo)info;
            return workspaceInfo.getName();
        }
        if (info instanceof LayerInfo) {
            LayerInfo layerInfo = (LayerInfo)info;
            return layerInfo.getResource().getStore().getWorkspace().getName();
        }
        if (info instanceof LayerGroupInfo) {
            LayerGroupInfo group = (LayerGroupInfo)info;
            String wsName = group.getWorkspace() != null ? group.getWorkspace().getName() : null;
            return wsName;
        }
        return null;
    }

    public String getLayerName(CatalogInfo info) {
        if (info instanceof PublishedInfo) {
            PublishedInfo publishedInfo = (PublishedInfo)info;
            return publishedInfo.getName();
        }
        return null;
    }

    public List<DataAccessRule> getRules() {
        DataAccessRuleDAO dao = this.getSecurityManager().getDataAccessRuleDAO();
        return dao.getRules();
    }

    public Set<DataAccessRule> getWorkspaceDataAccessRules(String workspaceName) {
        return this.getRules().stream().filter(r -> r.getRoot().equalsIgnoreCase(workspaceName) && r.getLayer().equals("*")).collect(Collectors.toSet());
    }

    public Set<DataAccessRule> getGlobalLayerGroupSecurityRule(String layerGroupName) {
        return this.getRules().stream().filter(r -> r.getRoot().equalsIgnoreCase(layerGroupName)).collect(Collectors.toSet());
    }

    public Set<DataAccessRule> getLayerSecurityRule(String workspaceName, String layerName) {
        return this.getRules().stream().filter(r -> r.getRoot().equalsIgnoreCase(workspaceName) && r.getLayer().equalsIgnoreCase(layerName)).collect(Collectors.toSet());
    }

    public Set<DataAccessRule> getResourceRule(String workspaceName, CatalogInfo info) {
        Set<DataAccessRule> rules = null;
        if (info instanceof PublishedInfo) {
            PublishedInfo layerInfo = (PublishedInfo)info;
            rules = this.getLayerSecurityRule(workspaceName, layerInfo.getName());
        } else if (info instanceof LayerGroupInfo) {
            rules = workspaceName == null ? this.getGlobalLayerGroupSecurityRule(((LayerGroupInfo)info).getName()) : this.getLayerSecurityRule(workspaceName, ((PublishedInfo)info).getName());
        } else if (info instanceof WorkspaceInfo) {
            WorkspaceInfo workspaceInfo = (WorkspaceInfo)info;
            rules = this.getWorkspaceDataAccessRules(workspaceInfo.getName());
        }
        return rules;
    }

    public List<DataAccessRuleInfo> mapTo(Set<DataAccessRule> rules, Set<String> authorities, String wsName, String layerName) {
        if (rules == null || rules.isEmpty()) {
            return this.getNewInfoList(wsName, layerName, authorities);
        }
        ArrayList<DataAccessRuleInfo> models = new ArrayList<DataAccessRuleInfo>(authorities.size());
        HashMap modeRoleMap = new HashMap(authorities.size());
        for (String auth : authorities) {
            HashSet modes = new HashSet(3);
            for (AccessMode mode : MODES) {
                rules.stream().filter(r -> r.getAccessMode() == mode).forEach(r -> {
                    if (r.getRoles().contains(auth)) {
                        modes.add(mode);
                    }
                });
            }
            modeRoleMap.put(auth, modes);
        }
        rules.forEach(r -> authorities.removeAll(r.getRoles()));
        authorities.forEach(r -> modeRoleMap.put((String)r, null));
        for (String key : modeRoleMap.keySet()) {
            Set ams = (Set)modeRoleMap.get(key);
            DataAccessRuleInfo model = new DataAccessRuleInfo(key, wsName, layerName);
            model.setAdminFromMode(ams);
            model.setReadFromMode(ams);
            model.setWriteFromMode(ams);
            models.add(model);
        }
        return models;
    }

    public List<DataAccessRuleInfo> getNewInfoList(String wsName, String layerName, Set<String> availableRoles) {
        ArrayList<DataAccessRuleInfo> rules = new ArrayList<DataAccessRuleInfo>();
        for (String role : availableRoles) {
            DataAccessRuleInfo rule = new DataAccessRuleInfo(role, wsName, layerName);
            rule.setRead(false);
            rule.setWrite(false);
            rule.setAdmin(false);
            rules.add(rule);
        }
        return rules;
    }

    public Set<DataAccessRule> mapFrom(List<DataAccessRuleInfo> newRules, Set<String> authorities, String wsName, String layerName, boolean globalLayerGroup) {
        HashSet<DataAccessRule> rules = new HashSet<DataAccessRule>(authorities.size());
        HashMap modeRoleMap = new HashMap(MODES.size());
        for (AccessMode mode : MODES) {
            HashSet selectedRoles = new HashSet();
            for (String auth : authorities) {
                newRules.stream().filter(role -> role.getRoleName().equalsIgnoreCase(auth)).forEach(rule -> {
                    if (rule.hasMode(mode)) {
                        selectedRoles.add(auth);
                    }
                });
            }
            modeRoleMap.put(mode, selectedRoles);
        }
        for (AccessMode key : modeRoleMap.keySet()) {
            Set roles = (Set)modeRoleMap.get(key);
            if (roles == null || roles.isEmpty()) continue;
            DataAccessRule rule2 = new DataAccessRule();
            if (!globalLayerGroup) {
                rule2.setRoot(wsName);
                rule2.setLayer(layerName != null ? layerName : "*");
            } else {
                rule2.setRoot(layerName);
                rule2.setLayer(null);
                rule2.setGlobalGroupRule(true);
            }
            rule2.setAccessMode(key);
            rule2.getRoles().addAll(roles);
            rules.add(rule2);
        }
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRules(Set<DataAccessRule> old, Set<DataAccessRule> news) throws IOException {
        AccessDataRuleInfoManager accessDataRuleInfoManager = this;
        synchronized (accessDataRuleInfoManager) {
            old.forEach(r -> this.dao.removeRule((Comparable)r));
            if (!news.isEmpty()) {
                news.forEach(r -> this.dao.addRule((Comparable)r));
            }
            this.dao.storeRules();
        }
    }

    public List<DataAccessRuleInfo> getDataAccessRuleInfo(CatalogInfo info) {
        String workspaceName = this.getWorkspaceName(info);
        String layerName = this.getLayerName(info);
        Set<String> authorities = this.getAvailableRoles();
        Set<DataAccessRule> rules = this.getResourceRule(workspaceName, info);
        return this.mapTo(rules, authorities, workspaceName, layerName);
    }

    public void removeAllResourceRules(String wsName, CatalogInfo info) throws IOException {
        this.getResourceRule(wsName, info).forEach(r -> this.dao.removeRule((Comparable)r));
        this.dao.storeRules();
    }

    public static boolean canAccess() {
        boolean isAdmin = false;
        for (GrantedAuthority auth : GeoServerSession.get().getAuthentication().getAuthorities()) {
            if (!auth.getAuthority().equalsIgnoreCase(GeoServerRole.ADMIN_ROLE.getAuthority())) continue;
            isAdmin = true;
            break;
        }
        return GeoServerApplication.get().getBeanOfType(SecureCatalogImpl.class).isDefaultAccessManager() && isAdmin;
    }
}

