/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security;

import java.io.Serializable;
import java.util.Set;
import org.geoserver.security.AccessMode;

public class DataAccessRuleInfo
implements Serializable {
    private String roleName;
    private boolean read = false;
    private boolean write = false;
    private boolean admin = false;
    private String layerName;
    private String workspaceName;

    public DataAccessRuleInfo(String roleName, String workspaceName, String layerName) {
        this.roleName = roleName;
        this.workspaceName = workspaceName;
        this.layerName = layerName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public void setReadFromMode(Set<AccessMode> modes) {
        this.read = modes != null && modes.contains(AccessMode.READ);
    }

    public boolean isWrite() {
        return this.write;
    }

    public void setWrite(boolean write) {
        this.write = write;
    }

    public void setWriteFromMode(Set<AccessMode> modes) {
        this.write = modes != null && modes.contains(AccessMode.WRITE);
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public void setAdminFromMode(Set<AccessMode> modes) {
        this.admin = modes != null && modes.contains(AccessMode.ADMIN);
    }

    public boolean hasMode(AccessMode mode) {
        if (mode == AccessMode.READ && this.isRead()) {
            return true;
        }
        if (mode == AccessMode.WRITE && this.isWrite()) {
            return true;
        }
        return mode == AccessMode.ADMIN && this.isAdmin();
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }
}

