/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.system.status;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ConsoleInfoUtils {
    private ConsoleInfoUtils() {
    }

    static String getThreadsInfo(boolean lockedMonitors, boolean lockedSynchronizers) {
        return Arrays.stream(ManagementFactory.getThreadMXBean().dumpAllThreads(lockedMonitors, lockedSynchronizers)).map(t -> ConsoleInfoUtils.getThreadStackTraces(t)).collect(Collectors.joining("\n"));
    }

    static String getThreadStackTraces(ThreadInfo ti) {
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\"" + (ti.isDaemon() ? " daemon" : "") + " prio=" + ti.getPriority() + " Id=" + ti.getThreadId() + " " + String.valueOf((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            sb.append(" on " + ti.getLockName());
        }
        if (ti.getLockOwnerName() != null) {
            sb.append(" owned by \"" + ti.getLockOwnerName() + "\" Id=" + ti.getLockOwnerId());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = ti.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat " + ConsoleInfoUtils.formatStackTraceElement(ste));
            sb.append('\n');
            LockInfo lockInfo = ti.getLockInfo();
            if (i == 0 && lockInfo != null) {
                Thread.State ts = ti.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + String.valueOf(lockInfo));
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on " + String.valueOf(lockInfo));
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + String.valueOf(lockInfo));
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (MonitorInfo mi : ti.getLockedMonitors()) {
                if (mi.getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + String.valueOf(mi));
                sb.append('\n');
            }
        }
        LockInfo[] locks = ti.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo li : locks) {
                sb.append("\t- " + String.valueOf(li));
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    private static String formatStackTraceElement(StackTraceElement s) {
        return s.getClassName() + "." + s.getMethodName() + "(" + (String)(s.isNativeMethod() ? "Native Method)" : (s.getFileName() != null && s.getLineNumber() >= 0 ? s.getFileName() + ":" + s.getLineNumber() + ")" : ""));
    }

    static String getHistoMemoryDump() {
        String string;
        int pid = Optional.ofNullable(ManagementFactory.getRuntimeMXBean().getName()).map(processName -> Arrays.asList(processName.split("@"))).filter(elements -> !elements.isEmpty()).map(maybePid -> Integer.valueOf((String)maybePid.get(0))).orElseThrow(() -> new IOException("Problem on getting the PID for the java process"));
        Process jmapProcess = Runtime.getRuntime().exec("jmap -histo:live %d".formatted(pid));
        BufferedReader stdConsole = new BufferedReader(new InputStreamReader(jmapProcess.getInputStream()));
        try {
            String buffer;
            StringBuilder accumulator = new StringBuilder();
            while ((buffer = stdConsole.readLine()) != null) {
                accumulator.append(buffer).append("\n");
            }
            string = accumulator.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stdConsole.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return "Error reading the histo memory dump with the jmap command. Exception: %s".formatted(e.getMessage());
            }
        }
        stdConsole.close();
        return string;
    }
}

