/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.system.status;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.system.status.MetricValue;
import org.geoserver.system.status.Metrics;
import org.geoserver.system.status.SystemInfoCollector;
import org.geoserver.web.wicket.DateLabel;
import org.geotools.util.logging.Logging;

public class RefreshedPanel
extends Panel {
    private static final long serialVersionUID = -5616622546856772557L;
    public static final String datePattern = "yyyy-MM-dd HH:mm:ss.SSS";

    public RefreshedPanel(String id) {
        super(id);
        final SystemInfoCollector systemInfoCollector = (SystemInfoCollector)GeoServerExtensions.bean(SystemInfoCollector.class);
        final IModel metricMdl = Model.ofList(Collections.emptyList());
        Model statisticsIModel = Model.of((Serializable)systemInfoCollector.getStatisticsStatus());
        final CheckBox statisticsCheckBox = new CheckBox("statistics", (IModel)statisticsIModel);
        statisticsCheckBox.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("click"){

            protected void onUpdate(AjaxRequestTarget ajaxRequestTarget) {
                systemInfoCollector.setStatisticsStatus((Boolean)statisticsCheckBox.getModelObject());
            }
        }});
        statisticsCheckBox.setOutputMarkupId(true);
        this.add(new Component[]{statisticsCheckBox});
        final DateLabel time = new DateLabel("time", (IModel<Date>)Model.of((Serializable)new Date()), datePattern);
        time.setOutputMarkupId(true);
        this.add(new Component[]{time});
        ListView<MetricValue> list = new ListView<MetricValue>("metrics", metricMdl){
            private static final long serialVersionUID = -5654700538264617274L;
            private int counter;

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.counter = 0;
            }

            protected void populateItem(ListItem<MetricValue> item) {
                item.add(new Component[]{new Label("info", (IModel)new PropertyModel((Object)new MetricValueI18nDescriptionWrapper((MetricValue)item.getModel().getObject(), (Component)this), "description")), new Label("value", (IModel)new PropertyModel((Object)item.getModel(), "valueUnit"))});
                if (this.counter % 2 == 0) {
                    item.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"odd"))});
                } else {
                    item.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"even"))});
                }
                ++this.counter;
            }
        };
        list.setOutputMarkupId(true);
        this.add(new Component[]{list});
        long start = System.currentTimeMillis();
        systemInfoCollector.retrieveAllSystemInfo();
        long complete = System.currentTimeMillis();
        long sampleTime = complete - start;
        Duration updateInterval = Duration.ofMillis(Math.max(5000L, sampleTime * 5L));
        this.add(new Behavior[]{new AjaxSelfUpdatingTimerBehavior(updateInterval){
            private static final long serialVersionUID = -7009847252782601466L;

            public void onConfigure(Component component) {
                super.onConfigure(component);
                Metrics metrics = systemInfoCollector.retrieveAllSystemInfo();
                metricMdl.setObject((Object)metrics.getMetrics());
                time.setDefaultModel((IModel)Model.of((Serializable)new Date()));
            }
        }});
    }

    private static class MetricValueI18nDescriptionWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final Logger LOGGER = Logging.getLogger(MetricValueI18nDescriptionWrapper.class);
        private final MetricValue value;
        private final Component component;

        public MetricValueI18nDescriptionWrapper(MetricValue value, Component component) {
            this.value = value;
            this.component = component;
        }

        public String getDescription() {
            String keyValue = this.formatKeyValue(this.value);
            LOGGER.log(Level.FINE, "Getting localized name for {0} -> {1}", new Object[]{keyValue, this.value.getDescription()});
            String localizedValue = this.component.getString(keyValue, null, this.value.getDescription());
            return localizedValue;
        }

        private String formatKeyValue(MetricValue value) {
            StringBuilder keyBuilder = new StringBuilder();
            keyBuilder.append(this.scapeKeyString(value.getName().toLowerCase()));
            keyBuilder.append("-");
            keyBuilder.append(this.scapeKeyString(value.getIdentifier().toLowerCase()));
            return keyBuilder.toString();
        }

        private String scapeKeyString(String value) {
            return value.replace(" ", "_").replace(":", "_").replace("=", "_");
        }
    }
}

