/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.util;

import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.util.convert.IConverter;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;

public class GeoToolsConverterLocator
implements IConverterLocator {
    private static final long serialVersionUID = -8704868281264763254L;
    static final Logger LOGGER = Logging.getLogger(GeoToolsConverterLocator.class);

    public <C> IConverter<C> getConverter(Class<C> type) {
        Set factories = Converters.getConverterFactories(String.class, type);
        if (!factories.isEmpty()) {
            return new GeoToolsConverter<C>(factories, type);
        }
        return null;
    }

    static class GeoToolsConverter<T>
    implements IConverter<T> {
        private static final long serialVersionUID = 3463117432947622403L;
        Set<ConverterFactory> factories;
        Class<T> target;

        GeoToolsConverter(Set<ConverterFactory> factories, Class<T> target) {
            this.factories = factories;
            this.target = target;
        }

        public T convertToObject(String value, Locale locale) {
            for (ConverterFactory factory : this.factories) {
                try {
                    Object converted;
                    Converter converter = factory.createConverter(String.class, this.target, null);
                    if (converter == null || (converted = converter.convert((Object)value, this.target)) == null) continue;
                    return (T)converted;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error converting \"" + value + "\" to " + this.target.getName(), e);
                }
            }
            return null;
        }

        public String convertToString(Object value, Locale locale) {
            Set rconverters = Converters.getConverterFactories(this.target, String.class);
            for (ConverterFactory cf : rconverters) {
                try {
                    String converted;
                    Converter converter = cf.createConverter(value.getClass(), String.class, null);
                    if (converter == null || (converted = (String)converter.convert(value, String.class)) == null) continue;
                    return converted;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error converting \"" + String.valueOf(value) + "\" to String", e);
                }
            }
            return value.toString();
        }
    }
}

