/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.LocaleUtils;
import org.geotools.util.logging.Logging;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class LocalizationsFinder {
    static final Logger LOGGER = Logging.getLogger(LocalizationsFinder.class);
    private static List<Locale> LOCALES;

    public static List<Locale> getAvailableLocales() {
        return LOCALES;
    }

    static {
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(LocalizationsFinder.class.getClassLoader());
            LinkedHashSet<Locale> locales = new LinkedHashSet<Locale>();
            for (Resource resource : resolver.getResources("classpath*:/GeoServerApplication_*.properties")) {
                String name = resource.getFilename();
                if (name == null) continue;
                try {
                    int idx = name.lastIndexOf(".");
                    String language = name.substring("GeoServerApplication_".length(), idx);
                    Locale locale = LocaleUtils.toLocale((String)language);
                    locales.add(locale);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Skipping file " + name + ", could not extract a Locale from it", e);
                }
            }
            locales.add(Locale.ENGLISH);
            ArrayList<Locale> localesList = new ArrayList<Locale>(locales);
            localesList.sort(Comparator.comparing(l -> l.toString()));
            LOCALES = Collections.unmodifiableList(localesList);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to lookup UI translations, defaulting to English");
            LOCALES = Arrays.asList(Locale.ENGLISH);
        }
    }
}

