/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.util.converters;

import org.geoserver.catalog.ResourcePool;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.Converter;
import org.locationtech.jts.geom.Envelope;

public class StringBBoxConverter
implements Converter {
    private static String SEPARATOR = ",";

    public <T> T convert(Object source, Class<T> target) throws Exception {
        if (source instanceof ReferencedEnvelope) {
            ReferencedEnvelope envelope = (ReferencedEnvelope)source;
            if (String.class.isAssignableFrom(target)) {
                try {
                    StringBuilder str = new StringBuilder();
                    str.append(envelope.getMinimum(0)).append(SEPARATOR);
                    str.append(envelope.getMaximum(0)).append(SEPARATOR);
                    str.append(envelope.getMinimum(1)).append(SEPARATOR);
                    str.append(envelope.getMaximum(1)).append(SEPARATOR);
                    str.append(ResourcePool.lookupIdentifier((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem(), (boolean)true));
                    return (T)str.toString();
                }
                catch (Exception e) {
                    return null;
                }
            }
        } else if (ReferencedEnvelope.class.isAssignableFrom(target)) {
            String text = (String)source;
            String[] parsed = text.split("\\s*" + SEPARATOR + "\\s*");
            try {
                return (T)new ReferencedEnvelope(new Envelope(Double.valueOf(parsed[0]).doubleValue(), Double.valueOf(parsed[1]).doubleValue(), Double.valueOf(parsed[2]).doubleValue(), Double.valueOf(parsed[3]).doubleValue()), CRS.decode((String)parsed[4]));
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new IllegalArgumentException("String List converter expects to convert ReferencedEnvelope <-> string only. (" + String.valueOf(source) + "), (" + String.valueOf(target) + ")");
    }
}

