/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.IAjaxCallListener;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class CodeMirrorEditor
extends FormComponentPanel<String> {
    public static final PackageResourceReference REFERENCE = new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/js/codemirror.js");
    public static final PackageResourceReference[] CSS_REFERENCE = new PackageResourceReference[]{new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/css/codemirror.css"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/css/show-hint.css"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/addon/dialog/dialog.css"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/addon/search/matchesonscrollbar.css")};
    public static final PackageResourceReference[] MODES = new PackageResourceReference[]{new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/js/xml.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/js/clike.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/js/groovy.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/js/javascript.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/js/python.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/js/ruby.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/js/css.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/js/show-hint.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/js/geocss-hint.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/js/xml-hint.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/addon/dialog/dialog.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/addon/search/searchcursor.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/addon/search/search.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/addon/search/matchesonscrollbar.js"), new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/addon/scroll/annotatescrollbar.js")};
    private TextArea<String> editor;
    private WebMarkupContainer container;
    private String mode;
    private RepeatingView customButtons;

    public CodeMirrorEditor(String id, String mode, IModel<String> model) {
        super(id, model);
        this.mode = mode;
        this.container = new WebMarkupContainer("editorContainer");
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        WebMarkupContainer toolbar = new WebMarkupContainer("toolbar");
        toolbar.setVisible(true);
        this.container.add(new Component[]{toolbar});
        this.customButtons = new RepeatingView("custom-buttons");
        toolbar.add(new Component[]{this.customButtons});
        WebMarkupContainer editorParent = new WebMarkupContainer("editorParent");
        editorParent.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"codemirror"))});
        this.container.add(new Component[]{editorParent});
        this.editor = new TextArea("editor", model);
        editorParent.add(new Component[]{this.editor});
        this.editor.setOutputMarkupId(true);
        this.editor.add(new Behavior[]{new CodeMirrorBehavior()});
    }

    public void addCustomButton(String title, String cssClass, final CustomButtonAction action) {
        this.customButtons.add(new Component[]{new AjaxLink<Object>(this.customButtons.newChildId()){

            public void onClick(AjaxRequestTarget target) {
                action.onClick(target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                String dynamicExtraParameters = "var result = {'cmSelection': getSelection()};return result;";
                attributes.getDynamicExtraParameters().add(dynamicExtraParameters);
            }
        }.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)cssClass), " ")}).add(new Behavior[]{new AttributeAppender("title", (Serializable)((Object)title), " ")})});
    }

    public CodeMirrorEditor(String id, IModel<String> model) {
        this(id, "xml", model);
    }

    public void convertInput() {
        this.editor.processInput();
        this.setConvertedInput((String)this.editor.getConvertedInput());
    }

    public String getInput() {
        return this.editor.getInput();
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new PackageResourceReference(CodeMirrorEditor.class, "js/codemirror/css/codemirrorlinenos.css")));
    }

    public void setTextAreaMarkupId(String id) {
        this.editor.setMarkupId(id);
    }

    public String getTextAreaMarkupId() {
        return this.editor.getMarkupId();
    }

    public void setMode(String mode) {
        this.mode = mode;
        Optional requestTarget = RequestCycle.get().find(AjaxRequestTarget.class);
        if (requestTarget.isPresent()) {
            String javascript = "document.gsEditors." + this.editor.getMarkupId() + ".setOption('mode', '" + mode + "');";
            ((AjaxRequestTarget)requestTarget.get()).appendJavaScript((CharSequence)javascript);
        }
    }

    public void setModeAndSubMode(String mode, String subMode) {
        this.mode = mode;
        Optional requestTarget = RequestCycle.get().find(AjaxRequestTarget.class);
        if (requestTarget.isPresent()) {
            String javascript = "document.gsEditors." + this.editor.getMarkupId() + ".setOption('mode',";
            String modeObj = "{name: \"" + mode + "\", " + subMode + ": true}";
            javascript = javascript + modeObj + ");";
            ((AjaxRequestTarget)requestTarget.get()).appendJavaScript((CharSequence)javascript);
            this.editor.modelChanged();
            ((AjaxRequestTarget)requestTarget.get()).add(new Component[]{this.editor});
        }
    }

    public void reset() {
        super.validate();
        this.editor.validate();
        this.editor.clearInput();
    }

    public IAjaxCallListener getSaveDecorator() {
        return new AjaxCallListener(){

            public CharSequence getBeforeHandler(Component component) {
                String id = CodeMirrorEditor.this.getTextAreaMarkupId();
                return "if (document.gsEditors) { document.getElementById('" + id + "').value = document.gsEditors." + id + ".getValue(); }";
            }
        };
    }

    class CodeMirrorBehavior
    extends Behavior {
        CodeMirrorBehavior() {
        }

        public void renderHead(Component component, IHeaderResponse response) {
            super.renderHead(component, response);
            for (PackageResourceReference css : CSS_REFERENCE) {
                response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)css));
            }
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)REFERENCE));
            for (PackageResourceReference mode : MODES) {
                response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)mode));
            }
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.getInitJavascript()));
        }

        private String getInitJavascript() {
            String string;
            block8: {
                InputStream is = CodeMirrorEditor.class.getResourceAsStream("CodeMirrorEditor.js");
                try {
                    String js = this.convertStreamToString(is);
                    js = js.replaceAll("\\$componentId", CodeMirrorEditor.this.editor.getMarkupId());
                    js = js.replaceAll("\\$codeMirrorEditorId", CodeMirrorEditor.this.getMarkupId());
                    js = js.replaceAll("\\$mode", CodeMirrorEditor.this.mode);
                    string = js = js.replaceAll("\\$container", CodeMirrorEditor.this.container.getMarkupId());
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                is.close();
            }
            return string;
        }

        /*
         * Exception decompiling
         */
        public String convertStreamToString(InputStream is) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static interface CustomButtonAction
    extends Serializable {
        public void onClick(AjaxRequestTarget var1);
    }
}

