/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.settings.JavaScriptLibrarySettings;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.DateConverter;

public class DateField
extends DateTextField {
    private DateConverter dateConverter;
    private boolean dateTime = false;
    private String format;
    private String dateTimeSep;
    private String DEF_DATE_FORMAT = "yyyy-MM-dd";
    private String DEF_DATE_TIME_FORMAT = this.DEF_DATE_FORMAT.concat(" HH:mm");

    public DateField(String id, IModel<Date> model, boolean dateTime, String format, String dateTimeSep) {
        super(id, model);
        this.dateTime = dateTime;
        String string = this.dateTimeSep = dateTimeSep == null ? " " : dateTimeSep;
        if (format == null) {
            format = dateTime ? this.DEF_DATE_TIME_FORMAT : this.DEF_DATE_FORMAT;
        }
        this.format = format;
        this.dateConverter = new DateConverter(){

            public DateFormat getDateFormat(Locale locale) {
                if (locale == null) {
                    locale = Locale.getDefault(Locale.Category.FORMAT);
                }
                return new SimpleDateFormat(DateField.this.format, locale);
            }
        };
    }

    public DateField(String id, IModel<Date> model, boolean dateTime) {
        this(id, model, dateTime, null, null);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.setOutputMarkupId(true);
    }

    public <D> IConverter<D> getConverter(Class<D> type) {
        DateConverter converter = this.dateConverter;
        return converter;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (!this.isEnabledInHierarchy()) {
            return;
        }
        JavaScriptLibrarySettings javaScriptSettings = this.getApplication().getJavaScriptLibrarySettings();
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)javaScriptSettings.getJQueryReference()));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(((Object)((Object)this)).getClass(), "js/datepicker/moment.min.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(((Object)((Object)this)).getClass(), "js/datepicker/jquery.datetimepicker.full.min.js")));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new PackageResourceReference(((Object)((Object)this)).getClass(), "js/datepicker/jquery.datetimepicker.min.css")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new PackageResourceReference(((Object)((Object)this)).getClass(), "DatePicker.js")));
        String initScript = ";initJQDatepicker('" + this.getMarkupId() + "'," + this.dateTime + ",'" + this.format + "','" + this.dateTimeSep + "');";
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)initScript));
    }
}

