/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.util.logging.Logging;

public class EnumChoiceRenderer
extends ChoiceRenderer<Enum<?>> {
    private static final long serialVersionUID = -8773437372842472840L;
    static final Logger LOGGER = Logging.getLogger(EnumChoiceRenderer.class);
    Component reference = null;

    public EnumChoiceRenderer(Component reference) {
        this.reference = reference;
    }

    public Object getDisplayValue(Enum<?> object) {
        try {
            ParamResourceModel rm = new ParamResourceModel(object.name(), this.reference, new Object[0]);
            return rm.getString();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to locate resource string " + String.valueOf(object) + " with context: " + String.valueOf(this.reference), e);
            return object;
        }
    }

    public String getIdValue(Enum<?> object, int index) {
        return object.name();
    }
}

