/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.stream.Streams;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.Predicates;
import org.geoserver.web.GeoServerApplication;
import org.geotools.api.filter.Filter;
import org.geotools.util.logging.Logging;

public abstract class GeoServerDataProvider<T>
extends SortableDataProvider<T, Object> {
    private static final Pattern EXACT_TERM_KEYWORD_PATTERN = Pattern.compile("^([\"'])(?<keyword>.+)\\1$");
    private static final long serialVersionUID = -6876929036365601443L;
    static final Logger LOGGER = Logging.getLogger(GeoServerDataProvider.class);
    protected String[] keywords;
    private transient Matcher[] matchers;
    IdentityHashMap<T, IModel<T>> modelCache = new IdentityHashMap();
    boolean editable = false;

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
        this.matchers = null;
    }

    protected Matcher[] getMatchers() {
        if (this.matchers != null) {
            return this.matchers;
        }
        if (this.keywords == null) {
            return new Matcher[0];
        }
        this.matchers = new Matcher[this.keywords.length];
        for (int i = 0; i < this.keywords.length; ++i) {
            String keyword = this.keywords[i];
            String regex = this.composeRegex(keyword);
            Pattern pattern = Pattern.compile(regex, 2);
            this.matchers[i] = pattern.matcher("");
        }
        return this.matchers;
    }

    private String composeRegex(String keyword) {
        Matcher exactTermKeywordMatcher = EXACT_TERM_KEYWORD_PATTERN.matcher(keyword);
        if (exactTermKeywordMatcher.matches()) {
            return ".*\\b" + this.escape(exactTermKeywordMatcher.group("keyword")) + "\\b.*";
        }
        return ".*" + this.escape(keyword) + ".*";
    }

    private String escape(String keyword) {
        String escapeSeq = "\\";
        int len = keyword.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = keyword.charAt(i);
            if (this.isSpecial(c)) {
                sb.append("\\");
            }
            sb.append(keyword.charAt(i));
        }
        return sb.toString();
    }

    private boolean isSpecial(char chr) {
        return chr == '.' || chr == '?' || chr == '*' || chr == '^' || chr == '$' || chr == '+' || chr == '[' || chr == ']' || chr == '(' || chr == ')' || chr == '|' || chr == '\\' || chr == '&';
    }

    protected GeoServerApplication getApplication() {
        return GeoServerApplication.get();
    }

    protected Catalog getCatalog() {
        return this.getApplication().getCatalog();
    }

    public Iterator<T> iterator(long first, long count) {
        List<T> items = this.getFilteredItems();
        Comparator<T> comparator = this.getComparator(this.getSort());
        if (comparator != null) {
            Collections.sort(items, comparator);
        }
        if ((long)items.size() <= count) {
            return items.iterator();
        }
        long last = first + count;
        if (last > (long)items.size()) {
            last = items.size();
        }
        return items.subList((int)first, (int)last).iterator();
    }

    protected List<T> getFilteredItems() {
        List<T> items = this.getItems();
        if (this.keywords != null && this.keywords.length > 0) {
            return this.filterByKeywords(items);
        }
        return new ArrayList<T>(items);
    }

    public long size() {
        return this.getFilteredItems().size();
    }

    public int fullSize() {
        return this.getItems().size();
    }

    private List<T> filterByKeywords(List<T> items) {
        ArrayList<T> result = new ArrayList<T>();
        Matcher[] matchers = this.getMatchers();
        List<Property<T>> properties = this.getProperties();
        block0: for (T item : items) {
            for (Property<T> property : properties) {
                Object value;
                if (!property.isSearchable() || (value = property.getPropertyValue(item)) == null) continue;
                for (Matcher matcher : matchers) {
                    matcher.reset(String.valueOf(value));
                    if (!matcher.matches()) continue;
                    result.add(item);
                    continue block0;
                }
            }
        }
        return result;
    }

    List<Property<T>> getVisibleProperties() {
        ArrayList<Property<T>> results = new ArrayList<Property<T>>();
        for (Property<T> p : this.getProperties()) {
            if (!p.isVisible()) continue;
            results.add(p);
        }
        return results;
    }

    protected abstract List<Property<T>> getProperties();

    protected abstract List<T> getItems();

    protected Comparator<T> getComparator(SortParam<?> sort) {
        Comparator<T> comparator;
        if (sort == null) {
            return null;
        }
        Property<T> property = this.getProperty(sort);
        if (property != null && (comparator = property.getComparator()) != null) {
            if (!sort.isAscending()) {
                return new ReverseComparator<T>(comparator);
            }
            return comparator;
        }
        LOGGER.log(Level.WARNING, "Could not find any comparator for sort property " + String.valueOf(sort));
        return null;
    }

    protected Property<T> getProperty(SortParam<?> sort) {
        if (sort == null || sort.getProperty() == null) {
            return null;
        }
        for (Property<T> property : this.getProperties()) {
            if (!sort.getProperty().equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public final IModel<T> model(T object) {
        if (this.editable) {
            IModel<T> result = this.modelCache.get(object);
            if (result == null) {
                result = this.newModel(object);
                this.modelCache.put(object, result);
            }
            return result;
        }
        return this.newModel(object);
    }

    protected Filter getFilter() {
        return Streams.of((Object[])this.getKeywords()).map(this::computeKeywordFilter).reduce(Predicates::or).orElseGet(Predicates::acceptAll);
    }

    private Filter computeKeywordFilter(String keyword) {
        Matcher exactTermKeywordMatcher = EXACT_TERM_KEYWORD_PATTERN.matcher(keyword);
        if (exactTermKeywordMatcher.matches()) {
            return Predicates.exactTermSearch((String)exactTermKeywordMatcher.group("keyword"));
        }
        return Predicates.fullTextSearch((String)keyword);
    }

    protected IModel<T> newModel(T object) {
        return new Model((Serializable)object);
    }

    public static interface Property<T>
    extends Serializable {
        public String getName();

        public Object getPropertyValue(T var1);

        public IModel<?> getModel(IModel<T> var1);

        public Comparator<T> getComparator();

        public boolean isVisible();

        public boolean isSearchable();
    }

    private static class ReverseComparator<T>
    implements Comparator<T> {
        Comparator<T> comparator;

        public ReverseComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(T o1, T o2) {
            return this.comparator.compare(o1, o2) * -1;
        }
    }

    public static class PropertyComparator<T>
    implements Comparator<T> {
        Property<T> property;

        public PropertyComparator(Property<T> property) {
            this.property = property;
        }

        @Override
        public int compare(T o1, T o2) {
            Comparable p1 = (Comparable)this.property.getPropertyValue(o1);
            Comparable p2 = (Comparable)this.property.getPropertyValue(o2);
            if (p1 == null) {
                return p2 != null ? -1 : 0;
            }
            if (p2 == null) {
                return 1;
            }
            return p1.compareTo(p2);
        }
    }

    public static class PropertyPlaceholder<T>
    implements Property<T> {
        private static final long serialVersionUID = -6605207892648199453L;
        String name;

        public PropertyPlaceholder(String name) {
            this.name = name;
        }

        @Override
        public Comparator<T> getComparator() {
            return null;
        }

        @Override
        public IModel<T> getModel(IModel<T> itemModel) {
            return itemModel;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getPropertyValue(T item) {
            return item;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        public String toString() {
            return "PropertyPlacehoder[" + this.name + "]";
        }

        @Override
        public boolean isSearchable() {
            return false;
        }
    }

    public static class BeanProperty<T>
    extends AbstractProperty<T> {
        private static final long serialVersionUID = 5532661316457341748L;
        String propertyPath;

        public BeanProperty(String key) {
            this(key, key, true);
        }

        public BeanProperty(String key, String propertyPath) {
            this(key, propertyPath, true);
        }

        public BeanProperty(String key, String propertyPath, boolean visible) {
            super(key, visible);
            this.propertyPath = propertyPath;
        }

        public String getPropertyPath() {
            return this.propertyPath;
        }

        @Override
        public IModel<T> getModel(IModel<T> itemModel) {
            return new PropertyModel(itemModel, this.propertyPath);
        }

        @Override
        public Object getPropertyValue(T bean) {
            if (bean == null) {
                return null;
            }
            try {
                return PropertyUtils.getProperty(bean, (String)this.propertyPath);
            }
            catch (NestedNullException nne) {
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find property " + this.propertyPath + " in " + String.valueOf(bean.getClass()), e);
            }
        }

        @Override
        public String toString() {
            return "BeanProperty[" + this.name + "]";
        }
    }

    public static abstract class AbstractProperty<T>
    implements Property<T> {
        private static final long serialVersionUID = 6286992721731224988L;
        String name;
        boolean visible;

        public AbstractProperty(String name) {
            this(name, true);
        }

        public AbstractProperty(String name, boolean visible) {
            this.name = name;
            this.visible = visible;
        }

        @Override
        public Comparator<T> getComparator() {
            return new PropertyComparator(this);
        }

        @Override
        public IModel<?> getModel(IModel<T> itemModel) {
            Object value = this.getPropertyValue(itemModel.getObject());
            if (value instanceof IModel) {
                IModel model = (IModel)value;
                return model;
            }
            return new Model((Serializable)value);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        public String toString() {
            return "Property[" + this.name + "]";
        }

        @Override
        public boolean isSearchable() {
            return true;
        }
    }
}

