/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.ResourcePool;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;

public class SRSToCRSModel
implements IModel<CoordinateReferenceSystem> {
    private static final long serialVersionUID = 1887687559796645124L;
    private static final Logger LOGGER = Logging.getLogger(SRSToCRSModel.class);
    IModel<String> srsModel;

    public SRSToCRSModel(IModel<String> srsModel) {
        this.srsModel = srsModel;
    }

    public CoordinateReferenceSystem getObject() {
        String srs = (String)this.srsModel.getObject();
        if (srs == null || "UNKNOWN".equals(srs)) {
            return null;
        }
        try {
            return CRS.decode((String)srs);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setObject(CoordinateReferenceSystem object) {
        CoordinateReferenceSystem crs = object;
        try {
            String srs = ResourcePool.lookupIdentifier((CoordinateReferenceSystem)object, (boolean)false);
            this.srsModel.setObject((Object)srs);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Failed to lookup the SRS code for " + String.valueOf(crs));
            this.srsModel.setObject(null);
        }
    }

    public void detach() {
        this.srsModel.detach();
    }
}

