/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.iterators;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import org.eclipse.imagen.iterator.RandomIter;
import org.eclipse.imagen.iterator.WritableRandomIter;
import org.eclipse.imagen.media.iterator.WrapperRI;
import org.eclipse.imagen.media.iterator.WrapperWRI;
import org.eclipse.imagen.media.iterator.WritableRandomIterFallback;
import org.eclipse.imagen.media.iterators.RandomIterFallbackByte;
import org.eclipse.imagen.media.iterators.RandomIterFallbackByteNoCache;
import org.eclipse.imagen.media.iterators.RandomIterFallbackInt;
import org.eclipse.imagen.media.iterators.RandomIterFallbackIntNoCache;
import org.eclipse.imagen.media.iterators.RandomIterFallbackNoCacheNoArray;
import org.eclipse.imagen.media.iterators.RandomIterFallbackShort;
import org.eclipse.imagen.media.iterators.RandomIterFallbackShortNoCache;

public class RandomIterFactory {
    public static RandomIter create(RenderedImage im, Rectangle bounds, boolean cachedTiles, boolean arrayCalculation) {
        if (bounds == null) {
            bounds = new Rectangle(im.getMinX(), im.getMinY(), im.getWidth(), im.getHeight());
        }
        if (arrayCalculation) {
            if (im.getMinTileX() >= -128 && im.getMinTileX() + im.getNumXTiles() - 1 <= 127 && im.getMinTileY() >= -128 && im.getMinTileY() + im.getNumYTiles() - 1 <= 127) {
                if (cachedTiles) {
                    return new RandomIterFallbackByte(im, bounds);
                }
                return new RandomIterFallbackByteNoCache(im, bounds);
            }
            if (im.getMinTileX() >= Short.MIN_VALUE && im.getMinTileX() + im.getNumXTiles() - 1 <= Short.MAX_VALUE && im.getMinTileY() >= Short.MIN_VALUE && im.getMinTileY() + im.getNumYTiles() - 1 <= Short.MAX_VALUE) {
                if (cachedTiles) {
                    return new RandomIterFallbackShort(im, bounds);
                }
                return new RandomIterFallbackShortNoCache(im, bounds);
            }
            if (cachedTiles) {
                return new RandomIterFallbackInt(im, bounds);
            }
            return new RandomIterFallbackIntNoCache(im, bounds);
        }
        return new RandomIterFallbackNoCacheNoArray(im, bounds);
    }

    public static RandomIter create(Raster ras, Rectangle bounds, boolean cachedTiles, boolean arrayCalculation) {
        WrapperRI im = new WrapperRI(ras);
        return RandomIterFactory.create((RenderedImage)im, bounds, cachedTiles, arrayCalculation);
    }

    public static WritableRandomIter createWritable(WritableRenderedImage im, Rectangle bounds) {
        if (bounds == null) {
            bounds = new Rectangle(im.getMinX(), im.getMinY(), im.getWidth(), im.getHeight());
        }
        return new WritableRandomIterFallback(im, bounds);
    }

    public static WritableRandomIter createWritable(WritableRaster ras, Rectangle bounds) {
        WrapperWRI im = new WrapperWRI(ras);
        return RandomIterFactory.createWritable((WritableRenderedImage)im, bounds);
    }

    private RandomIterFactory() {
    }
}

