/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.iterators;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.iterator.RandomIter;

public class RandomIterFallbackNoCacheNoArray
implements RandomIter {
    private RenderedImage im;
    private final Rectangle boundsRect;
    private final SampleModel sampleModel;
    private final int boundsX;
    private final int boundsY;
    private final int tileWidth;
    private final int tileHeight;
    private final int tileGridXOffset;
    private final int tileGridYOffset;

    public RandomIterFallbackNoCacheNoArray(RenderedImage im, Rectangle bounds) {
        this.im = im;
        Rectangle imBounds = new Rectangle(im.getMinX(), im.getMinY(), im.getWidth(), im.getHeight());
        this.boundsRect = imBounds.intersection(bounds);
        this.sampleModel = im.getSampleModel();
        this.boundsX = this.boundsRect.x;
        this.boundsY = this.boundsRect.y;
        this.tileWidth = im.getTileWidth();
        this.tileHeight = im.getTileHeight();
        this.tileGridXOffset = im.getTileGridXOffset();
        this.tileGridYOffset = im.getTileGridYOffset();
    }

    private Raster makeCurrent(int xLocal, int yLocal) {
        int tileX = PlanarImage.XToTileX((int)xLocal, (int)this.tileGridXOffset, (int)this.tileWidth);
        int tileY = PlanarImage.YToTileY((int)yLocal, (int)this.tileGridYOffset, (int)this.tileHeight);
        return this.im.getTile(tileX, tileY);
    }

    public int getSample(int x, int y, int b) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getSample(x - sampleModelTranslateX, y - sampleModelTranslateY, b, tile.getDataBuffer());
    }

    public float getSampleFloat(int x, int y, int b) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getSampleFloat(x - sampleModelTranslateX, y - sampleModelTranslateY, b, tile.getDataBuffer());
    }

    public double getSampleDouble(int x, int y, int b) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getSampleDouble(x - sampleModelTranslateX, y - sampleModelTranslateY, b, tile.getDataBuffer());
    }

    public int[] getPixel(int x, int y, int[] iArray) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getPixel(x - sampleModelTranslateX, y - sampleModelTranslateY, iArray, tile.getDataBuffer());
    }

    public float[] getPixel(int x, int y, float[] fArray) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getPixel(x - sampleModelTranslateX, y - sampleModelTranslateY, fArray, tile.getDataBuffer());
    }

    public double[] getPixel(int x, int y, double[] dArray) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getPixel(x - sampleModelTranslateX, y - sampleModelTranslateY, dArray, tile.getDataBuffer());
    }

    public void done() {
    }
}

