/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.iterators;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.iterator.RandomIter;

public class RandomIterFallbackShortNoCache
implements RandomIter {
    protected RenderedImage im;
    protected Rectangle boundsRect;
    protected SampleModel sampleModel;
    protected int boundsX;
    protected int boundsY;
    private short[] xTiles;
    private short[] yTiles;

    public RandomIterFallbackShortNoCache(RenderedImage im, Rectangle bounds) {
        this.im = im;
        Rectangle imBounds = new Rectangle(im.getMinX(), im.getMinY(), im.getWidth(), im.getHeight());
        this.boundsRect = imBounds.intersection(bounds);
        this.sampleModel = im.getSampleModel();
        this.boundsX = this.boundsRect.x;
        this.boundsY = this.boundsRect.y;
        int width = this.boundsRect.width;
        int height = this.boundsRect.height;
        this.xTiles = new short[width];
        this.yTiles = new short[height];
        int tileWidth = im.getTileWidth();
        int tileGridXOffset = im.getTileGridXOffset();
        int minTileX = PlanarImage.XToTileX((int)this.boundsX, (int)tileGridXOffset, (int)tileWidth);
        int offsetX = this.boundsX - PlanarImage.tileXToX((int)minTileX, (int)tileGridXOffset, (int)tileWidth);
        short tileX = (short)(minTileX & 0xFFFF);
        for (int i = 0; i < width; ++i) {
            this.xTiles[i] = tileX;
            if (++offsetX != tileWidth) continue;
            tileX = (short)(tileX + 1);
            offsetX = 0;
        }
        int tileHeight = im.getTileHeight();
        int tileGridYOffset = im.getTileGridYOffset();
        int minTileY = PlanarImage.YToTileY((int)this.boundsY, (int)tileGridYOffset, (int)tileHeight);
        int offsetY = this.boundsY - PlanarImage.tileYToY((int)minTileY, (int)tileGridYOffset, (int)tileHeight);
        short tileY = (short)(minTileY & 0xFFFF);
        for (int i = 0; i < height; ++i) {
            this.yTiles[i] = tileY;
            if (++offsetY != tileHeight) continue;
            tileY = (short)(tileY + 1);
            offsetY = 0;
        }
    }

    private Raster makeCurrent(int xLocal, int yLocal) {
        short tileX = this.xTiles[xLocal];
        short tileY = this.yTiles[yLocal];
        return this.im.getTile(tileX, tileY);
    }

    public int getSample(int x, int y, int b) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getSample(x - sampleModelTranslateX, y - sampleModelTranslateY, b, tile.getDataBuffer());
    }

    public float getSampleFloat(int x, int y, int b) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getSampleFloat(x - sampleModelTranslateX, y - sampleModelTranslateY, b, tile.getDataBuffer());
    }

    public double getSampleDouble(int x, int y, int b) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getSampleDouble(x - sampleModelTranslateX, y - sampleModelTranslateY, b, tile.getDataBuffer());
    }

    public int[] getPixel(int x, int y, int[] iArray) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getPixel(x - sampleModelTranslateX, y - sampleModelTranslateY, iArray, tile.getDataBuffer());
    }

    public float[] getPixel(int x, int y, float[] fArray) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getPixel(x - sampleModelTranslateX, y - sampleModelTranslateY, fArray, tile.getDataBuffer());
    }

    public double[] getPixel(int x, int y, double[] dArray) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getPixel(x - sampleModelTranslateX, y - sampleModelTranslateY, dArray, tile.getDataBuffer());
    }

    public void done() {
        this.xTiles = null;
        this.yTiles = null;
    }
}

