/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.iterators;

import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import org.eclipse.imagen.iterator.RectIter;
import org.eclipse.imagen.iterator.WritableRectIter;
import org.eclipse.imagen.media.iterator.RectIterCSMFloat;
import org.eclipse.imagen.media.iterator.RectIterFallback;
import org.eclipse.imagen.media.iterator.WrapperRI;
import org.eclipse.imagen.media.iterator.WrapperWRI;
import org.eclipse.imagen.media.iterator.WritableRectIterCSMByte;
import org.eclipse.imagen.media.iterator.WritableRectIterCSMFloat;
import org.eclipse.imagen.media.iterator.WritableRectIterFallback;
import org.eclipse.imagen.media.iterators.RectIterCSMByte;
import org.eclipse.imagen.media.iterators.RectIterCSMByteABGR;
import org.eclipse.imagen.media.iterators.RectIterCSMByteABGRSingleBank;
import org.eclipse.imagen.media.iterators.WritableRectIterCSMByteIndexed;

public class RectIterFactory {
    private RectIterFactory() {
    }

    public static RectIter create(RenderedImage im, Rectangle bounds) {
        SampleModel sm;
        if (bounds == null) {
            bounds = new Rectangle(im.getMinX(), im.getMinY(), im.getWidth(), im.getHeight());
        }
        if ((sm = im.getSampleModel()) instanceof ComponentSampleModel) {
            switch (sm.getDataType()) {
                case 0: {
                    ComponentSampleModel csm = (ComponentSampleModel)sm;
                    int[] offsets = csm.getBandOffsets();
                    if (offsets.length == 4 && offsets[0] == 3 && offsets[1] == 2 && offsets[2] == 1 && offsets[3] == 0) {
                        int[] bankIndices = csm.getBankIndices();
                        if (bankIndices.length == 4 && bankIndices[0] == 0 && bankIndices[1] == 0 && bankIndices[2] == 0 && bankIndices[3] == 0) {
                            return new RectIterCSMByteABGRSingleBank(im, bounds);
                        }
                        return new RectIterCSMByteABGR(im, bounds);
                    }
                    return new RectIterCSMByte(im, bounds);
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    return new RectIterCSMFloat(im, bounds);
                }
            }
        }
        return new RectIterFallback(im, bounds);
    }

    public static RectIter create(Raster ras, Rectangle bounds) {
        WrapperRI im = new WrapperRI(ras);
        return RectIterFactory.create((RenderedImage)im, bounds);
    }

    public static WritableRectIter createWritable(WritableRenderedImage im, Rectangle bounds) {
        SampleModel sm;
        if (bounds == null) {
            bounds = new Rectangle(im.getMinX(), im.getMinY(), im.getWidth(), im.getHeight());
        }
        if ((sm = im.getSampleModel()) instanceof ComponentSampleModel) {
            switch (sm.getDataType()) {
                case 0: {
                    int[] offsets = ((ComponentSampleModel)sm).getBandOffsets();
                    if (offsets.length == 1 && offsets[0] == 0) {
                        return new WritableRectIterCSMByteIndexed(im, bounds);
                    }
                    return new WritableRectIterCSMByte((RenderedImage)im, bounds);
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    return new WritableRectIterCSMFloat((RenderedImage)im, bounds);
                }
            }
        }
        return new WritableRectIterFallback(im, bounds);
    }

    public static WritableRectIter createWritable(WritableRaster ras, Rectangle bounds) {
        WrapperWRI im = new WrapperWRI(ras);
        return RectIterFactory.createWritable((WritableRenderedImage)im, bounds);
    }
}

