/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.iterators.nl;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.iterator.RandomIter;

public class RandomIterFallbackLocal
implements RandomIter {
    private final RenderedImage im;
    private final Rectangle boundsRect;
    private final SampleModel sampleModel;
    private final int boundsX;
    private final int boundsY;
    private final int tileWidth;
    private final int tileHeight;
    private final int tileGridXOffset;
    private final int tileGridYOffset;
    private static final ThreadLocal<CurrentTile> iterator = new ThreadLocal<CurrentTile>(){

        @Override
        protected CurrentTile initialValue() {
            CurrentTile beanIt = new CurrentTile();
            beanIt.tile = null;
            beanIt.tileX = 0;
            beanIt.tileY = 0;
            return beanIt;
        }
    };

    public RandomIterFallbackLocal(RenderedImage im, Rectangle bounds) {
        this.im = im;
        Rectangle imBounds = new Rectangle(im.getMinX(), im.getMinY(), im.getWidth(), im.getHeight());
        this.boundsRect = imBounds.intersection(bounds);
        this.sampleModel = im.getSampleModel();
        this.boundsX = this.boundsRect.x;
        this.boundsY = this.boundsRect.y;
        this.tileWidth = im.getTileWidth();
        this.tileHeight = im.getTileHeight();
        this.tileGridXOffset = im.getTileGridXOffset();
        this.tileGridYOffset = im.getTileGridYOffset();
    }

    private Raster makeCurrent(int xLocal, int yLocal) {
        int tileXNew = PlanarImage.XToTileX((int)xLocal, (int)this.tileGridXOffset, (int)this.tileWidth);
        int tileYNew = PlanarImage.YToTileY((int)yLocal, (int)this.tileGridYOffset, (int)this.tileHeight);
        CurrentTile beanOld = iterator.get();
        Raster tileOld = beanOld.tile;
        int tileXOld = beanOld.tileX;
        int tileYOld = beanOld.tileY;
        if (tileOld == null || tileXNew != tileXOld || tileYNew != tileYOld) {
            Raster tileNew = this.im.getTile(tileXNew, tileYNew);
            CurrentTile beanNew = new CurrentTile();
            beanNew.tile = tileNew;
            beanNew.tileX = tileXNew;
            beanNew.tileY = tileYNew;
            return tileNew;
        }
        return tileOld;
    }

    public int getSample(int x, int y, int b) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getSample(x - sampleModelTranslateX, y - sampleModelTranslateY, b, tile.getDataBuffer());
    }

    public float getSampleFloat(int x, int y, int b) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getSampleFloat(x - sampleModelTranslateX, y - sampleModelTranslateY, b, tile.getDataBuffer());
    }

    public double getSampleDouble(int x, int y, int b) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getSampleDouble(x - sampleModelTranslateX, y - sampleModelTranslateY, b, tile.getDataBuffer());
    }

    public int[] getPixel(int x, int y, int[] iArray) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getPixel(x - sampleModelTranslateX, y - sampleModelTranslateY, iArray, tile.getDataBuffer());
    }

    public float[] getPixel(int x, int y, float[] fArray) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getPixel(x - sampleModelTranslateX, y - sampleModelTranslateY, fArray, tile.getDataBuffer());
    }

    public double[] getPixel(int x, int y, double[] dArray) {
        Raster tile = this.makeCurrent(x - this.boundsX, y - this.boundsY);
        int sampleModelTranslateX = tile.getSampleModelTranslateX();
        int sampleModelTranslateY = tile.getSampleModelTranslateY();
        return this.sampleModel.getPixel(x - sampleModelTranslateX, y - sampleModelTranslateY, dArray, tile.getDataBuffer());
    }

    public void done() {
        iterator.remove();
    }

    private static class CurrentTile {
        private Raster tile;
        private int tileX;
        private int tileY;

        private CurrentTile() {
        }
    }
}

