/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wcs10.CapabilitiesSectionType;
import net.opengis.wcs10.GetCapabilitiesType;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.config.SettingsInfo;
import org.geoserver.ows.ClientStreamAbortedException;
import org.geoserver.ows.URLMangler;
import org.geoserver.wcs.WCSInfo;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.global.CoverageInfoLabelComparator;
import org.vfny.geoserver.util.ResponseUtils;
import org.vfny.geoserver.wcs.WcsException;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class Wcs10CapsTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger((String)Wcs10CapsTransformer.class.getPackage().getName());
    protected static final String WCS_URI = "http://www.opengis.net/wcs";
    protected static final String CUR_VERSION = "1.0.0";
    protected static final String XSI_PREFIX = "xsi";
    protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private WCSInfo wcs;
    private Catalog catalog;
    private final boolean skipMisconfigured;

    public Wcs10CapsTransformer(GeoServer geoServer) {
        this.wcs = (WCSInfo)geoServer.getService(WCSInfo.class);
        this.catalog = geoServer.getCatalog();
        this.setNamespaceDeclarationEnabled(false);
        this.skipMisconfigured = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)geoServer.getGlobal().getResourceErrorHandling());
    }

    public Translator createTranslator(ContentHandler handler) {
        return new WCS100CapsTranslator(handler);
    }

    private class WCS100CapsTranslator
    extends TransformerBase.TranslatorSupport {
        public static final String SCHEMAS = "schemas";
        private GetCapabilitiesType request;

        public WCS100CapsTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            CapabilitiesSectionType section;
            boolean allSections;
            if (!(o instanceof GetCapabilitiesType)) {
                throw new IllegalArgumentException(new StringBuffer("Not a GetCapabilitiesType: ").append(o).toString());
            }
            this.request = (GetCapabilitiesType)o;
            long updateSequence = Wcs10CapsTransformer.this.wcs.getGeoServer().getGlobal().getUpdateSequence();
            long requestedUpdateSequence = -1L;
            if (this.request.getUpdateSequence() != null) {
                try {
                    requestedUpdateSequence = Long.parseLong(this.request.getUpdateSequence());
                }
                catch (NumberFormatException e) {
                    if (this.request.getUpdateSequence().isEmpty()) {
                        requestedUpdateSequence = 0L;
                    }
                    throw new WcsException("Invalid update sequence number format, should be an integer", WcsException.WcsExceptionCode.InvalidUpdateSequence, "updateSequence");
                }
                if (requestedUpdateSequence > updateSequence) {
                    throw new WcsException("Invalid update sequence value, it's higher than the current value, " + updateSequence, WcsException.WcsExceptionCode.InvalidUpdateSequence, "updateSequence");
                }
                if (requestedUpdateSequence == updateSequence) {
                    throw new WcsException("WCS capabilities document is current (updateSequence = " + updateSequence + ")", WcsException.WcsExceptionCode.CurrentUpdateSequence, "");
                }
            }
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "version", "version", "", Wcs10CapsTransformer.CUR_VERSION);
            attributes.addAttribute("", "xmlns:wcs", "xmlns:wcs", "", Wcs10CapsTransformer.WCS_URI);
            attributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", "http://www.w3.org/1999/xlink");
            attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", "http://www.opengis.net/ogc");
            attributes.addAttribute("", "xmlns:ows", "xmlns:ows", "", "http://www.opengis.net/ows/1.1");
            attributes.addAttribute("", "xmlns:gml", "xmlns:gml", "", "http://www.opengis.net/gml");
            String prefixDef = new StringBuffer("xmlns:").append(Wcs10CapsTransformer.XSI_PREFIX).toString();
            attributes.addAttribute("", prefixDef, prefixDef, "", Wcs10CapsTransformer.XSI_URI);
            String locationAtt = new StringBuffer(Wcs10CapsTransformer.XSI_PREFIX).append(":schemaLocation").toString();
            String locationDef = "http://www.opengis.net/wcs " + org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)org.geoserver.ows.util.ResponseUtils.appendPath((String[])new String[]{SCHEMAS, "wcs/1.0.0/wcsCapabilities.xsd"}), null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
            attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
            attributes.addAttribute("", "updateSequence", "updateSequence", "", String.valueOf(updateSequence));
            this.start("wcs:WCS_Capabilities", attributes);
            if (this.request.getSection() == null) {
                allSections = true;
                section = CapabilitiesSectionType.get((String)"/");
            } else {
                section = this.request.getSection();
                allSections = CapabilitiesSectionType.get((String)"/").equals(section);
            }
            HashSet<String> knownSections = new HashSet<String>(Arrays.asList("/", "/WCS_Capabilities/Service", "/WCS_Capabilities/Capability", "/WCS_Capabilities/ContentMetadata"));
            if (!knownSections.contains(section.getLiteral())) {
                throw new WcsException("Unknown section " + String.valueOf(section), WcsException.WcsExceptionCode.InvalidParameterValue, "Sections");
            }
            if (requestedUpdateSequence < updateSequence) {
                if (allSections || section.equals(CapabilitiesSectionType.WCS_CAPABILITIES_SERVICE_LITERAL)) {
                    this.handleService(allSections);
                }
                if (allSections || section.equals(CapabilitiesSectionType.WCS_CAPABILITIES_CAPABILITY_LITERAL)) {
                    this.handleCapabilities(allSections);
                }
                if (allSections || section.equals(CapabilitiesSectionType.WCS_CAPABILITIES_CONTENT_METADATA_LITERAL)) {
                    this.handleContentMetadata(allSections);
                }
            }
            this.end("wcs:WCS_Capabilities");
        }

        private void handleService(boolean allSections) {
            AttributesImpl attributes = new AttributesImpl();
            if (!allSections) {
                attributes.addAttribute("", "version", "version", "", Wcs10CapsTransformer.CUR_VERSION);
            }
            this.start("wcs:Service", attributes);
            if (Wcs10CapsTransformer.this.wcs.getMetadataLink() != null) {
                this.handleMetadataLink(Wcs10CapsTransformer.this.wcs.getMetadataLink(), "simple");
            }
            this.element("wcs:description", Wcs10CapsTransformer.this.wcs.getAbstract());
            this.element("wcs:name", Wcs10CapsTransformer.this.wcs.getName());
            this.element("wcs:label", Wcs10CapsTransformer.this.wcs.getTitle());
            this.handleKeywords(Wcs10CapsTransformer.this.wcs.getKeywords());
            this.handleContact();
            String fees = Wcs10CapsTransformer.this.wcs.getFees();
            if (fees == null || "".equals(fees)) {
                fees = "NONE";
            }
            this.element("wcs:fees", fees);
            String accessConstraints = Wcs10CapsTransformer.this.wcs.getAccessConstraints();
            if (accessConstraints == null || "".equals(accessConstraints)) {
                accessConstraints = "NONE";
            }
            this.element("wcs:accessConstraints", accessConstraints);
            this.end("wcs:Service");
        }

        private void handleMetadataLink(MetadataLinkInfo mdl, String linkType) {
            AttributesImpl attributes = new AttributesImpl();
            if (StringUtils.isNotBlank((CharSequence)mdl.getAbout())) {
                attributes.addAttribute("", "about", "about", "", mdl.getAbout());
            }
            if (StringUtils.isNotBlank((CharSequence)linkType)) {
                attributes.addAttribute("", "xlink:type", "xlink:type", "", linkType);
            }
            if (StringUtils.isNotBlank((CharSequence)mdl.getMetadataType())) {
                attributes.addAttribute("", "metadataType", "metadataType", "", mdl.getMetadataType());
            }
            if (StringUtils.isNotBlank((CharSequence)mdl.getContent())) {
                attributes.addAttribute("", "xlink:href", "xlink:href", "", ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)mdl, (String)this.request.getBaseUrl()));
            }
            if (attributes.getLength() > 0) {
                this.element("wcs:metadataLink", null, attributes);
            }
        }

        private void handleKeywords(List kwords) {
            if (kwords == null || kwords.isEmpty()) {
                return;
            }
            this.start("wcs:keywords");
            if (kwords != null) {
                for (Object kword : kwords) {
                    this.element("wcs:keyword", kword.toString());
                }
            }
            this.end("wcs:keywords");
        }

        private void handleContact() {
            GeoServer gs = Wcs10CapsTransformer.this.wcs.getGeoServer();
            String tmp = "";
            SettingsInfo settings = gs.getSettings();
            ContactInfo contact = settings.getContact();
            if (contact != null && (StringUtils.isNotBlank((CharSequence)contact.getContactPerson()) || StringUtils.isNotBlank((CharSequence)contact.getContactOrganization()))) {
                this.start("wcs:responsibleParty");
                tmp = contact.getContactPerson();
                if (StringUtils.isNotBlank((CharSequence)tmp)) {
                    this.element("wcs:individualName", tmp);
                } else {
                    this.element("wcs:individualName", "");
                }
                tmp = contact.getContactOrganization();
                if (StringUtils.isNotBlank((CharSequence)tmp)) {
                    this.element("wcs:organisationName", tmp);
                }
                if (StringUtils.isNotBlank((CharSequence)(tmp = contact.getContactPosition()))) {
                    this.element("wcs:positionName", tmp);
                }
                this.start("wcs:contactInfo");
                this.start("wcs:phone");
                tmp = contact.getContactVoice();
                if (StringUtils.isNotBlank((CharSequence)tmp)) {
                    this.element("wcs:voice", tmp);
                }
                if (StringUtils.isNotBlank((CharSequence)(tmp = contact.getContactFacsimile()))) {
                    this.element("wcs:facsimile", tmp);
                }
                this.end("wcs:phone");
                this.start("wcs:address");
                tmp = contact.getAddressType();
                if (StringUtils.isNotBlank((CharSequence)tmp)) {
                    String addr = contact.getAddress();
                    if (StringUtils.isNotBlank((CharSequence)addr)) {
                        this.element("wcs:deliveryPoint", tmp + " " + addr);
                    }
                } else {
                    tmp = contact.getAddress();
                    if (StringUtils.isNotBlank((CharSequence)tmp)) {
                        this.element("wcs:deliveryPoint", tmp);
                    }
                }
                tmp = contact.getAddressCity();
                if (StringUtils.isNotBlank((CharSequence)tmp)) {
                    this.element("wcs:city", tmp);
                }
                if (StringUtils.isNotBlank((CharSequence)(tmp = contact.getAddressState()))) {
                    this.element("wcs:administrativeArea", tmp);
                }
                if (StringUtils.isNotBlank((CharSequence)(tmp = contact.getAddressPostalCode()))) {
                    this.element("wcs:postalCode", tmp);
                }
                if (StringUtils.isNotBlank((CharSequence)(tmp = contact.getAddressCountry()))) {
                    this.element("wcs:country", tmp);
                }
                if (StringUtils.isNotBlank((CharSequence)(tmp = contact.getContactEmail()))) {
                    this.element("wcs:electronicMailAddress", tmp);
                }
                this.end("wcs:address");
                tmp = contact.getOnlineResource();
                if (StringUtils.isNotBlank((CharSequence)tmp)) {
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute("", "xlink:href", "xlink:href", "", tmp);
                    this.start("wcs:onlineResource", attributes);
                    this.end("wcs:onlineResource");
                }
                this.end("wcs:contactInfo");
                this.end("wcs:responsibleParty");
            }
        }

        private void handleCapabilities(boolean allSections) {
            this.start("wcs:Capability");
            this.handleRequest();
            this.handleExceptions();
            this.handleVendorSpecifics();
            this.end("wcs:Capability");
        }

        private void handleRequest() {
            this.start("wcs:Request");
            this.handleCapability("wcs:GetCapabilities");
            this.handleCapability("wcs:DescribeCoverage");
            this.handleCapability("wcs:GetCoverage");
            this.end("wcs:Request");
        }

        private void handleCapability(String capabilityName) {
            AttributesImpl attributes = new AttributesImpl();
            this.start(capabilityName);
            this.start("wcs:DCPType");
            this.start("wcs:HTTP");
            String url = org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wcs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            url = this.makeURLAppendable(url);
            attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
            this.start("wcs:Get");
            this.start("wcs:OnlineResource", attributes);
            this.end("wcs:OnlineResource");
            this.end("wcs:Get");
            this.end("wcs:HTTP");
            this.end("wcs:DCPType");
            attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
            this.start("wcs:DCPType");
            this.start("wcs:HTTP");
            this.start("wcs:Post");
            this.start("wcs:OnlineResource", attributes);
            this.end("wcs:OnlineResource");
            this.end("wcs:Post");
            this.end("wcs:HTTP");
            this.end("wcs:DCPType");
            this.end(capabilityName);
        }

        private String makeURLAppendable(String url) {
            if (url.endsWith("?") || url.endsWith("&")) {
                return url;
            }
            if (url.contains("?")) {
                return url + "&";
            }
            return url + "?";
        }

        private void handleExceptions() {
            this.start("wcs:Exception");
            ArrayList<String> exceptionFormats = Wcs10CapsTransformer.this.wcs.getExceptionFormats();
            if (exceptionFormats == null) {
                exceptionFormats = new ArrayList<String>();
            }
            if (exceptionFormats.isEmpty()) {
                exceptionFormats.add("application/vnd.ogc.se_xml");
            }
            for (String format : exceptionFormats) {
                this.element("wcs:Format", format);
            }
            this.end("wcs:Exception");
        }

        private void handleVendorSpecifics() {
        }

        private void handleEnvelope(ReferencedEnvelope referencedEnvelope, DimensionInfo timeInfo, ReaderDimensionsAccessor dimensions) throws IOException {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "srsName", "srsName", "", "urn:ogc:def:crs:OGC:1.3:CRS84");
            this.start("wcs:lonLatEnvelope", attributes);
            StringBuffer minCP = new StringBuffer(Double.toString(referencedEnvelope.getMinX())).append(" ").append(referencedEnvelope.getMinY());
            StringBuffer maxCP = new StringBuffer(Double.toString(referencedEnvelope.getMaxX())).append(" ").append(referencedEnvelope.getMaxY());
            this.element("gml:pos", minCP.toString());
            this.element("gml:pos", maxCP.toString());
            if (timeInfo != null && timeInfo.isEnabled()) {
                SimpleDateFormat timeFormat = dimensions.getTimeFormat();
                this.element("gml:timePosition", timeFormat.format(dimensions.getMinTime()));
                this.element("gml:timePosition", timeFormat.format(dimensions.getMaxTime()));
            }
            this.end("wcs:lonLatEnvelope");
        }

        private void handleContentMetadata(boolean allSections) {
            AttributesImpl attributes = new AttributesImpl();
            if (!allSections) {
                attributes.addAttribute("", "version", "version", "", Wcs10CapsTransformer.CUR_VERSION);
            }
            this.start("wcs:ContentMetadata", attributes);
            List coverages = Wcs10CapsTransformer.this.catalog.getCoverages();
            Collections.sort(coverages, new CoverageInfoLabelComparator());
            for (CoverageInfo cvInfo : coverages) {
                try {
                    this.mark();
                    this.handleCoverageOfferingBrief(cvInfo);
                    this.commit();
                }
                catch (Exception e) {
                    ClientStreamAbortedException.rethrowUncheked((Exception)e);
                    if (Wcs10CapsTransformer.this.skipMisconfigured) {
                        this.reset();
                        LOGGER.log(Level.SEVERE, "Skipping coverage: " + cvInfo.prefixedName() + " as its capabilities generation failed", e);
                        continue;
                    }
                    throw new RuntimeException("Capabilities document generation failed on coverage " + cvInfo.prefixedName(), e);
                }
            }
            this.end("wcs:ContentMetadata");
        }

        private void handleCoverageOfferingBrief(CoverageInfo cv) throws IOException {
            if (cv.isEnabled()) {
                CoverageStoreInfo csinfo;
                this.start("wcs:CoverageOfferingBrief");
                for (MetadataLinkInfo mdl : cv.getMetadataLinks()) {
                    this.handleMetadataLink(mdl, "simple");
                }
                String tmp = cv.getDescription();
                if (StringUtils.isNotBlank((CharSequence)tmp)) {
                    this.element("wcs:description", tmp);
                }
                if (StringUtils.isNotBlank((CharSequence)(tmp = cv.prefixedName()))) {
                    this.element("wcs:name", tmp);
                }
                if (StringUtils.isNotBlank((CharSequence)(tmp = cv.getTitle()))) {
                    this.element("wcs:label", tmp);
                }
                if ((csinfo = cv.getStore()) == null) {
                    throw new WcsException("Unable to acquire coverage store resource for coverage: " + cv.getName());
                }
                GridCoverage2DReader reader = null;
                try {
                    reader = (GridCoverage2DReader)cv.getGridCoverageReader(null, GeoTools.getDefaultHints());
                }
                catch (IOException e) {
                    LOGGER.severe("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
                }
                if (reader == null) {
                    throw new WcsException("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
                }
                DimensionInfo timeInfo = (DimensionInfo)cv.getMetadata().get("time", DimensionInfo.class);
                ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
                this.handleEnvelope(cv.getLatLonBoundingBox(), timeInfo, dimensions);
                this.handleKeywords(cv.getKeywords());
                this.end("wcs:CoverageOfferingBrief");
            }
        }
    }
}

